/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.speech;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory;
import de.dfki.lt.freetts.en.us.MbrolaVoiceDirectory;
import org.jpn.xucker.speech.VoiceControlerListener;
import org.jpn.xucker.speech.VoicePlayer;

public class VoiceControler {
    public static VoiceControler instance;
    private Voice voice;
    private AudioPlayer prePlayer;
    private VoiceControlerListener listener;
    private float defaultPitch;
    private float defaultPitchRange;
    private float defaultPitchShift;
    private float defaultDurationStretch;
    public static final String MBROLA_US1 = "mbrola_us1";
    public static final String MBROLA_US2 = "mbrola_us2";
    public static final String MBROLA_US3 = "mbrola_us3";
    public static final String KEVIN16 = "kevin16";
    public static final String KEVIN = "kevin";
    private boolean availeMbrola;
    private VoicePlayer voicePlayer;
    Thread thread;

    public boolean isAvaileMbrola() {
        return this.availeMbrola;
    }

    public void setAvaileMbrola(boolean availeMbrola) {
        this.availeMbrola = availeMbrola;
    }

    public static VoiceControler getInstance() {
        if (instance == null) {
            instance = new VoiceControler();
        }
        return instance;
    }

    private VoiceControler(String name) {
        this.changeVoice(name);
        this.setDefault(this.voice);
        this.voicePlayer = new VoicePlayer();
    }

    public void changeVoice(String voiceName) {
        if (this.voice != null) {
            this.voice.deallocate();
            this.voice = null;
        }
        if (voiceName.equals(MBROLA_US1) || voiceName.equals(MBROLA_US2) || voiceName.equals(MBROLA_US3)) {
            if (this.availeMbrola) {
                MbrolaVoiceDirectory directory = new MbrolaVoiceDirectory();
                Voice[] voices = directory.getVoices();
                int i = 0;
                while (i < voices.length) {
                    if (voices[i].getName().equals(voiceName)) {
                        this.voice = voices[i];
                    }
                    ++i;
                }
            }
        } else if (voiceName.equals(KEVIN16)) {
            KevinVoiceDirectory kevin = new KevinVoiceDirectory();
            Voice[] voices = kevin.getVoices();
            int i = 0;
            while (i < voices.length) {
                if (voices[i].getName().equals(voiceName)) {
                    this.voice = voices[i];
                }
                ++i;
            }
        }
        if (this.voice == null) {
            throw new RuntimeException("voice not found");
        }
        this.voice.allocate();
        this.setDefault(this.voice);
    }

    public void setDefault(Voice voice) {
        this.defaultPitch = voice.getPitch();
        this.defaultDurationStretch = voice.getDurationStretch();
        this.defaultPitchRange = voice.getPitchRange();
        this.defaultPitchShift = voice.getPitchShift();
    }

    private VoiceControler() {
        this(KEVIN16);
    }

    public void dispose() {
        this.voice.deallocate();
    }

    public VoiceControlerListener getListener() {
        return this.listener;
    }

    public void setListener(VoiceControlerListener listener) {
        this.listener = listener;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public float getDefaultPitch() {
        return this.defaultPitch;
    }

    public float getDefaultDurationStretch() {
        return this.defaultDurationStretch;
    }

    public float getDefaultPitchShift() {
        return this.defaultPitchShift;
    }

    public float getDefaultPitchRange() {
        return this.defaultPitchRange;
    }
}

