/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.util.HelpProperties;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.ParsedDocument;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.Bundle;

public class SearchIndex {
    private IndexReader ir;
    private IndexWriter iw;
    private File indexDir;
    private String locale;
    private TocManager tocManager;
    private AnalyzerDescriptor analyzerDescriptor;
    private PluginVersionInfo docPlugins;
    private HelpProperties indexedDocs;
    private static final String INDEXED_CONTRIBUTION_INFO_FILE = "indexed_contributions";
    public static final String INDEXED_DOCS_FILE = "indexed_docs";
    private static final String DEPENDENCIES_VERSION_FILENAME = "indexed_dependencies";
    private static final String LUCENE_PLUGIN_ID = "org.apache.lucene";
    private File inconsistencyFile;
    private HTMLDocParser parser;
    private IndexSearcher searcher;
    private Object searcherCreateLock = new Object();
    private HelpProperties dependencies;
    private boolean closed = false;
    private Collection searches = new ArrayList();
    private FileLock lock;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchIndex(String locale, AnalyzerDescriptor analyzerDesc, TocManager tocManager) {
        this.locale = locale;
        this.analyzerDescriptor = analyzerDesc;
        this.tocManager = tocManager;
        this.indexDir = new File(HelpBasePlugin.getConfigurationDirectory(), "index/" + locale);
        this.inconsistencyFile = new File(this.indexDir.getParentFile(), String.valueOf(locale) + ".inconsistent");
        this.parser = new HTMLDocParser();
        if (this.exists()) return;
        try {
            if (!this.tryLock()) return;
            try {
                this.unzipProductIndex();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.releaseLock();
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.releaseLock();
                return;
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addDocument(String name, URL url) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.addDocument(" + name + ", " + url + ")");
        }
        try {
            Document doc = new Document();
            doc.add(Field.Keyword((String)"name", (String)name));
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    HelpBasePlugin.logError(HelpBaseResources.getString("ES25", name), null);
                    Object var6_5 = null;
                    this.parser.closeDocument();
                    return false;
                }
                ParsedDocument parsed = new ParsedDocument(this.parser.getContentReader());
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = this.parser.getTitle();
                doc.add(Field.UnStored((String)"title", (String)title));
                doc.add(Field.UnStored((String)"exact_title", (String)title));
                doc.add(Field.UnIndexed((String)"raw_title", (String)title));
                this.iw.addDocument(doc);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.parser.closeDocument();
                throw throwable;
            }
            {
                Object var6_7 = null;
                this.parser.closeDocument();
            }
            this.indexedDocs.put(name, "0");
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES16", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
    }

    public synchronized boolean beginAddBatch() {
        try {
            if (this.iw != null) {
                this.iw.close();
            }
            boolean create = false;
            if (!this.exists()) {
                create = true;
                this.indexDir.mkdirs();
                if (!this.indexDir.exists()) {
                    return false;
                }
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.iw = new IndexWriter(this.indexDir, this.analyzerDescriptor.getAnalyzer(), create);
            this.iw.mergeFactor = 20;
            this.iw.maxFieldLength = 1000000;
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES17"), e);
            return false;
        }
    }

    public synchronized boolean beginDeleteBatch() {
        try {
            if (this.ir != null) {
                this.ir.close();
            }
            this.indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
            this.indexedDocs.restore();
            this.setInconsistent(true);
            this.ir = IndexReader.open((File)this.indexDir);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES18"), e);
            return false;
        }
    }

    public boolean removeDocument(String name) {
        if (HelpBasePlugin.DEBUG_SEARCH) {
            System.out.println("SearchIndex.removeDocument(" + name + ")");
        }
        Term term = new Term("name", name);
        try {
            this.ir.delete(term);
            this.indexedDocs.remove(name);
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES22", name, this.indexDir.getAbsolutePath()), e);
            return false;
        }
        return true;
    }

    public synchronized boolean endAddBatch() {
        try {
            if (this.iw == null) {
                return false;
            }
            this.iw.optimize();
            this.iw.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES19"), e);
            return false;
        }
    }

    public synchronized boolean endDeleteBatch() {
        try {
            if (this.ir == null) {
                return false;
            }
            this.ir.close();
            this.indexedDocs.save();
            this.indexedDocs = null;
            this.getDocPlugins().save();
            this.saveDependencies();
            this.setInconsistent(false);
            return true;
        }
        catch (IOException e) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES20"), e);
            return false;
        }
    }

    public boolean exists() {
        return this.indexDir.exists() && !this.isInconsistent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(ISearchQuery searchQuery, ISearchHitCollector collector) throws QueryTooComplexException {
        block12: {
            block11: {
                try {
                    block10: {
                        try {
                            if (this.closed) {
                                Object var7_3 = null;
                                break block10;
                            }
                            this.registerSearch(Thread.currentThread());
                            if (this.closed) {
                                break block11;
                            }
                            QueryBuilder queryBuilder = new QueryBuilder(searchQuery.getSearchWord(), this.analyzerDescriptor);
                            Query luceneQuery = queryBuilder.getLuceneQuery(searchQuery.getFieldNames(), searchQuery.isFieldSearch());
                            String highlightTerms = queryBuilder.gethighlightTerms();
                            if (luceneQuery != null) {
                                if (this.searcher == null) {
                                    this.openSearcher();
                                }
                                Hits hits = this.searcher.search(luceneQuery);
                                collector.addHits(hits, highlightTerms);
                            }
                            break block12;
                        }
                        catch (QueryTooComplexException qe) {
                            throw qe;
                        }
                        catch (Exception e) {
                            HelpBasePlugin.logError(HelpBaseResources.getString("ES21", searchQuery.getSearchWord()), e);
                            break block12;
                        }
                    }
                    this.unregisterSearch(Thread.currentThread());
                    return;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    this.unregisterSearch(Thread.currentThread());
                    throw throwable;
                }
            }
            Object var7_4 = null;
            this.unregisterSearch(Thread.currentThread());
            return;
        }
        Object var7_6 = null;
        this.unregisterSearch(Thread.currentThread());
    }

    public String getLocale() {
        return this.locale;
    }

    public PluginVersionInfo getDocPlugins() {
        if (this.docPlugins == null) {
            Collection docPluginsIds = this.tocManager.getContributingPlugins();
            this.docPlugins = new PluginVersionInfo(INDEXED_CONTRIBUTION_INFO_FILE, docPluginsIds, this.indexDir, !this.exists());
        }
        return this.docPlugins;
    }

    public HelpProperties getIndexedDocs() {
        HelpProperties indexedDocs = new HelpProperties(INDEXED_DOCS_FILE, this.indexDir);
        if (this.exists()) {
            indexedDocs.restore();
        }
        return indexedDocs;
    }

    private HelpProperties getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HelpProperties(DEPENDENCIES_VERSION_FILENAME, this.indexDir);
            this.dependencies.restore();
        }
        return this.dependencies;
    }

    private String readAnalyzerId() {
        String analyzerVersion = this.getDependencies().getProperty("analyzer");
        if (analyzerVersion == null) {
            return "";
        }
        return analyzerVersion;
    }

    private boolean isLuceneCompatible() {
        String usedLuceneVersion = this.getDependencies().getProperty("lucene");
        String currentLuceneVersion = "";
        Bundle lucenePluginDescriptor = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (lucenePluginDescriptor != null) {
            currentLuceneVersion = String.valueOf(currentLuceneVersion) + (String)lucenePluginDescriptor.getHeaders().get("Bundle-Version");
        }
        return currentLuceneVersion.equals(usedLuceneVersion);
    }

    private void saveDependencies() {
        this.getDependencies().put("analyzer", this.analyzerDescriptor.getId());
        Bundle luceneBundle = Platform.getBundle((String)LUCENE_PLUGIN_ID);
        if (luceneBundle != null) {
            String luceneBundleVersion = "" + luceneBundle.getHeaders().get("Bundle-Version");
            this.getDependencies().put("lucene", luceneBundleVersion);
        } else {
            this.getDependencies().put("lucene", "");
        }
        this.getDependencies().save();
    }

    public boolean isInconsistent() {
        if (this.inconsistencyFile.exists()) {
            return true;
        }
        return !this.isLuceneCompatible() || !this.analyzerDescriptor.isCompatible(this.readAnalyzerId());
    }

    public void setInconsistent(boolean inconsistent) {
        if (inconsistent) {
            try {
                FileOutputStream fos = new FileOutputStream(this.inconsistencyFile);
                fos.close();
            }
            catch (IOException iOException) {}
        } else {
            this.inconsistencyFile.delete();
        }
    }

    public void openSearcher() throws IOException {
        Object object = this.searcherCreateLock;
        synchronized (object) {
            if (this.searcher == null) {
                this.searcher = new IndexSearcher(this.indexDir.getAbsolutePath());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.closed = true;
        var1_1 = this.searches;
        synchronized (var1_1) {
            while (true) {
                if (this.searches.size() <= 0) {
                    if (this.searcher == null) return;
                    ** try [egrp 2[TRYBLOCK] [1 : 44->54)] { 
lbl9:
                    // 1 sources

                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException v0) {}
            }
            {
                this.searcher.close();
            }
lbl17:
            // 1 sources

            catch (IOException v1) {}
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipProductIndex() {
        String indexPluginId = HelpBasePlugin.getDefault().getPluginPreferences().getString("productIndex");
        if (indexPluginId == null) return;
        if (indexPluginId.length() <= 0) {
            return;
        }
        InputStream zipIn = ResourceLocator.openFromPlugin((String)indexPluginId, (String)"doc_index.zip", (String)this.getLocale());
        if (zipIn == null) {
            return;
        }
        byte[] buf = new byte[8192];
        File destDir = this.indexDir;
        ZipInputStream zis = new ZipInputStream(zipIn);
        FileOutputStream fos = null;
        try {
            block19: {
                try {
                    block10: while (true) {
                        ZipEntry zEntry;
                        if ((zEntry = zis.getNextEntry()) == null) {
                            if (HelpBasePlugin.DEBUG_SEARCH) {
                                System.out.println("SearchIndex: Prebuilt index restored to " + destDir + ".");
                            }
                            break;
                        }
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        fos = new FileOutputStream(outFile);
                        int n = 0;
                        while (true) {
                            if ((n = zis.read(buf)) < 0) {
                                fos.close();
                                continue block10;
                            }
                            fos.write(buf, 0, n);
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (fos == null) break block19;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                zipIn.close();
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        zipIn.close();
        if (zis == null) return;
        zis.close();
    }

    public synchronized boolean needsUpdating() {
        if (!this.exists()) {
            return true;
        }
        return this.getDocPlugins().detectChange();
    }

    public TocManager getTocManager() {
        return this.tocManager;
    }

    private void registerSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.add(t);
        }
    }

    private void unregisterSearch(Thread t) {
        Collection collection = this.searches;
        synchronized (collection) {
            this.searches.remove(t);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean tryLock() throws OverlappingFileLockException {
        if (this.lock != null) {
            throw new OverlappingFileLockException();
        }
        File lockFile = new File(this.indexDir.getParentFile(), String.valueOf(this.locale) + ".lock");
        lockFile.getParentFile().mkdirs();
        try {
            RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
            FileLock l = raf.getChannel().tryLock();
            if (l != null) {
                this.lock = l;
                return true;
            }
        }
        catch (IOException iOException) {
            this.lock = null;
        }
        return false;
    }

    public synchronized void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
            }
            catch (IOException iOException) {}
            this.lock = null;
        }
    }
}

