/* Copyright (c) 2000-2003                             */
/*   Takao Kobayashi, Takashi Masuko, Masatsune Tamura */
/*   Tokyo Institute of Technology                     */
/*   Keiichi Tokuda, Takayoshi Yoshimura, Heiga Zen    */
/*   Nagoya Institute of Technology                    */
/*   All rights reserved                               */

#include <stdio.h>
#include <stdlib.h>
#include "synthesis.h"
#include "defaults.h"
#include "misc.h"
#include "mlpg.h"
#include "vocoder.h"
#include "tree.h"
#include "confpara.h"
#include "hmmsynth.h"

int ErrMsg(char *,...);
void restart(int);

extern int already_talked;

void do_synthesis()
{
  int nframe;
  int total;

	total = SAMPLE_RATE * FRAME_RATE * (totalframe - 1)/ 1000;

  wave.rate = SAMPLE_RATE;
  if ((wave.data = (short *) calloc (SAMPLE_RATE * FRAME_RATE * (totalframe - 1)/ 1000, sizeof (short))) == NULL)
    {
      ErrMsg("Memory allocation error !\n");
      restart(1);
    }

  for(nframe = 0; nframe < totalframe; nframe++)
    {
/* for power modification */ 
      coeff[nframe][0] = power.data[nframe];

/* MLSA filter */
      vocoder(f0.data[nframe],coeff[nframe],mceppst.order,alpha.data[nframe]);
    }

	already_talked = 0;
}
