/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"synthesis.h"
#include	"accent.h"

int LogMsg(char *,...);
int ErrMsg(char *,...);
void restart(int);

/* ŏɈx */
void init_mora()
{
	mrhead = mrtail = NULL;
}

/* ͕Ƃ */
/* gĂ郂[̃Z̊J */
void refresh_mora()
{
	MORA *mora, *next;

	mora = mrhead;
	while( mora )  {
		next = mora->next;
		free( mora->yomi );
		free( mora );
		mora = next;
	}
	mrhead = mrtail = NULL;
}

MORA *new_mora()
{
	MORA *mora;

	mora = (MORA*) malloc( sizeof(MORA) );
	if( ! mora )  {
		ErrMsg( "* malloc error for 'mora'\n" );
		restart(1);
	}

/* [Z`F[̒ɓ */
	if( mrhead == NULL )  {
		/* ߂̃Z */
		mrhead = mrtail = mora;
		mora->prev = mora->next = NULL;
	} else {
		/* tail ̌ɒǉ */
		mrtail->next = mora;
		mora->prev = mrtail;
		mora->next = NULL;
		mrtail = mora;
	}
	mora->parent = NULL;

	mora->yomi = NULL;
	mora->position = -1;
	mora->acdist = -1;
	mora->chouonka = NO;
	mora->silence = NON;
	mora->phead = mora->ptail = NULL;

	return mora;
}

/* \L烂[̃f[^A[Ԃ */
int make_mora_data( MORPH *morph, char *yomi )
{
	int 	hinshi, nmora, len;
	short 	c1, c2;
	MORA	*mora=NULL;
	char	*p;

	hinshi = morph->hinshiID;

/* J^JiŏĂ邩ǂ`FbNĂ */
	p = yomi;
	while( *p )  {
		if( strcmp("A",p)==0 )  break;
		if( strcmp("B",p)==0 )  break;
		if( strcmp("H",p)==0 )  break;

		/* J^JiłȂ΃G[B 0xA1,0xBC ́u[v*/
		c1 = (*p)&0xFF;
		c2 = (*(p+1))&0xFF;
//		if( !( c1==0xA5 && (c2>=0xA1 && c2<=0xF6) ) &&
//		    !( c1==0xA1 && c2==0xBC ) )  {
		if( !( c1==0x83 && (c2>=0x3f && c2<=0x96) ) &&
		    !( c1==0x81 && c2==0x5b ) )  {
			ErrMsg( "* yomi is NOT katakana ... %s (%x,%x)\n", 
				yomi, c1, c2 );
			return 0;
		}
		p += 2;
	}

	nmora = 0;
	while( *yomi )  {
		mora = new_mora();
		mora->parent = morph;
		if( nmora == 0 )  morph->mrhead = mora;

		p = yomi+2;
		if( strncmp("@",p,2)==0 ||
			strncmp("B",p,2)==0 ||
			strncmp("D",p,2)==0 ||
			strncmp("F",p,2)==0 ||
			strncmp("H",p,2)==0 ||
			strncmp("",p,2)==0 ||
			strncmp("",p,2)==0 ||
			strncmp("",p,2)==0 )  {
				len = 4;
		} else {
				len = 2;
		}

		mora->yomi = (char *) malloc( sizeof(char) * (len+1) );
		if( ! mora->yomi )  {
			ErrMsg( "* malloc error for 'mora.yomi'\n" );
			restart(1);
		}
		memcpy( mora->yomi, yomi, len );
		mora->yomi[len] = '\0';

		if( strcmp(mora->yomi,"[")==0 )  mora->chouonka = YES;
		++nmora;
		yomi += len;
	}
	morph->mrtail = mora;

	return nmora;
}

void make_silence_mora( MORPH *morph )
{
	MORA *mora;

	/* Ǎ u  ȂO v ł́A|[YȂB*/
	if( morph->hinshiID == H_KAKKO_HIRAKU &&   /* u Ȃ */
		morph->prev->silence != NON )  return;
	if( morph->hinshiID == H_KAKKO_TOJIRU &&	/* vȂ */
		morph->next->silence != NON )  return;

	mora = new_mora();

	mora->yomi = (char *) malloc( sizeof(char) * 5 );
	if( ! mora->yomi )  {
		ErrMsg( "* malloc error for 'mora.yomi of SILENCE'\n" );
		restart(1);
	}
	if( morph->silence == PAU )  {
		strcpy( mora->yomi, "pau" );
	} else if( morph->silence == SILB )  {
		strcpy( mora->yomi, "silB" );
	} else if( morph->silence == SILE )  {
		strcpy( mora->yomi, "silE" );
	} else {
		ErrMsg( "* Unknown silence in make_silence_mora\n" );
		strcpy( mora->yomi, "pau" );
/*		restart(1);	*/
	}
	mora->parent = morph;
	morph->mrhead = morph->mrtail = mora;
	mora->silence = morph->silence;
}

void make_mora()
{
	MORPH *morph;

	for( morph=mphead; morph; morph=morph->next )  {
		if( morph->silence == NON )  {
			morph->nmora = make_mora_data( morph, morph->pron );
			if( morph->nmora == 0 ) {
				morph->silence = PAU;
				make_silence_mora( morph );
			}
		} else {
			make_silence_mora( morph );
			morph->nmora = 0;	/* |[YÃ[ 0  */
		}
	}
}

void print_mora()
{
	MORA *mora;

	LogMsg( "* mora data\n" );
	for( mora=mrhead; mora; mora=mora->next )  {
		LogMsg( "%s", mora->yomi );
		if( mora->devoiced == YES )  LogMsg( "*" );
/*		if( mora->silence == SILB )  LogMsg( "SB" );
		if( mora->silence == SILE )  LogMsg( "SE" );
		if( mora->silence == PAU )  LogMsg( "P" );
*/
		LogMsg( " " );
	}
	LogMsg( "\n" );
}
