/* Copyright (c) 2000-2003                             */
/*   Takao Kobayashi, Takashi Masuko, Masatsune Tamura */
/*   Tokyo Institute of Technology                     */
/*   Keiichi Tokuda, Takayoshi Yoshimura, Heiga Zen    */
/*   Nagoya Institute of Technology                    */
/*   All rights reserved                               */

/************************************************************************
*                                                                       *
*   PDF search functions from decision tree                             *
*                                                                       *
*                                        2000.1 M.Tamura                *
*                                                                       *
************************************************************************/

#ifndef _TREE_H_
#define _TREE_H_

#include "misc.h"

typedef struct _Pattern{
  char *pat;
  struct _Pattern *next;
} Pattern;

typedef struct _Question{
  char *quest;
  Pattern *phead;
  Pattern *ptail;
  struct _Question *next;
} Question;

typedef struct _Node{
  char *name;
  int num;
  struct _Node *yes;
  struct _Node *no;
  int yesnum;
  int nonum;
  char *yespdf;
  char *nopdf;
  Question *quest;
  struct _Node *next;
} Node;
   
typedef struct _Tree{
  Mtype mt;
  char *phone;
  int state;
  struct _Tree *next;
  Node *parent;
  Node *nhead;
  Node *ntail;
} Tree;

void ReadTreeFile (FILE *, Mtype, int);
char *TraverseTree (char *, Node *);
void GetToken (FILE *, char *);

#endif //_TREE_H_
