/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.EmptyPropertyPage;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;

public class PropertyPageNode
extends PreferenceNode
implements IPluginContribution {
    private RegistryPageContributor contributor;
    private IWorkbenchPropertyPage page;
    private Image icon;
    private IAdaptable element;

    public PropertyPageNode(RegistryPageContributor contributor, IAdaptable element) {
        super(contributor.getPageId());
        this.contributor = contributor;
        this.element = element;
    }

    public void createPage() {
        try {
            this.page = this.contributor.createPage(this.element);
        }
        catch (CoreException e) {
            ErrorDialog.openError(null, (String)WorkbenchMessages.getString("PropertyPageNode.errorTitle"), (String)WorkbenchMessages.getString("PropertyPageNode.errorMessage"), (IStatus)e.getStatus());
            this.page = new EmptyPropertyPage();
        }
        this.setPage(this.page);
    }

    public void disposeResources() {
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
        if (this.icon != null) {
            this.icon.dispose();
            this.icon = null;
        }
    }

    public Image getLabelImage() {
        ImageDescriptor desc;
        if (this.icon == null && (desc = this.contributor.getPageIcon()) != null) {
            this.icon = desc.createImage();
        }
        return this.icon;
    }

    public String getLabelText() {
        return this.contributor.getPageName();
    }

    public boolean fromPlugin() {
        return true;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.contributor.getPluginId();
    }
}

