/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;

public class DeleteVisitor
implements IUnifiedTreeVisitor,
ICoreConstants {
    protected IProgressMonitor monitor;
    protected boolean force;
    protected boolean keepHistory;
    protected MultiStatus status;
    protected List skipList;
    protected boolean convertToPhantom;

    public DeleteVisitor(List skipList, boolean force, boolean convertToPhantom, boolean keepHistory, IProgressMonitor monitor) {
        this.skipList = skipList;
        this.force = force;
        this.convertToPhantom = convertToPhantom;
        this.keepHistory = keepHistory;
        this.monitor = monitor;
        this.status = new MultiStatus("org.eclipse.core.resources", 273, Policy.bind("localstore.deleteProblem"), null);
    }

    protected void delete(UnifiedTreeNode node, boolean deleteLocalFile, boolean shouldKeepHistory) {
        Resource target = (Resource)node.getResource();
        try {
            File localFile;
            deleteLocalFile = deleteLocalFile && !target.isLinked() && node.existsInFileSystem();
            File file = localFile = deleteLocalFile ? new File(node.getLocalLocation()) : null;
            if (target.getType() == 2) {
                if (localFile != null) {
                    localFile.delete();
                }
                Enumeration children = node.getChildren();
                while (children.hasMoreElements()) {
                    this.delete((UnifiedTreeNode)children.nextElement(), deleteLocalFile, shouldKeepHistory);
                }
                node.removeChildrenFromTree();
                this.delete(node.existsInWorkspace() ? target : null, localFile);
                return;
            }
            if (shouldKeepHistory) {
                HistoryStore store = target.getLocalManager().getHistoryStore();
                store.addState(target.getFullPath(), localFile, node.getLastModified(), true);
            }
            this.delete(node.existsInWorkspace() ? target : null, localFile);
        }
        catch (CoreException e) {
            this.status.add(e.getStatus());
        }
    }

    protected void delete(Resource target, File localFile) {
        if (target != null) {
            try {
                if (localFile != null && !target.isLinked()) {
                    target.getLocalManager().getStore().delete(localFile);
                }
                target.deleteResource(this.convertToPhantom, this.status);
            }
            catch (CoreException e) {
                this.status.add(e.getStatus());
            }
        } else if (localFile != null) {
            localFile.delete();
        }
    }

    protected boolean equals(IResource one, IResource another) throws CoreException {
        return one.getFullPath().equals((Object)another.getFullPath());
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    protected boolean isAncestor(IResource one, IResource another) throws CoreException {
        return one.getFullPath().isPrefixOf(another.getFullPath()) && !this.equals(one, another);
    }

    protected boolean isAncestorOfResourceToSkip(IResource resource) throws CoreException {
        if (this.skipList == null) {
            return false;
        }
        int i = 0;
        while (i < this.skipList.size()) {
            IResource target = (IResource)this.skipList.get(i);
            if (this.isAncestor(resource, target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeFromSkipList(IResource resource) {
        if (this.skipList != null) {
            this.skipList.remove(resource);
        }
    }

    protected boolean shouldSkip(IResource resource) throws CoreException {
        if (this.skipList == null) {
            return false;
        }
        int i = 0;
        while (i < this.skipList.size()) {
            if (this.equals(resource, (IResource)this.skipList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean visit(UnifiedTreeNode node) throws CoreException {
        block7: {
            Resource target;
            block6: {
                block5: {
                    Policy.checkCanceled(this.monitor);
                    target = (Resource)node.getResource();
                    try {
                        if (target.getType() != 4) break block5;
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        this.monitor.worked(1);
                        throw throwable;
                    }
                    this.monitor.worked(1);
                    return true;
                }
                if (!this.shouldSkip(target)) break block6;
                this.removeFromSkipList(target);
                int ticks = target.countResources(2, false);
                this.monitor.worked(ticks);
                Object var4_4 = null;
                this.monitor.worked(1);
                return false;
            }
            if (!this.isAncestorOfResourceToSkip(target)) break block7;
            Object var4_5 = null;
            this.monitor.worked(1);
            return true;
        }
        this.delete(node, true, this.keepHistory);
        Object var4_6 = null;
        this.monitor.worked(1);
        return false;
    }
}

