/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.mediainfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jpn.xucker.rcp.mediainfo.AudioInfo;
import org.jpn.xucker.rcp.mediainfo.DefaultInfo;
import org.jpn.xucker.rcp.mediainfo.Info;

public class MediaInfoParser {
    private String mediaInfoPath;
    private String result;
    private String mediaInfoInfomation;

    public MediaInfoParser(String path) {
        this.mediaInfoPath = path;
    }

    public Info[] parse(File file) throws IOException {
        ArrayList infoList = new ArrayList();
        this.execute(infoList, file);
        return infoList.toArray(new Info[infoList.size()]);
    }

    public void execute(List infoList, File file) throws IOException {
        StringBuffer resultBuffer = new StringBuffer();
        Runtime runtime = Runtime.getRuntime();
        String[] args = new String[]{this.mediaInfoPath, "-f", file.getAbsolutePath()};
        try {
            String line;
            Process process = runtime.exec(args);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            DefaultInfo info = null;
            while ((line = reader.readLine()) != null) {
                resultBuffer.append(line);
                int sep = line.indexOf(":");
                if (line.startsWith("using MediaInfoLib")) {
                    this.mediaInfoInfomation = line;
                    continue;
                }
                if (sep != -1) {
                    if (info == null) {
                        throw new IOException("info parse failed");
                    }
                    String name = this.chopEnd(line.substring(0, sep));
                    String value = this.chopStart(line.substring(sep + 1));
                    info.addValue(name, value);
                    continue;
                }
                if (line.equals("")) continue;
                info = line.startsWith("Audio") ? new AudioInfo() : new DefaultInfo();
                info.setName(line);
                infoList.add(info);
            }
            reader.close();
            this.result = resultBuffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String chopStart(String string) {
        while (string.length() > 0 && Character.isWhitespace(string.charAt(0))) {
            string = string.substring(1);
        }
        return string;
    }

    private String chopEnd(String string) {
        while (string.length() > 0 && Character.isWhitespace(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getMediaInfoInfomation() {
        return this.mediaInfoInfomation;
    }

    public void setMediaInfoInfomation(String mediaInfoInfomation) {
        this.mediaInfoInfomation = mediaInfoInfomation;
    }
}

