/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RefreshAction
extends WorkspaceAction {
    public static final String ID = "org.eclipse.ui.RefreshAction";

    public RefreshAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.getString("RefreshAction.text"));
        this.setToolTipText(IDEWorkbenchMessages.getString("RefreshAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.refresh_action_context");
    }

    void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        File location = project.getLocation().toFile();
        if (!location.exists()) {
            String message = IDEWorkbenchMessages.format("RefreshAction.locationDeletedMessage", new Object[]{project.getName(), location.getAbsolutePath()});
            final MessageDialog dialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.getString("RefreshAction.dialogTitle"), null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() == 0) {
                project.delete(true, true, null);
            }
        }
    }

    String getOperationMessage() {
        return IDEWorkbenchMessages.getString("RefreshAction.progressMessage");
    }

    String getProblemsMessage() {
        return IDEWorkbenchMessages.getString("RefreshAction.problemMessage");
    }

    String getProblemsTitle() {
        return IDEWorkbenchMessages.getString("RefreshAction.problemTitle");
    }

    protected List getSelectedResources() {
        ArrayList<IWorkspaceRoot> resources = super.getSelectedResources();
        if (resources.isEmpty()) {
            resources = new ArrayList<IWorkspaceRoot>();
            resources.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        return resources;
    }

    void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource.getType() == 4) {
            this.checkLocationDeleted((IProject)resource);
        } else if (resource.getType() == 8) {
            IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
            int i = 0;
            while (i < projects.length) {
                this.checkLocationDeleted(projects[i]);
                ++i;
            }
        }
        resource.refreshLocal(2, monitor);
    }

    protected boolean updateSelection(IStructuredSelection s) {
        return (super.updateSelection(s) || s.isEmpty()) && this.getSelectedNonResources().size() == 0;
    }

    public void handleKeyReleased(KeyEvent event) {
        if (event.keyCode == 0x100000E && event.stateMask == 0) {
            this.refreshAll();
        }
    }

    public void refreshAll() {
        IStructuredSelection currentSelection = this.getStructuredSelection();
        this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.run();
        this.selectionChanged(currentSelection);
    }
}

