/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioProgressListener;
import org.jpn.xucker.commons.audio.splitter.JavaSoundWaveAudioCutter;
import org.jpn.xucker.commons.logging.LogUtils;

public class WaveUtils {
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.WaveUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static AudioFormat getAudioFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioInputStream ainput = AudioSystem.getAudioInputStream(file);
        AudioFormat format = ainput.getFormat();
        ainput.close();
        return format;
    }

    public static File[] splitFile(File input, int permillisecond, int expandSample, boolean appendspace, AudioProgressListener listener) throws IOException {
        long logStart = System.currentTimeMillis();
        JavaSoundWaveAudioCutter cutter = new JavaSoundWaveAudioCutter();
        AudioFormat format = null;
        try {
            format = WaveUtils.getAudioFormat(input);
        }
        catch (UnsupportedAudioFileException e2) {
            e2.printStackTrace();
        }
        long filelength = WaveUtils.countAudioMillisecond(input);
        log.trace((Object)("file-length(ms):" + filelength));
        File silenceFile = null;
        if (appendspace) {
            silenceFile = File.createTempFile("silence", ".wav");
            log.trace((Object)("create tmpFile:" + silenceFile.getAbsolutePath()));
            WaveUtils.createSilenceWaveSample(silenceFile, expandSample, format);
        }
        int expand = (int)((float)(expandSample * 1000) / format.getSampleRate());
        log.trace((Object)("expand:" + expand));
        int splitSize = (int)(filelength / (long)permillisecond);
        if (filelength % (long)permillisecond > 0L) {
            ++splitSize;
        }
        File[] resultFile = new File[splitSize];
        log.trace((Object)("splitSize=" + splitSize + ",splitmillisecond=" + permillisecond));
        File tmpMain = File.createTempFile("main", ".wav");
        log.trace((Object)("createMain:" + tmpMain.getAbsolutePath()));
        int i = 0;
        while (i < splitSize) {
            long splitEnd;
            long splitStart;
            if (listener != null && listener.isStopped()) {
                LogUtils.deleteFileTraceOrWarn(tmpMain, log);
                if (silenceFile != null) {
                    LogUtils.deleteFileTraceOrWarn(silenceFile, log);
                }
                return null;
            }
            File[] mixs = null;
            if (i == 0) {
                splitStart = 0L;
                if (i == splitSize - 1) {
                    splitEnd = filelength;
                    cutter.cut(input, splitStart, splitEnd, tmpMain);
                    resultFile[i] = File.createTempFile("split" + (i + 1) + "_", ".wav");
                    mixs = appendspace ? new File[]{silenceFile, tmpMain, silenceFile} : new File[]{tmpMain};
                } else {
                    splitEnd = permillisecond + expand;
                    cutter.cut(input, splitStart, splitEnd, tmpMain);
                    resultFile[i] = File.createTempFile("split" + (i + 1) + "_", ".wav");
                    mixs = appendspace ? new File[]{silenceFile, tmpMain} : new File[]{tmpMain};
                }
            } else if (i == splitSize - 1) {
                splitEnd = filelength;
                splitStart = i * permillisecond - expand;
                cutter.cut(input, splitStart, splitEnd, tmpMain);
                resultFile[i] = File.createTempFile("split" + (i + 1) + "_", ".wav");
                mixs = appendspace ? new File[]{tmpMain, silenceFile} : new File[]{tmpMain};
            } else {
                splitStart = i * permillisecond - expand;
                splitEnd = (i + 1) * permillisecond + expand;
                cutter.cut(input, splitStart, splitEnd, tmpMain);
                resultFile[i] = File.createTempFile("split" + (i + 1) + "_", ".wav");
                mixs = new File[]{tmpMain};
            }
            try {
                WaveUtils.mixSameFormatWaveFile(resultFile[i], mixs);
            }
            catch (UnsupportedAudioFileException e1) {
                e1.printStackTrace();
            }
            if (listener != null) {
                listener.worked(1);
            }
            ++i;
        }
        boolean result = tmpMain.delete();
        log.trace((Object)("deleted:" + tmpMain.getAbsolutePath() + " " + result));
        if (silenceFile != null) {
            LogUtils.deleteFileTraceOrWarn(silenceFile, log);
        }
        log.trace((Object)("parse-time(ms) " + (System.currentTimeMillis() - logStart)));
        return resultFile;
    }

    public static File[] splitFile(File input, int permillisecond) throws IOException {
        return WaveUtils.splitFile(input, permillisecond, 0, false, null);
    }

    public static void mixSameFormatWaveFile(File output, File[] inputs) throws UnsupportedAudioFileException, IOException {
        String tmpLog = "";
        int i = 0;
        while (i < inputs.length) {
            if (inputs[i] == null) {
                throw new IOException("inputs contain null " + tmpLog);
            }
            tmpLog = String.valueOf(tmpLog) + inputs[i].getAbsolutePath() + ",";
            ++i;
        }
        AudioFormat audioFormat = WaveUtils.getAudioFormat(inputs[0]);
        Object audioInputStream = null;
        File tmpOut = File.createTempFile("newTmp", ".wav");
        log.trace((Object)("createTmp:" + tmpOut));
        log.trace((Object)("input base:" + inputs[0]));
        log.trace((Object)("format:" + audioFormat));
        FileOutputStream fout = new FileOutputStream(tmpOut);
        int readBytes = 0;
        byte[] bytedata = new byte[10280];
        long readedByte = 0L;
        int i2 = 0;
        while (i2 < inputs.length) {
            if (inputs[i2].exists()) {
                readBytes = 0;
                readedByte = 0L;
                log.trace((Object)("read:" + inputs[i2]));
                if (inputs[i2].length() > 0L) {
                    AudioInputStream readInput = AudioSystem.getAudioInputStream(inputs[i2]);
                    while (readBytes != -1) {
                        readBytes = readInput.read(bytedata, 0, bytedata.length);
                        if (readBytes >= 0) {
                            fout.write(bytedata, 0, readBytes);
                        }
                        readedByte += (long)readBytes;
                    }
                    log.trace((Object)("written:" + readedByte + " " + inputs[i2]));
                    readInput.close();
                } else {
                    log.debug((Object)("input length: 0" + inputs[i2]));
                }
            } else {
                log.debug((Object)("input not found:" + inputs[i2]));
            }
            ++i2;
        }
        fout.close();
        log.trace((Object)("output.length:" + tmpOut.length() + ",framesize:" + audioFormat.getChannels() * audioFormat.getFrameSize()));
        AudioInputStream finalInput = new AudioInputStream(new FileInputStream(tmpOut), audioFormat, tmpOut.length() / (long)audioFormat.getFrameSize());
        long bytes = AudioSystem.write(finalInput, AudioFileFormat.Type.WAVE, output);
        log.trace((Object)("final write:" + output.getAbsolutePath()));
        log.trace((Object)("final write bytes:" + bytes));
        finalInput.close();
        boolean ret = tmpOut.delete();
        log.trace((Object)("tmp delete:" + ret));
    }

    public static long countByteAt(AudioFormat format, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        return WaveUtils.countByteAt(format.getFrameRate(), format.getSampleSizeInBits(), format.getChannels(), millisecond);
    }

    public static long countByteAt(double framerate, int samplebit, int channel, long millisecond) {
        if (millisecond == 0L) {
            return 0L;
        }
        long rateIndex = (long)(framerate / 1000.0 * (double)millisecond);
        return rateIndex * (long)samplebit / 8L * (long)channel;
    }

    public static void appendZero(OutputStream output, long samplelength, int channel, int samplebit) {
        long bt = samplelength * (long)channel * (long)samplebit / 8L;
        WaveUtils.appendZero(output, bt);
    }

    public static void appendZero(OutputStream output, long bt) {
        try {
            log.trace((Object)("bytes:" + bt));
            int buffersize = 10240;
            BufferedOutputStream bout = new BufferedOutputStream(output, buffersize);
            byte[] buff = new byte[buffersize];
            long num = bt / (long)buffersize;
            int mod = (int)(bt % (long)buffersize);
            long writted = 0L;
            int i = 0;
            while ((long)i < num) {
                bout.write(buff);
                writted += (long)buffersize;
                ++i;
            }
            bout.write(new byte[mod]);
            log.trace((Object)("writted:" + (writted += (long)mod)));
            bout.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendZero(OutputStream output, double framerate, int samplebit, int channel, long millisecond) {
        long bt = WaveUtils.countByteAt(framerate, samplebit, channel, millisecond);
        WaveUtils.appendZero(output, bt);
    }

    public static void repeatFile(File inputFile, File outputFile, int repeatTime) {
        log.trace((Object)("input " + inputFile.getAbsolutePath() + " outputFile " + outputFile + " repeat " + repeatTime));
        try {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[10240];
            int i = 0;
            while (i < repeatTime) {
                int read;
                BufferedInputStream binput = new BufferedInputStream(new FileInputStream(inputFile));
                while ((read = binput.read(buffer)) != -1) {
                    bout.write(buffer, 0, read);
                }
                binput.close();
                ++i;
            }
            bout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void repeatWave(File inputFile, File outputFile, int repeatTime, long silentmillisecond, boolean silencelast) throws IOException {
        try {
            File tmpFile = File.createTempFile("appendSilence", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            int readBytes = 0;
            byte[] bytedata = new byte[10280];
            long readedByte = 0L;
            while (readBytes != -1) {
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                fout.write(bytedata, 0, readBytes);
            }
            audioInputStream.close();
            ((InputStream)input).close();
            fout.close();
            File repeatTmpFile = File.createTempFile("repeatWave", ".wav");
            log.trace((Object)("create tmp:" + repeatTmpFile.getAbsolutePath()));
            FileOutputStream repeatOut = new FileOutputStream(repeatTmpFile);
            int i = 0;
            while (i < repeatTime) {
                WaveUtils.appendFile(tmpFile, repeatOut);
                if (i != repeatTime - 1 || silencelast) {
                    WaveUtils.appendZero(repeatOut, audioFormat.getFrameRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), silentmillisecond);
                }
                ++i;
            }
            repeatOut.close();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(repeatTmpFile), audioFormat, repeatTmpFile.length() / 4L);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
            result = repeatTmpFile.delete();
            log.trace((Object)("delte repatTmp:" + result));
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }

    private static void appendFile(File tmpFile, FileOutputStream repeatOut) {
        try {
            int b;
            BufferedOutputStream bout = new BufferedOutputStream(repeatOut);
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(tmpFile));
            while ((b = binput.read()) != -1) {
                bout.write(b);
            }
            binput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendFile(File tmpFile, File repeatTmpFile) {
        try {
            int b;
            FileOutputStream fout = new FileOutputStream(repeatTmpFile, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(tmpFile));
            while ((b = binput.read()) != -1) {
                bout.write(b);
            }
            binput.close();
            bout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createSilenceWaveSample(File outputFile, long sample, AudioFormat audioFormat) throws IOException {
        File tmpFile = File.createTempFile("appendSilence", ".wav");
        log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
        FileOutputStream fout = new FileOutputStream(tmpFile);
        WaveUtils.appendZero(fout, sample, audioFormat.getChannels(), audioFormat.getSampleSizeInBits());
        fout.close();
        AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / (long)(audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8));
        FileOutputStream output = new FileOutputStream(outputFile);
        int writtenBytes = -1;
        writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
        log.trace((Object)("write:" + writtenBytes));
        clipInput.close();
        output.close();
        boolean result = tmpFile.delete();
        log.trace((Object)("delte tmp:" + result));
    }

    public static void createSilenceWave(File outputFile, long millisecond, AudioFormat audioFormat) throws IOException {
        File tmpFile = File.createTempFile("appendSilence", ".wav");
        log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
        FileOutputStream fout = new FileOutputStream(tmpFile);
        WaveUtils.appendZero(fout, audioFormat.getFrameRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), millisecond);
        fout.close();
        AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / (long)(audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8));
        FileOutputStream output = new FileOutputStream(outputFile);
        int writtenBytes = -1;
        writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
        log.trace((Object)("write:" + writtenBytes));
        clipInput.close();
        output.close();
        boolean result = tmpFile.delete();
        log.trace((Object)("delte tmp:" + result));
    }

    public static void appendSilenceWave(File inputFile, long millisecond) {
        try {
            File tmpFile = File.createTempFile("appendSilence", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            AudioInputStream audioInputStream = null;
            audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            int readBytes = 0;
            byte[] bytedata = new byte[10280];
            long readedByte = 0L;
            while (readBytes != -1) {
                readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < 0) continue;
                fout.write(bytedata, 0, readBytes);
            }
            audioInputStream.close();
            WaveUtils.appendZero(fout, audioFormat.getFrameRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), millisecond);
            fout.close();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / (long)(audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8));
            FileOutputStream output = new FileOutputStream(inputFile);
            int writtenBytes = -1;
            writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }

    public static long countAudioSamples(File file) {
        try {
            AudioInputStream input = AudioSystem.getAudioInputStream(file);
            return input.getFrameLength();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long countAudioMillisecond(File file) {
        try {
            AudioInputStream input = AudioSystem.getAudioInputStream(file);
            long samples = input.getFrameLength();
            AudioFormat format = input.getFormat();
            return samples * 1000L / (long)((int)format.getSampleRate());
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

