/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio.splitter;

import gpl.Mp3Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.audio.splitter.AudioSplitter;
import org.tritonus.share.sampled.AudioFileTypes;
import org.tritonus.share.sampled.Encodings;

public class WaveAudioMP3AbleSplitter
implements AudioSplitter {
    public static Log log;
    private boolean useBuffer;
    public static final int WAVE = 0;
    public static final int MP3 = 1;
    private int format = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.splitter.WaveAudioMP3AbleSplitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public WaveAudioMP3AbleSplitter() {
        System.setProperty("tritonus.lame.effective.bitrate", "128");
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public boolean isUseBuffer() {
        return this.useBuffer;
    }

    public void setUseBuffer(boolean useBuffer) {
        this.useBuffer = useBuffer;
    }

    private void insplit(long startmillisecond, long endmillisecond, File inputFile, OutputStream output) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = null;
        audioInputStream = AudioSystem.getAudioInputStream(inputFile);
        AudioFormat format = audioInputStream.getFormat();
        long startByte = WaveUtils.countByteAt(format, startmillisecond);
        long endByte = WaveUtils.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start:" + startByte));
            log.trace((Object)("end:" + endByte));
            log.trace((Object)("play:" + playByte));
            log.trace((Object)("bit:" + (float)(format.getChannels() * (format.getSampleSizeInBits() / 8)) * format.getFrameRate()));
        }
        audioInputStream.skip(startByte);
        int readBytes = 0;
        byte[] bytedata = new byte[1028];
        long readedByte = 0L;
        while (readBytes != -1) {
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            if (readedByte + (long)readBytes >= playByte) {
                output.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                break;
            }
            output.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        audioInputStream.close();
    }

    private void insplit(long startmillisecond, long endmillisecond, InputStream input, OutputStream output) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = null;
        audioInputStream = AudioSystem.getAudioInputStream(input);
        AudioFormat format = audioInputStream.getFormat();
        long startByte = WaveUtils.countByteAt(format, startmillisecond);
        long endByte = WaveUtils.countByteAt(format, endmillisecond);
        long playByte = endByte - startByte;
        if (log.isTraceEnabled()) {
            log.trace((Object)("start:" + startByte));
            log.trace((Object)("end:" + endByte));
            log.trace((Object)("play:" + playByte));
            log.trace((Object)("bit:" + (float)(format.getChannels() * format.getSampleSizeInBits()) * format.getFrameRate()));
        }
        audioInputStream.skip(startByte);
        int readBytes = 0;
        byte[] bytedata = new byte[1028];
        long readedByte = 0L;
        while (readBytes != -1) {
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes < 0) continue;
            if (readedByte + (long)readBytes >= playByte) {
                output.write(bytedata, 0, Math.min((int)(playByte - readedByte), readBytes));
                break;
            }
            output.write(bytedata, 0, readBytes);
            readedByte += (long)readBytes;
        }
        audioInputStream.close();
    }

    private void splitFileBuffer(long startmillisecond, long endmillisecond, File inputFile, File outputFile) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            FileInputStream input = new FileInputStream(inputFile);
            this.insplit(startmillisecond, endmillisecond, inputFile, (OutputStream)bout);
            bout.close();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream clipInput = new AudioInputStream(new ByteArrayInputStream(bout.toByteArray()), audioFormat, bout.size() / 4);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            if (this.format == 1) {
                AudioFileFormat.Type targetType = AudioFileTypes.getType((String)"MP3", (String)"mp3");
                audioInputStream = Mp3Encoder.getConvertedStream((AudioInputStream)clipInput, (AudioFormat.Encoding)Encodings.getEncoding((String)"MPEG1L3"));
                writtenBytes = AudioSystem.write(audioInputStream, targetType, output);
            } else {
                writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            }
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void split(long startmillisecond, long endmillisecond, File inputFile, File outputFile) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(String.valueOf(startmillisecond) + "," + endmillisecond + "," + inputFile.getAbsolutePath() + "," + outputFile.getAbsolutePath()));
        }
        if (this.useBuffer) {
            this.splitFileBuffer(startmillisecond, endmillisecond, inputFile, outputFile);
        } else {
            this.splitFileTmpFile(startmillisecond, endmillisecond, inputFile, outputFile);
        }
    }

    private void splitFileTmpFile(long startmillisecond, long endmillisecond, File inputFile, File outputFile) {
        try {
            File tmpFile = File.createTempFile("wavsplitter", ".wav");
            log.trace((Object)("create tmp:" + tmpFile.getAbsolutePath()));
            FileOutputStream fout = new FileOutputStream(tmpFile);
            FileInputStream input = new FileInputStream(inputFile);
            this.insplit(startmillisecond, endmillisecond, inputFile, (OutputStream)fout);
            fout.close();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputFile);
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream clipInput = new AudioInputStream(new FileInputStream(tmpFile), audioFormat, tmpFile.length() / 4L);
            FileOutputStream output = new FileOutputStream(outputFile);
            int writtenBytes = -1;
            if (this.format == 1) {
                AudioFileFormat.Type targetType = AudioFileTypes.getType((String)"MP3", (String)"mp3");
                audioInputStream = Mp3Encoder.getConvertedStream((AudioInputStream)clipInput, (AudioFormat.Encoding)Encodings.getEncoding((String)"MPEG1L3"));
                writtenBytes = AudioSystem.write(audioInputStream, targetType, output);
            } else {
                writtenBytes = AudioSystem.write(clipInput, AudioFileFormat.Type.WAVE, output);
            }
            log.trace((Object)("write:" + writtenBytes));
            clipInput.close();
            output.close();
            boolean result = tmpFile.delete();
            log.trace((Object)("delte tmp:" + result));
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"", (Throwable)e);
        }
        catch (Exception e) {
            log.fatal((Object)"", (Throwable)e);
        }
    }
}

