/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.draw2d;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jpn.xucker.rcp.draw2d.ScalableFigure;

public class IndepentScalebleLayerdPaneCanvas
extends FigureCanvas {
    ScalableLayeredPane scalableLayeredPane;
    Dimension prevDimension;
    IndepentScalebleLayerdPaneCanvas lws = this;
    private double horizontalScale = 1.0;
    private double verticalScale = 1.0;
    private boolean baseHorizontal = true;

    public double getHorizontalScale() {
        return this.horizontalScale;
    }

    public void setHorizontalScale(double horizontalScale) {
        this.horizontalScale = horizontalScale;
    }

    public ScalableLayeredPane getScalableLayeredPane() {
        return this.scalableLayeredPane;
    }

    public void setScalableLayeredPane(ScalableLayeredPane scalableLayeredPane) {
        this.scalableLayeredPane = scalableLayeredPane;
    }

    public double getVerticalScale() {
        return this.verticalScale;
    }

    public void setVerticalScale(double verticalScale) {
        this.verticalScale = verticalScale;
    }

    public boolean isBaseHorizontal() {
        return this.baseHorizontal;
    }

    public void setBaseHorizontal(boolean baseHorizontal) {
        this.baseHorizontal = baseHorizontal;
    }

    public IndepentScalebleLayerdPaneCanvas(Composite parent) {
        super(parent);
        this.setLayout((Layout)new FillLayout());
        this.scalableLayeredPane = new ScalableLayeredPane();
        this.scalableLayeredPane.addFigureListener((FigureListener)new Resized());
        this.setContents((IFigure)this.scalableLayeredPane);
    }

    public void setScale(double newW, double newH) {
        double wchanged = newW / this.horizontalScale;
        double hchanged = newH / this.verticalScale;
        System.out.println("hzoom=" + this.verticalScale + ",newH=" + newH + ",hchanged=" + hchanged);
        int scrollX = this.lws.getHorizontalBar().getSelection();
        int scrollY = this.lws.getVerticalBar().getSelection();
        System.out.println("y-max:" + this.lws.getVerticalBar().getMaximum());
        System.out.println(this.scalableLayeredPane.getSize());
        IFigure[] figures = null;
        IndepentScalebleLayerdPaneCanvas indepentScalebleLayerdPaneCanvas = this;
        synchronized (indepentScalebleLayerdPaneCanvas) {
            figures = this.scalableLayeredPane.getChildren().toArray(new IFigure[this.scalableLayeredPane.getChildren().size()]);
        }
        this.prevDimension = this.scalableLayeredPane.getSize();
        if (this.baseHorizontal) {
            double inW = newW / newH;
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ScalableFigure) {
                    ((ScalableFigure)figures[i]).setScale(inW, 1.0);
                }
                ++i;
            }
            this.scalableLayeredPane.setScale(newH);
        } else {
            double inH = newH / newW;
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ScalableFigure) {
                    ((ScalableFigure)figures[i]).setScale(1.0, inH);
                }
                ++i;
            }
            this.scalableLayeredPane.setScale(newW);
        }
        this.horizontalScale = newW;
        this.verticalScale = newH;
        System.out.println("y-max-resized:" + this.lws.getVerticalBar().getMaximum());
        System.out.println(this.scalableLayeredPane.getSize());
        this.scalableLayeredPane.revalidate();
        this.layout();
    }

    public class Resized
    implements FigureListener {
        public void figureMoved(IFigure source) {
            if (!source.getSize().equals((Object)IndepentScalebleLayerdPaneCanvas.this.prevDimension)) {
                double newP;
                System.out.println("moved:" + source.getSize());
                int scrollX = IndepentScalebleLayerdPaneCanvas.this.lws.getHorizontalBar().getSelection();
                int scrollY = IndepentScalebleLayerdPaneCanvas.this.lws.getVerticalBar().getSelection();
                System.out.println("canvas:" + IndepentScalebleLayerdPaneCanvas.this.lws.getClientArea());
                System.out.println("scrollX:" + scrollX);
                System.out.println("scrollY:" + scrollY);
                double px = 0.0;
                double py = 0.0;
                if (scrollX != 0 && IndepentScalebleLayerdPaneCanvas.this.prevDimension != null) {
                    px = (double)scrollX / (double)(IndepentScalebleLayerdPaneCanvas.this.prevDimension.width - IndepentScalebleLayerdPaneCanvas.this.lws.getClientArea().width);
                    newP = (double)(IndepentScalebleLayerdPaneCanvas.this.scalableLayeredPane.getSize().width - IndepentScalebleLayerdPaneCanvas.this.lws.getClientArea().width) * px;
                    IndepentScalebleLayerdPaneCanvas.this.lws.scrollToX((int)newP);
                }
                if (scrollY != 0 && IndepentScalebleLayerdPaneCanvas.this.prevDimension != null) {
                    py = (double)scrollY / (double)(IndepentScalebleLayerdPaneCanvas.this.prevDimension.height - IndepentScalebleLayerdPaneCanvas.this.lws.getClientArea().height);
                    newP = (double)(IndepentScalebleLayerdPaneCanvas.this.scalableLayeredPane.getSize().height - IndepentScalebleLayerdPaneCanvas.this.lws.getClientArea().height) * py;
                    IndepentScalebleLayerdPaneCanvas.this.lws.scrollToY((int)newP);
                }
                System.out.println("changeX:" + IndepentScalebleLayerdPaneCanvas.this.lws.getHorizontalBar().getSelection());
                System.out.println("x-max:" + IndepentScalebleLayerdPaneCanvas.this.lws.getHorizontalBar().getMaximum());
                System.out.println("changeY:" + IndepentScalebleLayerdPaneCanvas.this.lws.getVerticalBar().getSelection());
                System.out.println("y-max:" + IndepentScalebleLayerdPaneCanvas.this.lws.getVerticalBar().getMaximum());
            }
        }
    }
}

