/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.commons.audio.AudioProgressListener;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.rcp.audio.AudioUtils;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.QuickConverter;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramListFigure;
import org.jpn.xucker.rcp.audiotools.spectrogram.views.KHZMemoryPainter;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.snack.Snack_rcpPlugin;
import org.jpn.xucker.rcp.ui.BufferedImagePainter;
import org.jpn.xucker.rcp.ui.DefaultZoom;
import org.jpn.xucker.rcp.ui.FigureMemoryComposite;
import org.jpn.xucker.rcp.ui.GraphMemoryLabelProvider;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;
import org.jpn.xucker.rcp.ui.Zoom;
import org.jpn.xucker.rcp.ui.ZoomChangeListener;
import org.jpn.xucker.snack.Formant;
import org.jpn.xucker.snack.FormantFigure;
import org.jpn.xucker.snack.FormantParser;
import org.jpn.xucker.snack.SmallFormant;
import org.jpn.xucker.snack.SnackExecuter;
import org.jpn.xucker.snack.SpectrogramListener;

public class AudioGraphView
extends ViewPart {
    public static Log log;
    public static String ID_VIEW;
    private SnackExecuter snackExecuter;
    private FigureMemoryComposite imageMemoryComposite;
    private SpectrogramListFigure spectrogramImageFigure;
    private FormantFigure formantFigure = new FormantFigure();
    int compositeHeight = 512;
    int imageWidth = 100;
    int basePersecond = 400;
    DefaultZoom defaultZoom = new DefaultZoom();
    double pixelMillisecond = 2.5;
    private KHZMemoryPainter khzMemoryPainter;
    private boolean spectrogram;
    private boolean formant = true;
    private int graphTop = 24;
    private int graphLeft = 46;
    private FileImageCache fileImageCache;
    private double persample;
    private int spectrogramLength;
    private ViewPart viewPart;
    private File spectrogramBase;
    private boolean fit = true;
    private int samplerate = 48000;
    GifConvertMonitor gifConvertMonitor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.audiotools.spectrogram.views.AudioGraphView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_VIEW = clazz2.getName();
    }

    public boolean isFormant() {
        return this.formant;
    }

    public void setFormant(boolean formant) {
        log.trace((Object)("formant:" + formant));
        this.formant = formant;
        this.formantFigure.setVisible(formant);
    }

    public boolean isSpectrogram() {
        return this.spectrogram;
    }

    public void setSpectrogram(boolean spectrogram) {
        this.spectrogram = spectrogram;
    }

    public void createPartControl(Composite parent) {
        this.spectrogramBase = AudioToolsPlugin.getDefault().getSpectrogramDirectory();
        this.viewPart = this;
        this.fileImageCache = new FileImageCache();
        this.fileImageCache.setMaxSize(32);
        this.snackExecuter = new SnackExecuter(Snack_rcpPlugin.getDefault().getSnackExecuterDirectory().getAbsolutePath());
        this.imageMemoryComposite = new FigureMemoryComposite(parent, 0, this.graphTop, this.graphLeft);
        SimpleGraphMemoryPainter vpainter = this.imageMemoryComposite.getVerticalGraphPainter();
        vpainter.setPerMain((double)this.compositeHeight / 12.0);
        vpainter.setGraphPlus(true);
        this.khzMemoryPainter = new KHZMemoryPainter();
        this.khzMemoryPainter.setHeight(this.compositeHeight);
        this.khzMemoryPainter.setGraphPlus(false);
        this.khzMemoryPainter.setVerticalGraph(true);
        this.imageMemoryComposite.setMaxVerticalValue(this.compositeHeight);
        this.imageMemoryComposite.setMaxHorizontalValue(999999);
        this.imageMemoryComposite.setVerticalMemoryStart(this.compositeHeight - 1);
        this.imageMemoryComposite.setVscrollLabelProvider((GraphMemoryLabelProvider)this.khzMemoryPainter);
        this.imageMemoryComposite.getVerticalMemoryCanvas().setGraphMemoryPainter((SimpleGraphMemoryPainter)this.khzMemoryPainter);
        this.imageMemoryComposite.getHorizontalGraphPainter().setPerMain(80.0);
        this.setHorizontalMemoryValue();
        this.spectrogramImageFigure = new SpectrogramListFigure();
        this.spectrogramImageFigure.setZoom(this.defaultZoom.getZoom(), 1.0);
        this.imageMemoryComposite.getScalableLayeredPane().setLayoutManager((LayoutManager)new StackLayout());
        this.imageMemoryComposite.getScalableLayeredPane().add((IFigure)this.spectrogramImageFigure);
        this.imageMemoryComposite.getScalableLayeredPane().add((IFigure)this.formantFigure);
        this.setFit(true);
        this.defaultZoom.setWrap(true);
        this.defaultZoom.addZoomChangeListener((ZoomChangeListener)new ZoomChangeRepaint());
        double zoom = Double.parseDouble(AudioToolsPlugin.getDefault().getPreferenceStore().getString("spectrogram.initialZoom"));
        int count = this.defaultZoom.countZooms();
        int i = 0;
        while (i < count) {
            double zv = this.defaultZoom.getZoomValue(i);
            if (zv == zoom) {
                log.trace((Object)("initial-zoom:" + zv));
                this.defaultZoom.setZoomIndex(i);
                break;
            }
            ++i;
        }
        MouseZoom mouseListener = new MouseZoom();
        this.imageMemoryComposite.getCanvas().addMouseListener((org.eclipse.swt.events.MouseListener)mouseListener);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.imageMemoryComposite.getCanvas(), operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
    }

    public void setHorizontalMemoryValue() {
        this.imageMemoryComposite.setHscrollLabelProvider((GraphMemoryLabelProvider)new NumberLabelProvider((int)((double)this.basePersecond / this.defaultZoom.getZoom()), 28800));
    }

    public IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return lineManager.getProgressMonitor();
    }

    public void exportImage(File file) {
        ExportImage exp = new ExportImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), file);
        exp.start();
    }

    public void setFocus() {
        this.imageMemoryComposite.getCanvas().setFocus();
    }

    public void setFit(boolean bool) {
        this.fit = bool;
        log.trace((Object)("fit:" + bool));
        this.formantFigure.setFit(bool);
        this.spectrogramImageFigure.setFit(bool);
        if (bool) {
            this.khzMemoryPainter.setSamplerate(this.samplerate);
        } else {
            this.khzMemoryPainter.setSamplerate(48000);
        }
        this.updateDraw();
    }

    public void updateDraw() {
        if (!this.imageMemoryComposite.getShell().isDisposed()) {
            this.imageMemoryComposite.getScalableLayeredPane().setScale(1.0);
            this.imageMemoryComposite.redraw(0, 0, this.imageMemoryComposite.getClientArea().width, this.imageMemoryComposite.getClientArea().height, true);
            log.trace((Object)("spectrogram:" + this.spectrogramImageFigure.getSize()));
            log.trace((Object)("formant:" + this.formantFigure.getSize()));
        }
    }

    public void setAudioData(SmallFormant[] formants) {
        FileImageCache imageCache = new FileImageCache();
        this.spectrogramImageFigure.setSampleRate(this.samplerate);
        this.spectrogramImageFigure.init(this.imageWidth, this.compositeHeight, (int)((double)this.spectrogramLength / this.persample), imageCache, this.spectrogramBase);
        FormantParser.normalize(formants, 2);
        this.formantFigure.setFormants(formants);
        log.trace((Object)"formant-resize:");
        this.formantFigure.resize();
        this.formantFigure.setSampleRate(this.samplerate);
        int cfr_ignored_0 = (int)(((double)this.spectrogramLength - SmallFormant.toMillisecond(formants)) / this.pixelMillisecond / 2.0);
        this.setFit(this.fit);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
        this.updateDraw();
    }

    public void setAudio(File file) {
        File originalFile = file;
        File importFile = null;
        if (this.isWavFile(file)) {
            importFile = file;
        } else {
            QuickConverter converter = new QuickConverter();
            if (converter.canConvert(file, "wav")) {
                try {
                    importFile = File.createTempFile("tmp", ".wav");
                    log.trace((Object)("convert:" + importFile.getAbsolutePath()));
                    converter.convert(file, importFile);
                    importFile.deleteOnExit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        IProgressMonitor imageMonitor = workbenchWindow.getStatusLineManager().getProgressMonitor();
        if (importFile != null) {
            OpenSpectrogram progress = new OpenSpectrogram(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), importFile, imageMonitor, originalFile);
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, (IRunnableWithProgress)progress);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            log.warn((Object)("not supported file " + file.getAbsolutePath()));
        }
        this.imageMemoryComposite.getCanvas().setFocus();
    }

    private boolean isWavFile(File file) {
        return AudioUtils.getExtension((File)file).toLowerCase().equals("wav");
    }

    public void setViewPartName(String name, String description) {
        this.setPartName(name);
        this.setTitleToolTip(description);
    }

    public class ZoomChangeRepaint
    implements ZoomChangeListener {
        public void zoomUp(Zoom arg0) {
        }

        public void zoomDown(Zoom arg0) {
        }

        public void zoomChange(Zoom zoom) {
            AudioGraphView.this.setHorizontalMemoryValue();
            AudioGraphView.this.spectrogramImageFigure.setZoom(zoom.getZoom(), 1.0);
            AudioGraphView.this.formantFigure.setWzoom(zoom.getZoom());
            AudioGraphView.this.updateDraw();
        }
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                File file = new File(files[i]);
                if (file.isFile()) {
                    AudioGraphView.this.setAudio(file);
                    break;
                }
                ++i;
            }
        }
    }

    public class MouseZoom
    implements MouseListener,
    org.eclipse.swt.events.MouseListener {
        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseDoubleClicked(MouseEvent arg0) {
            AudioGraphView.this.defaultZoom.zoomUp();
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            if ((e.stateMask & 0x20000) > 0) {
                AudioGraphView.this.defaultZoom.zoomDown();
            } else {
                AudioGraphView.this.defaultZoom.zoomUp();
            }
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }

    public class ExportImage
    extends Thread
    implements ProgressMonitor {
        private File file;
        private Shell shell;
        private IProgressMonitor monitor;
        int maxprogress;

        public ExportImage(Shell shell, File file) {
            this.file = file;
            this.shell = shell;
            this.monitor = AudioGraphView.this.getProgressMonitor();
            this.maxprogress = (int)((double)(AudioGraphView.this.compositeHeight / 50) * 1.2);
            this.monitor.beginTask("Export Image:" + file.getAbsolutePath(), this.maxprogress);
        }

        public void run() {
            String extention = AudioUtils.getExtension((File)this.file).toLowerCase();
            if (extention.equals("png")) {
                this.doExportPngImage(this.shell, this.file);
            } else if (extention.equals("jpg")) {
                this.doExportJpegImage(this.shell, this.file);
            } else {
                this.shell.getDisplay().asyncExec((Runnable)new ShowMessageBox(this.shell, "Can't Save Image", "type:" + extention + " not supported."));
            }
            this.shell.getDisplay().asyncExec((Runnable)new MonitorDone());
        }

        public void doExportJpegImage(Shell shell, File file) {
            log.trace((Object)("bound:" + AudioGraphView.this.spectrogramImageFigure.getBounds()));
            int qualityValue = AudioToolsPlugin.getDefault().getPreferenceStore().getInt("spectrogram.jpeg_quality");
            float quality = (float)qualityValue / 100.0f;
            log.trace((Object)("quality:" + quality));
            BufferedImage bufferedImage = new BufferedImage(((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width + AudioGraphView.this.graphLeft, AudioGraphView.this.compositeHeight + AudioGraphView.this.graphTop, 1);
            java.awt.Graphics g = bufferedImage.getGraphics();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
            Image spectrogram = new Image((Device)shell.getDisplay(), ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width, AudioGraphView.this.compositeHeight);
            SWTGraphics graphics = new SWTGraphics(new GC((Drawable)spectrogram));
            AudioGraphView.this.spectrogramImageFigure.paint((Graphics)graphics);
            if (AudioGraphView.this.isFormant()) {
                AudioGraphView.this.formantFigure.paint((Graphics)graphics);
            }
            BufferedImagePainter painter = new BufferedImagePainter();
            painter.setMonitor((ProgressMonitor)this);
            painter.drawAtBufferedImage(bufferedImage, spectrogram, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
            spectrogram.dispose();
            graphics.dispose();
            Image verticalImage = new Image((Device)shell.getDisplay(), AudioGraphView.this.graphLeft, AudioGraphView.this.compositeHeight);
            GC verticalGC = new GC((Drawable)verticalImage);
            AudioGraphView.this.imageMemoryComposite.getVerticalGraphPainter().draw(verticalGC, AudioGraphView.this.graphLeft - 1, AudioGraphView.this.compositeHeight, AudioGraphView.this.compositeHeight);
            painter.drawAtBufferedImage(bufferedImage, verticalImage, 0, AudioGraphView.this.graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            Image horizontalImage = new Image((Device)shell.getDisplay(), ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width, AudioGraphView.this.graphTop);
            GC horizontalGC = new GC((Drawable)horizontalImage);
            AudioGraphView.this.imageMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0, AudioGraphView.this.graphTop - 1, ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width);
            painter.drawAtBufferedImage(bufferedImage, horizontalImage, AudioGraphView.this.graphLeft, 0);
            horizontalImage.dispose();
            horizontalGC.dispose();
            try {
                Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
                ImageWriter writer = writers.next();
                ImageOutputStream ios = ImageIO.createImageOutputStream(file);
                writer.setOutput(ios);
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(quality);
                writer.write(null, new IIOImage(bufferedImage, null, null), param);
                ios.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void doExportPngImage(Shell shell, File file) {
            log.trace((Object)("bound:" + AudioGraphView.this.spectrogramImageFigure.getBounds()));
            BufferedImage bufferedImage = new BufferedImage(((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width + AudioGraphView.this.graphLeft, AudioGraphView.this.compositeHeight + AudioGraphView.this.graphTop, 2);
            java.awt.Graphics g = bufferedImage.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
            Image spectrogram = new Image((Device)shell.getDisplay(), ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width, AudioGraphView.this.compositeHeight);
            SWTGraphics graphics = new SWTGraphics(new GC((Drawable)spectrogram));
            AudioGraphView.this.spectrogramImageFigure.paint((Graphics)graphics);
            if (AudioGraphView.this.isFormant()) {
                AudioGraphView.this.formantFigure.paint((Graphics)graphics);
            }
            BufferedImagePainter painter = new BufferedImagePainter();
            painter.setMonitor((ProgressMonitor)this);
            painter.drawAtBufferedImage(bufferedImage, spectrogram, AudioGraphView.this.graphLeft, AudioGraphView.this.graphTop);
            spectrogram.dispose();
            graphics.dispose();
            Image verticalImage = new Image((Device)shell.getDisplay(), AudioGraphView.this.graphLeft, AudioGraphView.this.compositeHeight);
            GC verticalGC = new GC((Drawable)verticalImage);
            AudioGraphView.this.imageMemoryComposite.getVerticalGraphPainter().draw(verticalGC, AudioGraphView.this.graphLeft - 1, AudioGraphView.this.compositeHeight, AudioGraphView.this.compositeHeight);
            painter.drawAtBufferedImage(bufferedImage, verticalImage, 0, AudioGraphView.this.graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            Image horizontalImage = new Image((Device)shell.getDisplay(), ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width, AudioGraphView.this.graphTop);
            GC horizontalGC = new GC((Drawable)horizontalImage);
            AudioGraphView.this.imageMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0, AudioGraphView.this.graphTop - 1, ((AudioGraphView)AudioGraphView.this).spectrogramImageFigure.getBounds().width);
            painter.drawAtBufferedImage(bufferedImage, horizontalImage, AudioGraphView.this.graphLeft, 0);
            horizontalImage.dispose();
            horizontalGC.dispose();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bufferedImage = null;
            System.gc();
        }

        public void worked(int arg0) {
            this.shell.getDisplay().asyncExec((Runnable)new MonitorWork());
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public class MonitorDone
        extends Thread {
            public void run() {
                ExportImage.this.monitor.done();
            }
        }

        public class MonitorWork
        extends Thread {
            public void run() {
                ExportImage.this.monitor.worked(1);
            }
        }
    }

    public class ShowMessageBox
    implements Runnable {
        private Shell shell;
        private String title;
        private String message;

        public ShowMessageBox(Shell shell, String title, String message) {
            this.shell = shell;
            this.title = title;
            this.message = message;
        }

        public void run() {
            MessageBox box = new MessageBox(this.shell, 0);
            box.setText(this.title);
            box.setMessage(this.message);
            box.open();
        }
    }

    public class SetAudioData
    extends Thread {
        SmallFormant[] formants;

        public SetAudioData(SmallFormant[] formants) {
            this.formants = formants;
        }

        public void run() {
            AudioGraphView.this.setAudioData(this.formants);
        }
    }

    public class SplitMonitor
    implements AudioProgressListener {
        IProgressMonitor monitor;

        public SplitMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void worked(int arg0) {
            this.monitor.worked(1);
        }

        public boolean isStopped() {
            return this.monitor.isCanceled();
        }

        public void setStopped(boolean arg0) {
        }
    }

    public class OpenSpectrogram
    implements IRunnableWithProgress,
    ProgressMonitor {
        File waveFile;
        Shell shell;
        IProgressMonitor monitor;
        IProgressMonitor imageMonitor;
        File originalFile;

        public OpenSpectrogram(Shell shell, File waveFile, IProgressMonitor imageMonitor, File originalFile) {
            this.waveFile = waveFile;
            this.shell = shell;
            this.imageMonitor = imageMonitor;
            this.originalFile = originalFile;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int basicSplitDuration = 60000;
            long audioLength = WaveUtils.countAudioMillisecond((File)this.waveFile);
            int splitSize = (int)audioLength / basicSplitDuration;
            if (audioLength % (long)basicSplitDuration > 0L) {
                ++splitSize;
            }
            int works = splitSize * 2;
            monitor.beginTask("Open File " + this.originalFile.getName(), works);
            if (AudioGraphView.this.gifConvertMonitor != null) {
                AudioGraphView.this.gifConvertMonitor.setCanceled(true);
            }
            this.monitor = monitor;
            int permillisecond = 200;
            int step = 0;
            try {
                AudioInputStream input = AudioSystem.getAudioInputStream(this.waveFile);
                AudioFormat format = input.getFormat();
                AudioGraphView.this.samplerate = (int)format.getSampleRate();
                AudioGraphView.this.persample = (double)AudioGraphView.this.samplerate / (double)permillisecond;
                AudioGraphView.this.spectrogramLength = (int)input.getFrameLength();
                step = (int)((double)AudioGraphView.this.spectrogramLength / AudioGraphView.this.persample);
                log.trace((Object)("framesize:" + input.getFrameLength() + ",samplerate=" + AudioGraphView.this.samplerate + ",ms=" + permillisecond + ",spectrogramLength=" + AudioGraphView.this.spectrogramLength));
                input.close();
            }
            catch (UnsupportedAudioFileException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            SplitMonitor spMonitor = new SplitMonitor(monitor);
            File[] splits = null;
            try {
                splits = WaveUtils.splitFile((File)this.waveFile, (int)60000, (int)AudioGraphView.this.compositeHeight, (boolean)true, (AudioProgressListener)spMonitor);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (splits == null || monitor.isCanceled()) {
                log.trace((Object)"splits==null or cancelde");
                return;
            }
            int perFormant = 10;
            int lastSplitDuration = (int)(audioLength % (long)basicSplitDuration);
            log.trace((Object)("spectrogramMillisecond:" + AudioGraphView.this.spectrogramLength));
            try {
                if (AudioGraphView.this.fit) {
                    AudioGraphView.this.khzMemoryPainter.setSamplerate(AudioGraphView.this.samplerate);
                }
                ArrayList<SmallFormant> formantList = new ArrayList<SmallFormant>();
                int j = 0;
                while (j < splits.length) {
                    int splitDuration = basicSplitDuration;
                    if (j == splits.length - 1) {
                        splitDuration = lastSplitDuration;
                    }
                    log.trace((Object)("splitDuration:" + splitDuration + "ms"));
                    monitor.subTask("parse formant " + (j + 1) + "/" + splits.length);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    long formantStart = System.currentTimeMillis();
                    Formant[] formants = AudioGraphView.this.snackExecuter.getFormants(splits[j].getAbsolutePath(), AudioGraphView.this.compositeHeight, -AudioGraphView.this.compositeHeight);
                    log.trace((Object)("formant-length:" + formants.length));
                    log.trace((Object)("formant-parse-time:" + (System.currentTimeMillis() - formantStart)));
                    int collectSize = splitDuration / perFormant;
                    log.trace((Object)("collect-size:" + collectSize));
                    double fixper = (double)formants.length / (double)collectSize;
                    if (formants.length > 0) {
                        int i = 0;
                        while (i < collectSize) {
                            SmallFormant smallFormant = new SmallFormant(formants[Math.min((int)((double)i * fixper), collectSize - 1)]);
                            formantList.add(smallFormant);
                            ++i;
                        }
                    }
                    formants = null;
                    System.gc();
                    monitor.worked(1);
                    ++j;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.done();
                this.shell.getDisplay().asyncExec((Runnable)new SetViewPartName(this.originalFile.getName(), this.originalFile.getAbsolutePath()));
                log.trace((Object)("imagedir:" + AudioGraphView.this.spectrogramBase.getAbsolutePath()));
                String[] list = AudioGraphView.this.spectrogramBase.list();
                int i = 0;
                while (i < list.length) {
                    new File(AudioGraphView.this.spectrogramBase, list[i]).delete();
                    ++i;
                }
                int maxSplitSize = step / 100;
                if (AudioGraphView.this.spectrogramLength % 100 > 0) {
                    ++maxSplitSize;
                }
                log.trace((Object)("max-splitsize:" + maxSplitSize));
                this.shell.getDisplay().asyncExec((Runnable)new ProgressMonitorBegin(this.imageMonitor, "import spectrogram", maxSplitSize));
                AudioGraphView.this.gifConvertMonitor = new GifConvertMonitor(this.shell, this.imageMonitor, maxSplitSize, splits);
                ExportGif expGif = new ExportGif(splits, AudioGraphView.this.spectrogramBase.getAbsolutePath(), AudioGraphView.this.samplerate, AudioGraphView.this.compositeHeight, AudioGraphView.this.persample, AudioGraphView.this.gifConvertMonitor, new SpectrogramLoaded());
                Thread t = new Thread(expGif);
                t.start();
                if (formantList.size() > 0) {
                    log.trace((Object)("formant-size:" + formantList.size()));
                    this.shell.getDisplay().syncExec((Runnable)new SetAudioData(formantList.toArray(new SmallFormant[formantList.size()])));
                } else {
                    log.debug((Object)"SetAudioData:something null");
                }
                if (monitor.isCanceled()) {
                    AudioGraphView.this.gifConvertMonitor.setCanceled(true);
                    return;
                }
                int j2 = 0;
                while (j2 < splits.length) {
                    splits[j2].deleteOnExit();
                    ++j2;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void worked(int v) {
            this.monitor.worked(v);
        }

        public boolean isCanceled() {
            return this.monitor.isCanceled();
        }

        public class GifChecker
        implements SpectrogramListener {
            public void imageSaved(String path) {
                log.trace((Object)("imageSaved:" + path));
                OpenSpectrogram.this.shell.getDisplay().asyncExec((Runnable)new UpdateDraw());
            }
        }

        public class ExportGif
        implements Runnable {
            File[] files;
            int height;
            int samplerate;
            double persample;
            ProgressMonitor monitor;
            SpectrogramListener listener;
            String imageDir;

            public ExportGif(File[] files, String imageDir, int samplerate, int height, double persample, ProgressMonitor monitor, SpectrogramListener listener) {
                this.files = files;
                this.height = height;
                this.samplerate = samplerate;
                this.persample = persample;
                this.monitor = monitor;
                this.listener = listener;
                this.imageDir = imageDir;
            }

            public void run() {
                try {
                    AudioGraphView.this.snackExecuter.createSpectrogramImage(this.files, this.imageDir, this.samplerate, this.height, this.persample, 0, 0, this.monitor, this.listener);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public class SpectrogramLoaded
        implements SpectrogramListener {
            public void imageSaved(String path) {
                log.trace((Object)("imageSaved:" + path));
                OpenSpectrogram.this.shell.getDisplay().syncExec((Runnable)new UpdateDraw());
            }
        }

        public class UpdateDraw
        implements Runnable {
            public void run() {
                AudioGraphView.this.updateDraw();
            }
        }
    }

    public static class ProgressMonitorDone
    implements Runnable {
        IProgressMonitor monitor;

        public ProgressMonitorDone(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    public static class ProgressMonitorBegin
    implements Runnable {
        private IProgressMonitor monitor;
        private String label;
        private int step;

        public ProgressMonitorBegin(IProgressMonitor monitor, String label, int step) {
            this.monitor = monitor;
            this.label = label;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.label, this.step);
        }
    }

    public static class ProgressMonitorProgress
    implements Runnable {
        private int value;
        private IProgressMonitor monitor;

        public ProgressMonitorProgress(IProgressMonitor monitor, int value) {
            this.value = value;
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.worked(this.value);
        }
    }

    public class SetViewPartName
    implements Runnable {
        private String title;
        private String description;
        private ViewPart part;

        public SetViewPartName(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public void run() {
            AudioGraphView.this.setViewPartName(this.title, this.description);
        }
    }

    public static class GifConvertMonitor
    implements ProgressMonitor {
        IProgressMonitor monitor;
        private boolean canceled;
        int currentSplitSize = 0;
        int maxSplitSize;
        Shell shell;
        File[] files;

        public GifConvertMonitor(Shell shell, IProgressMonitor monitor, int max, File[] files) {
            this.monitor = monitor;
            this.maxSplitSize = max;
            this.shell = shell;
            this.files = files;
        }

        public void worked(int arg0) {
            log.trace((Object)("gif-worked:" + arg0));
            this.currentSplitSize += arg0;
            this.shell.getDisplay().asyncExec((Runnable)new ProgressMonitorProgress(this.monitor, arg0));
            if (this.currentSplitSize >= this.maxSplitSize) {
                int i = 0;
                while (i < this.files.length) {
                    boolean result = this.files[i].delete();
                    log.trace((Object)("delete-tmp: " + result + " " + this.files[i].getAbsolutePath()));
                    ++i;
                }
                this.shell.getDisplay().asyncExec((Runnable)new ProgressMonitorDone(this.monitor));
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }
}

