/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.draw2d.text.TextLayout;
import org.eclipse.swt.graphics.Font;

public class ParagraphTextLayout
extends TextLayout {
    public static final int WORD_WRAP_HARD = 0;
    public static final int WORD_WRAP_SOFT = 1;
    public static final int WORD_WRAP_TRUNCATE = 2;
    private int wrappingStyle = 0;

    public ParagraphTextLayout(TextFlow flow) {
        super(flow);
    }

    public ParagraphTextLayout(TextFlow flow, int style) {
        this(flow);
        this.wrappingStyle = style;
    }

    protected float getAverageCharWidth(TextFragmentBox fragment) {
        if (fragment.width != 0 && fragment.length != 0) {
            return (float)fragment.width / (float)fragment.length;
        }
        return 0.0f;
    }

    protected void layout() {
        TextFlow flowFigure = (TextFlow)this.getFlowFigure();
        List fragments = flowFigure.getFragments();
        String string = flowFigure.getText();
        Font font = flowFigure.getFont();
        int i = 0;
        int offset = 0;
        int length = 0;
        do {
            TextFragmentBox fragment = null;
            float prevAvgCharWidth = 0.0f;
            fragment = this.getFragment(i, fragments);
            prevAvgCharWidth = this.getAverageCharWidth(fragment);
            fragment.offset = offset;
            while (true) {
                LineBox currentLine = this.context.getCurrentLine();
                length = FlowUtilities.getTextForSpace(fragment, string, font, currentLine.getAvailableWidth(), prevAvgCharWidth, this.wrappingStyle);
                if (fragment.width <= currentLine.getAvailableWidth() || !this.context.isCurrentLineOccupied()) break;
                this.context.endLine();
            }
            this.context.addToCurrentLine(fragment);
            string = string.substring(length);
            offset += length;
            if (string.length() > 0 || fragment.truncated) {
                this.context.endLine();
            }
            ++i;
        } while (string.length() > 0);
        while (i < fragments.size()) {
            fragments.remove(fragments.size() - 1);
        }
    }
}

