package org.jpn.xucker.rcp.audiotools.toolame;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class TooLamePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String P_PATH = "pathPreference";
	public static final String P_BOOLEAN = "booleanPreference";
	public static final String P_CHOICE = "choicePreference";
	public static final String P_STRING = "stringPreference";

	public TooLamePage() {
		super(GRID);
		setPreferenceStore(AudioToolsPlugin.getDefault().getPreferenceStore());
		setDescription("toolame mp2 encoder decoder");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	

    protected void createFieldEditors() {
        FileFieldEditor fileField=new FileFieldEditor(
                "toolame_path", "toolame path",getFieldEditorParent());
        fileField.setFileExtensions(new String[]{"toolame.exe"});
        addField(fileField);
    }
	
	public void init(IWorkbench workbench) {
	}
}