/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioFormat;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audio.AudioUtils;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.Messages;
import org.jpn.xucker.rcp.audiotools.formats.DefaultFormat;

import org.jpn.xucker.rcp.mediainfo.AudioInfo;
import org.jpn.xucker.rcp.mediainfo.Info;
import org.jpn.xucker.rcp.mediainfo.MediaInfoParser;
import org.jpn.xucker.rcp.mediainfo.MediaInfoRcpPlugin;
import org.jpn.xucker.rcp.ui.FileDirChoicer;
import org.jpn.xucker.rcp.ui.FileOverwriteControler;
import org.jpn.xucker.rcp.ui.FileStatusChangeEvent;
import org.jpn.xucker.rcp.ui.FileStatusChangeListener;

import java.io.File;
import java.io.IOException;

/**
 * 
 *
 */
public class SimpleConvertView  extends ViewPart {
public static Log log=LogFactory.getLog(SimpleConvertView.class);
public static String ID_VIEW=SimpleConvertView.class.getName();
private Button convertButton;
private CCombo toolSelect;
private FileDirChoicer input;
private FileDirChoicer output;
private CCombo sampleRateCombo;
private CCombo bitRateCombo;
private Label bitrateLabel;
private Button sameInput;

private AudioSetting inputSetting;

private AudioFormat exportFormat=null;
/* (non-Javadoc)
 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
 */
public void createPartControl(Composite parent) {
    // TODO Auto-generated method stub
    ListCheck listCheck=new ListCheck();
    
    parent.setLayout(new GridLayout());
    Composite topComposite=new Composite(parent,SWT.NULL);
    topComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    topComposite.setLayout(new GridLayout(2,false));
    
    
    Composite buttonComposite=new Composite(topComposite,SWT.NULL);
    buttonComposite.setLayout(new GridLayout(1,false));
    GridData bt=new GridData();
    bt.verticalSpan=2;
    buttonComposite.setLayoutData(bt);
    
    
    
    convertButton = new Button(buttonComposite,SWT.NULL);
    convertButton.setText(Messages.getString("convert")); //$NON-NLS-1$
    convertButton.setEnabled(false);
    convertButton.addSelectionListener(new CheckConvert());
    GridData cb=new GridData(GridData.FILL_VERTICAL);
    cb.widthHint=100;
    cb.heightHint=100;
    convertButton.setLayoutData(cb);
    
    buttonComposite.setToolTipText(Messages.getString("if_cant_convert"));
    
    toolSelect = new CCombo(buttonComposite,SWT.READ_ONLY);
    toolSelect.setEnabled(false);
    GridData ts=new GridData(GridData.FILL_VERTICAL);
    ts.widthHint=100;
    toolSelect.setLayoutData(ts);
    
    Group g1=new Group(topComposite,SWT.NULL);
    g1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    g1.setText(Messages.getString("inputfile")); //$NON-NLS-1$
    g1.setLayout(new GridLayout());
    input = new FileDirChoicer(g1,SWT.NULL,FileDirChoicer.FILE,""); //$NON-NLS-1$
    input.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    input.addFileListChangeListener(listCheck);
    input.setBrowseButtonText(Messages.getString("inputfile_browse"));
    input.pack();
    Group g2=new Group(topComposite,SWT.NULL);
    
    /*
    Composite composite=new Composite(parent,SWT.NULL);
    composite.setLayout(new GridLayout(2,false));
    */
    
    g2.setText(Messages.getString("outputfile")); //$NON-NLS-1$
    g2.setLayout(new GridLayout());
    g2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    
    output = new FileDirChoicer(g2,SWT.NULL,FileDirChoicer.SAVE,null);
    output.addFileListChangeListener(listCheck);
    output.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    output.setBrowseButtonText(Messages.getString("outputfile_browse"));
    output.layout();
    sameInput = new Button(parent,SWT.CHECK);
    sameInput.setSelection(true);
    sameInput.setText(Messages.getString("use_input_setting")); //$NON-NLS-1$
    sameInput.addSelectionListener(new SettingCheck());
    sameInput.setEnabled(false);
    
    
    //output..
    Composite setOutputComposite=new Composite(parent,SWT.NULL);
    setOutputComposite.setLayout(new GridLayout(2,true));
    
    //bitrate 
    bitrateComposite = new Composite(setOutputComposite,SWT.NULL);
    bitrateComposite.setLayout(new GridLayout(2,false));
    bitrateLabel = new Label(bitrateComposite,SWT.NULL);
    bitrateLabel.setText(Messages.getString("bitrate")); //$NON-NLS-1$
    bitRateCombo = new CCombo(bitrateComposite,SWT.READ_ONLY);
    
    
    //sample rate
    sampleRateComposite = new Composite(setOutputComposite,SWT.NULL);
    sampleRateComposite.setLayout(new GridLayout(2,false));
    sampleRateLabel = new Label(sampleRateComposite,SWT.NULL);
    sampleRateLabel.setText(Messages.getString("samplerate")); //$NON-NLS-1$
    sampleRateCombo = new CCombo(sampleRateComposite,SWT.READ_ONLY);
    
    //sample bit
    sampleBitComposite = new Composite(setOutputComposite,SWT.NULL);
    sampleBitComposite.setLayout(new GridLayout(2,false));
    samplebitLabel = new Label(sampleBitComposite,SWT.NULL);
    samplebitLabel.setText(Messages.getString("samplebit")); //$NON-NLS-1$
    sampleBitCombo = new CCombo(sampleBitComposite,SWT.READ_ONLY);

    
    //channel
    channelRateComposite = new Composite(setOutputComposite,SWT.NULL);
    channelRateComposite.setLayout(new GridLayout(3,false));
    channelLabel = new Label(channelRateComposite,SWT.NULL);
    channelLabel.setText(Messages.getString("channel")); //$NON-NLS-1$
    
    stereoButton = new Button(channelRateComposite,SWT.RADIO);
    stereoButton.setText(Messages.getString("stereo")); //$NON-NLS-1$
    monoButton = new Button(channelRateComposite,SWT.RADIO);
    monoButton.setText(Messages.getString("monoral")); //$NON-NLS-1$
    
    
    //default
    setBitrateAvailable(false);
    setSamplebitAvailable(false);
    setSampleRateAvailable(false);
    setChannelAvailable(false);
    
    //init default setting.
    initSetting();
}

/**
 * 
 */
private void initSetting() {
    // TODO Auto-generated method stub
    if(exportFormat==null){
        exportFormat=new DefaultFormat();
    }
    
    if(exportFormat.getAvailableBitrate()!=null){
        bitRateCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableBitrate().length;i++){
            bitRateCombo.add(toBitrateLabel(exportFormat.getAvailableBitrate()[i]));
        }
       
        bitrateAvailable=true;
        bitRateCombo.select(bitRateCombo.getItemCount()-1);
    }else{
       bitrateAvailable=false;
    }
    
    if(exportFormat.getAvailableSamplebit()!=null){
        sampleBitCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableSamplebit().length;i++){
            sampleBitCombo.add(toSampleBitLabel(exportFormat.getAvailableSamplebit()[i]));
        }
        samplebitAvailable=true;
        sampleBitCombo.select(sampleBitCombo.getItemCount()-1);
    }else{
       samplebitAvailable=false;
    }
    
    if(exportFormat.getAvailableSampleRate()!=null){
        sampleRateCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableSampleRate().length;i++){
            sampleRateCombo.add(toSampleRateLabel(exportFormat.getAvailableSampleRate()[i]));
        }
        sampleRateAvailable=true;
        sampleRateCombo.select(sampleRateCombo.getItemCount()-1);
    }else{
       sampleRateAvailable=false;
    }
    
    if(exportFormat.getAvailableChannels()!=null){
        channelAvailable=true;
    }else{
        channelAvailable=false;
    }
}

/**
 * @param i
 * @return
 */
private String toSampleBitLabel(int i) {
    String label=""+i; //$NON-NLS-1$
    if(label.length()<2){
        label=" "+label; //$NON-NLS-1$
    }
    return label+" bit"; //$NON-NLS-1$
}

public void setBitrateAvailable(boolean bool){
    
    bitrateLabel.setEnabled(bool);
    bitRateCombo.setEnabled(bool);
    
}

public void setSamplebitAvailable(boolean bool){
   
        samplebitLabel.setEnabled(bool);
    sampleBitCombo.setEnabled(bool);
    
}

public void setSampleRateAvailable(boolean bool){
   
        sampleRateLabel.setEnabled(bool);
    sampleRateCombo.setEnabled(bool);
    
}
public void setChannelAvailable(boolean bool){
    channelLabel.setEnabled(bool);
    stereoButton.setEnabled(bool);
    monoButton.setEnabled(bool);
    
}


public void updateExportSetting(){
    if(sameInput.getSelection()){
        setBitrateAvailable(false);
        setSamplebitAvailable(false);
        setSampleRateAvailable(false);
        setChannelAvailable(false);   
    }else{
    setBitrateAvailable(bitrateAvailable);
    setSamplebitAvailable(samplebitAvailable);
    setSampleRateAvailable(sampleRateAvailable);
    setChannelAvailable(channelAvailable);
    }
   
}
public class SettingCheck implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        if(sameInput.getSelection()){
            setBitrateAvailable(false);
            setSamplebitAvailable(false);
            setSampleRateAvailable(false);
            setChannelAvailable(false);
        }else{
           updateExportSetting();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}

private boolean bitrateAvailable=true;
private boolean samplebitAvailable=true;
private boolean sampleRateAvailable=true;
private boolean channelAvailable=true;
private Composite channelRateComposite;
private Composite sampleBitComposite;
private Composite sampleRateComposite;
private Composite bitrateComposite;
private Label samplebitLabel;
private CCombo sampleBitCombo;
private Label sampleRateLabel;
private Label channelLabel;
private Button stereoButton;
private Button monoButton;


public class ListCheck implements FileStatusChangeListener{

    private String inputExtension;
    private String outputExtension;

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.ui.FileStatusChangeListener#removeList(org.jpn.xucker.rcp.ui.FileStatusChangeEvent)
     */
    public void removeList(FileStatusChangeEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.ui.FileStatusChangeListener#addList(org.jpn.xucker.rcp.ui.FileStatusChangeEvent)
     */
    
    private String prevOutputPath="";
    public void addList(FileStatusChangeEvent arg0) {
        
        if(arg0.item==output){
            File file=new File(output.getAbsoluteFilePath());
            if(file.exists()){
                FileOverwriteControler controler=new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),FileOverwriteControler.MODE_YES_NO_CANCEL);
                boolean result=controler.canOverwrite(file);
                System.out.println(result);
                if(!result){
                    output.setFilePath(prevOutputPath);
                }
            }
            prevOutputPath=output.getAbsoluteFilePath();
        }
        
        // TODO Auto-generated method stub
        toolSelect.removeAll();
        inputExtension = AudioUtils.getExtension(input.getAbsoluteFilePath()).toLowerCase();
        outputExtension = AudioUtils.getExtension(output.getAbsoluteFilePath()).toLowerCase();
        
        if(outputExtension.length()>0){
            sameInput.setEnabled(true);
            exportFormat=findFormat(outputExtension);
            initSetting();
            updateExportSetting();
        }else{
            sameInput.setEnabled(false);
        }
        
        if(inputExtension.length()>0 && outputExtension.length()>0){
            AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
            for(int i=0;i<converters.length;i++){
                if(converters[i].canConvert(inputExtension,outputExtension)){
                    toolSelect.add(converters[i].getName());
                }
            }
        }
        //System.out.println(inputExtension+","+outputExtension);
        if(toolSelect.getItemCount()>0){
            toolSelect.select(0);
            convertButton.setEnabled(true);
            toolSelect.setEnabled(true);
        }else{
            convertButton.setEnabled(false);
            toolSelect.setEnabled(false);
        }
        
        if(arg0.item==input){
            File file=new File(input.getAbsoluteFilePath());
            if(file.exists()){
            setUpInputSetting(input.getAbsoluteFilePath());
            }
        }
        
        if(inputSetting!=null){
           setSettingValue();
        }
    }


    private void setSettingValue(){
        log.trace(inputSetting);
        setSettingChannel(inputSetting.getChannel());
        setSettingSampleRate(inputSetting.getSamplerate());
        setSettingSampleBit(inputSetting.getSamplebit());
        setSettingBitRate(inputSetting.getBitrate());
        
      //TODO should more better check. 
       if(toSampleRate()<32000){
            if(toBitrate()>160000){
                setSettingBitRate(160000);
            }
        }
    }

    /**
     * @param outputExtension2
     * @return
     */
    private AudioFormat findFormat(String outputExtension2) {
        
        AudioFormat[] formats=AudioToolsPlugin.getDefault().getAudioFormats();
        for(int i=0;i<formats.length;i++){
            String[] extensions=formats[i].getAvailableExtension();
            if(extensions!=null){
                for (int j = 0; j < extensions.length; j++) {
                    if(extensions[j].equals(outputExtension2)){
                        return formats[i];
                    }
                }
            }
        }
        
        return null;
    }

    /**
     * @param absoluteFilePath
     */
    private void setUpInputSetting(String absoluteFilePath) {
        // call media info.
        MediaInfoParser parser=MediaInfoRcpPlugin.getDefault().getParser();
        try {
            log.trace(absoluteFilePath);
            Info infos[]=parser.parse(new File(absoluteFilePath));
            
            for(int i=0;i<infos.length;i++){
                if(infos[i] instanceof AudioInfo){
                    AudioInfo audioInfo=(AudioInfo)infos[i];
                    int bitrate=audioInfo.getBitrate();
                    int samplerate=audioInfo.getSamplingrate();
                    int samplebit=audioInfo.getSampleBit();//TODO must change samplebit.
                    int channel=audioInfo.getChannels();
                    log.trace(bitrate+","+samplerate+","+samplebit+","+channel);
                    inputSetting=new AudioSetting();
                    inputSetting.setChannel(channel);
                    inputSetting.setBitrate(bitrate);
                    inputSetting.setSamplebit(samplebit);
                    inputSetting.setSamplerate(samplerate);
                    log.trace(inputSetting);
                    
                    
                    break;
                }
            }
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        //set
        
    }

    /**
     * @param bitrate
     */
    private void setSettingBitRate(int bitrate) {
        if(outputExtension.equals(AudioConverter.WAV)){
            return;
        }
        
        
        int size=bitRateCombo.getItemCount();
        String label=toBitrateLabel(bitrate);
        int index=-1;
        for(int i=0;i<size;i++){
            if(label.equals(bitRateCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
            bitRateCombo.select(index);
        }else{
            //TODO warrning.
        //warrning
            //bitRateCombo.add(label);
            //bitRateCombo.select(bitRateCombo.getItemCount()-1);//set last.
        }
        
        
    }

    /**
     * @param samplebit
     */
    private void setSettingSampleBit(int samplebit) {
      
        
        
        String label=toSampleBitLabel(samplebit);
        
        int index=-1;
        int size=sampleBitCombo.getItemCount();
        for(int i=0;i<size;i++){
            if(label.equals(sampleBitCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
            sampleBitCombo.select(index);
        }else{
        //warrning
        
        }
    }

    /**
     * @param channel
     */
    private void setSettingChannel(int channel) {
        if(channel==1){
            monoButton.setSelection(true);
            stereoButton.setSelection(false);
        }else if(channel==2){
            stereoButton.setSelection(true);
            monoButton.setSelection(false);
        }
    }
    
    private String toSampleBitLabel(int bit){
        String label=""+"bit"; //$NON-NLS-1$ //$NON-NLS-2$
        if(label.length()<5){
            label=" "+label; //$NON-NLS-1$
        }
        return label;
    }
    
    private void setSettingSampleRate(int rate) {
        int size=sampleRateCombo.getItemCount();
        String label=toSampleRateLabel(rate);
        int index=-1;
        for(int i=0;i<size;i++){
            if(label.equals(sampleRateCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
        sampleRateCombo.select(index);
        }else{
            //TODO warrning.or auto fix.
        //warrning
        //sampleRateCombo.add(label);
        //sampleRateCombo.select(sampleRateCombo.getItemCount()-1);//set last.
        }
    }
    
}

private String toBitrateLabel(int value){
    String label=""; //$NON-NLS-1$
    
    label=""+value; //$NON-NLS-1$
    label=label.substring(0,label.length()-3);
    while(label.length()<4){
        label=" "+label; //$NON-NLS-1$
    }
    
    label=label+" kbps"; //$NON-NLS-1$
    
    return label;
}

private String toSampleRateLabel(int value){
    String label=""; //$NON-NLS-1$
    
    label=""+value; //$NON-NLS-1$
    label=label.substring(0,label.length()-3)+"."+label.substring(label.length()-3); //$NON-NLS-1$
    if(label.length()<6){
        label=" "+label; //$NON-NLS-1$
    }
    label=label+" khz"; //$NON-NLS-1$
    
    return label;
}





public class CheckConvert implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        AudioConverter convert=null;
        AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
        for(int i=0;i<converters.length;i++){
            if(converters[i].getName().equals(toolSelect.getItem(toolSelect.getSelectionIndex()))){
                //
                convert=converters[i];
                break;
            }
        }
        
        if(convert!=null){
            input.setEnabled(false);
            output.setEnabled(false);
            convertButton.setEnabled(false);
            toolSelect.setEnabled(false);
            
            Thread t=new ExecConvert(convert,input.getAbsoluteFilePath(),output.getAbsoluteFilePath());
            t.start();
            
          //Display.getCurrent().asyncExec();
        }
    }

    public class ExecConvert extends Thread{
        private String inputPath;
        private String outputPath;
        private AudioConverter converter;
        private AudioSetting setting;
        public ExecConvert(AudioConverter converter,String input,String output){
            inputPath=input;
            outputPath=output;
            this.converter=converter;
            setting=toSetting();
        }
        public void run(){
           
            
            
            try {
                converter.convert(new File(inputPath),new File(outputPath),setting,inputSetting);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Enabled());
            
        }
    }
    
    public class Enabled extends Thread{
        public void run(){
            input.setEnabled(true);
            output.setEnabled(true);
            convertButton.setEnabled(true);
            toolSelect.setEnabled(true);
        }
    }
    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}


public int toSampleRate(){
    int result=0;
    String value=sampleRateCombo.getItem(sampleRateCombo.getSelectionIndex());
    if(value.endsWith("khz")){ //$NON-NLS-1$
        double dv=Double.parseDouble(removeWhiteSpace(value.substring(0,value.length()-3)));
       
        result=(int)(dv*1000);
    }
    return result;
}

public int toSampleBit(){
    int result=0;
    String value=sampleBitCombo.getItem(sampleBitCombo.getSelectionIndex());
    if(value.endsWith("bit")){ //$NON-NLS-1$
        
        result=Integer.parseInt(removeWhiteSpace(value.substring(0,value.length()-3)));
    }
    return result;
}

public int toBitrate(){
    int result=0;
    String value=bitRateCombo.getItem(bitRateCombo.getSelectionIndex());
    if(value.endsWith("kbps")){ //$NON-NLS-1$
        
        result=Integer.parseInt(removeWhiteSpace(value.substring(0,value.length()-4)))*1000;
    }
    return result;
}

public int toChannel(){
    int result=0;
    //channel;
    if(monoButton.getEnabled() && monoButton.getSelection()){
        result=1;
    }else if(stereoButton.getEnabled() && stereoButton.getSelection()){
        result=2;
    }
    return result;
}
public AudioSetting toSetting(){
    AudioSetting setting=null;
    if(!sameInput.getSelection()){
        setting=new AudioSetting();
        
        if(sampleRateCombo.getEnabled()){
            setting.setSamplerate(toSampleRate());
           
        }
        
        if(sampleBitCombo.getEnabled()){
            setting.setSamplebit((toSampleBit()));
        }
        
        if(bitRateCombo.getEnabled()){
            String value=bitRateCombo.getItem(bitRateCombo.getSelectionIndex());
            if(value.endsWith("kbps")){ //$NON-NLS-1$
                
                setting.setBitrate(toBitrate());
            }
        }
        
       setting.setChannel(toChannel());
    }
    return setting;
}

public String getInputType(){
    String result=null;
    
    return result;
}
public String removeWhiteSpace(String value){
    StringBuffer result=new StringBuffer();
    for (int i = 0; i < value.length(); i++) {
        if(!Character.isWhitespace(value.charAt(i))){
            result.append(value.charAt(i));
        }
    }
    return result.toString();
}


/* (non-Javadoc)
 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
 */
public void setFocus() {
    // TODO Auto-generated method stub
    
}

}
