/*
 * Created on 2005/04/26
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.snack;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/**
 * 
 *
 */
public abstract class AbstractParser {
    public Object parse(InputStream input) throws IOException{
        
            return parse(new InputStreamReader(input));
        }
    
    public abstract Object parse(Reader reader) throws IOException;
    
    public Object parse(File file) throws IOException{
     
         return parse(new FileReader(file));
     
     }
}
