/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutData;
import org.eclipse.ui.internal.dialogs.AboutPluginsDialog;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;
import org.osgi.framework.Bundle;

public class AboutFeaturesDialog
extends ProductInfoDialog {
    private static final int TABLE_HEIGHT = 150;
    private static final int INFO_HEIGHT = 100;
    private static final int MORE_ID = 1025;
    private static final int PLUGINS_ID = 1026;
    private Table table;
    private Label imageLabel;
    private StyledText text;
    private Composite infoArea;
    private Map cachedImages = new HashMap();
    private String[] columnTitles = new String[]{WorkbenchMessages.getString("AboutFeaturesDialog.provider"), WorkbenchMessages.getString("AboutFeaturesDialog.featureName"), WorkbenchMessages.getString("AboutFeaturesDialog.version"), WorkbenchMessages.getString("AboutFeaturesDialog.featureId")};
    private String productName;
    private AboutBundleGroupData[] bundleGroupInfos;
    private int lastColumnChosen = 0;
    private boolean reverseSort = false;
    private AboutBundleGroupData lastSelection = null;
    private Button moreButton;
    private Button pluginsButton;
    private static Map featuresMap;

    public AboutFeaturesDialog(Shell parentShell, String productName, AboutBundleGroupData[] bundleGroupInfos) {
        super(parentShell);
        this.setShellStyle(68720);
        this.productName = productName;
        this.bundleGroupInfos = new AboutBundleGroupData[bundleGroupInfos.length];
        System.arraycopy(bundleGroupInfos, 0, this.bundleGroupInfos, 0, bundleGroupInfos.length);
        AboutData.sortByProvider(this.reverseSort, this.bundleGroupInfos);
    }

    private void handleMoreInfoPressed() {
        TableItem[] items = this.table.getSelection();
        if (items.length <= 0) {
            return;
        }
        AboutBundleGroupData info = (AboutBundleGroupData)items[0].getData();
        if (info == null || !this.openBrowser(info.getLicenseUrl())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("AboutFeaturesDialog.noInfoTitle"), (String)WorkbenchMessages.getString("AboutFeaturesDialog.noInformation"));
        }
    }

    private void handlePluginInfoPressed() {
        TableItem[] items = this.table.getSelection();
        if (items.length <= 0) {
            return;
        }
        AboutBundleGroupData info = (AboutBundleGroupData)items[0].getData();
        IBundleGroup bundleGroup = info.getBundleGroup();
        Bundle[] bundles = bundleGroup == null ? new Bundle[]{} : bundleGroup.getBundles();
        AboutPluginsDialog d = new AboutPluginsDialog(this.getShell(), this.productName, bundles, WorkbenchMessages.getString("AboutFeaturesDialog.pluginInfoTitle"), WorkbenchMessages.format("AboutFeaturesDialog.pluginInfoMessage", new Object[]{bundleGroup.getIdentifier()}), "org.eclipse.ui.about_features_plugins_dialog_context");
        d.open();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handlePluginInfoPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.productName != null) {
            newShell.setText(WorkbenchMessages.format("AboutFeaturesDialog.shellTitle", new Object[]{this.productName}));
        }
        WorkbenchHelp.setHelp((Control)newShell, "org.eclipse.ui.about_features_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.moreButton = this.createButton(parent, 1025, WorkbenchMessages.getString("AboutFeaturesDialog.moreInfo"), false);
        this.pluginsButton = this.createButton(parent, 1026, WorkbenchMessages.getString("AboutFeaturesDialog.pluginsInfo"), false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            this.updateButtons((AboutBundleGroupData)items[0].getData());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setHandCursor(new Cursor((Device)parent.getDisplay(), 21));
        this.setBusyCursor(new Cursor((Device)parent.getDisplay(), 1));
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AboutFeaturesDialog.this.getHandCursor() != null) {
                    AboutFeaturesDialog.this.getHandCursor().dispose();
                }
                if (AboutFeaturesDialog.this.getBusyCursor() != null) {
                    AboutFeaturesDialog.this.getBusyCursor().dispose();
                }
            }
        });
        Composite outer = (Composite)super.createDialogArea(parent);
        this.createTable(outer);
        this.createInfoArea(outer);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(150);
        this.table.setLayoutData((Object)gridData);
        return outer;
    }

    protected void createInfoArea(Composite parent) {
        int infoAreaHeight;
        Font font = parent.getFont();
        this.infoArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.infoArea.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = infoAreaHeight = this.convertVerticalDLUsToPixels(100);
        this.infoArea.setLayoutData((Object)data);
        this.imageLabel = new Label(this.infoArea, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.heightHint = 32;
        data.widthHint = 32;
        this.imageLabel.setLayoutData((Object)data);
        this.imageLabel.setFont(font);
        this.text = new StyledText(this.infoArea, 10);
        this.text.setCaret(null);
        this.text.setFont(parent.getFont());
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = infoAreaHeight;
        this.text.setLayoutData((Object)data);
        this.text.setFont(font);
        this.text.setCursor(null);
        this.text.setBackground(this.infoArea.getBackground());
        this.addListeners(this.text);
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            this.updateInfoArea((AboutBundleGroupData)items[0].getData());
        }
    }

    protected void createTable(Composite parent) {
        this.table = new Table(parent, 68356);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(parent.getFont());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AboutBundleGroupData info = (AboutBundleGroupData)e.item.getData();
                AboutFeaturesDialog.this.updateInfoArea(info);
                AboutFeaturesDialog.this.updateButtons(info);
            }
        });
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.setText(this.columnTitles[i]);
            final int columnIndex = i++;
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutFeaturesDialog.this.sort(columnIndex);
                }
            });
        }
        String selId = this.lastSelection == null ? null : this.lastSelection.getId();
        int sel = 0;
        int i2 = 0;
        while (i2 < this.bundleGroupInfos.length) {
            if (this.bundleGroupInfos[i2].getId().equals(selId)) {
                sel = i2;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(AboutFeaturesDialog.createRow(this.bundleGroupInfos[i2]));
            item.setData((Object)this.bundleGroupInfos[i2]);
            ++i2;
        }
        if (this.bundleGroupInfos.length > 0) {
            this.table.setSelection(sel);
            this.table.showSelection();
        }
    }

    public boolean close() {
        boolean ret = super.close();
        Iterator iter = this.cachedImages.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        return ret;
    }

    private void updateButtons(AboutBundleGroupData info) {
        if (info == null) {
            this.moreButton.setEnabled(false);
            this.pluginsButton.setEnabled(false);
            return;
        }
        if (featuresMap == null) {
            this.moreButton.setEnabled(true);
            this.pluginsButton.setEnabled(true);
            return;
        }
        this.moreButton.setEnabled(info.getLicenseUrl() != null);
        this.pluginsButton.setEnabled(true);
    }

    private void updateInfoArea(AboutBundleGroupData info) {
        if (info == null) {
            this.imageLabel.setImage(null);
            this.text.setText("");
            return;
        }
        ImageDescriptor desc = info.getFeatureImage();
        Image image = (Image)this.cachedImages.get(desc);
        if (image == null && desc != null) {
            image = desc.createImage();
            this.cachedImages.put(desc, image);
        }
        this.imageLabel.setImage(image);
        String aboutText = info.getAboutText();
        this.setItem(null);
        if (aboutText != null) {
            this.setItem(this.scan(aboutText));
        }
        if (this.getItem() == null) {
            this.text.setText(WorkbenchMessages.getString("AboutFeaturesDialog.noInformation"));
        } else {
            this.text.setText(this.getItem().getText());
            this.text.setCursor(null);
            this.setLinkRanges(this.text, this.getItem().getLinkRanges());
        }
    }

    public void setInitialSelection(AboutBundleGroupData info) {
        this.lastSelection = info;
    }

    private void sort(int column) {
        if (this.lastColumnChosen == column) {
            this.reverseSort = !this.reverseSort;
        } else {
            this.reverseSort = false;
            this.lastColumnChosen = column;
        }
        if (this.table.getItemCount() <= 1) {
            return;
        }
        int sel = this.table.getSelectionIndex();
        if (sel != -1) {
            this.lastSelection = this.bundleGroupInfos[sel];
        }
        switch (column) {
            case 0: {
                AboutData.sortByProvider(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 1: {
                AboutData.sortByName(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 2: {
                AboutData.sortByVersion(this.reverseSort, this.bundleGroupInfos);
                break;
            }
            case 3: {
                AboutData.sortById(this.reverseSort, this.bundleGroupInfos);
            }
        }
        this.refreshTable(column);
    }

    private void refreshTable(int col) {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setText(AboutFeaturesDialog.createRow(this.bundleGroupInfos[i]));
            items[i].setData((Object)this.bundleGroupInfos[i]);
            ++i;
        }
        int sel = -1;
        if (this.lastSelection != null) {
            String oldId = this.lastSelection.getId();
            int k = 0;
            while (k < this.bundleGroupInfos.length) {
                if (oldId.equalsIgnoreCase(this.bundleGroupInfos[k].getId())) {
                    sel = k;
                }
                ++k;
            }
            this.table.setSelection(sel);
            this.table.showSelection();
        }
        this.updateInfoArea(this.lastSelection);
    }

    private static String[] createRow(AboutBundleGroupData info) {
        return new String[]{info.getProviderName(), info.getName(), info.getVersion(), info.getId()};
    }
}

