/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer.views;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.draw2d.AlphaLayerFigure;
import org.jpn.xucker.rcp.draw2d.AlphaUtils;
import org.jpn.xucker.rcp.draw2d.DoubleScalableFigure;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.WaveFormFigureCanvas;
import org.jpn.xucker.rcp.draw2d.WaveFormListener;
import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.subplayer.TextAndImageFigure;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.rcp.ui.RCPFileApplication;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.SubUtils;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.xml.sax.SAXException;

public class SubView
extends ViewPart {
    public static final String ID;
    public static Log log;
    private SubApplication subApplication;
    private TimeBaseFileObject timeBaseFileObject;
    private FileImageCache imageCache = new FileImageCache();
    private CenterImageFigure ci;
    private WaveFormFigureCanvas waveFormFigureCanvas;
    private Shell shell;
    private File audioFile;
    boolean stopped = true;
    private JavaSoundAudioPlayer player;
    private Button playButton;
    private Point selection;
    private long duration;
    private boolean playing;
    SRTListFigure[] srtListFigures = new SRTListFigure[4];
    private TextAndImageFigure subtitleShowText1;
    private TextAndImageFigure subtitleShowText2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.views.SubView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.views.SubView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz2);
    }

    public SubView() {
        this.subApplication = new SubApplication();
    }

    private void setData(TimeBaseFileObject data) throws UnsupportedAudioFileException, IOException {
        this.timeBaseFileObject = data;
        File audio = this.parseFirstAudioFile(data);
        if (audio != null) {
            this.audioFile = audio;
            log.info((Object)("load-audio:" + this.audioFile));
            if (TimeBaseFileObjectReadUtils.isWavFile(this.audioFile.getName())) {
                this.waveFormFigureCanvas.loadEmpty(WaveUtils.countAudioMillisecond((File)this.audioFile));
                new LoadWave(AudioSystem.getAudioInputStream(this.audioFile), this.audioFile).start();
                this.player = new JavaSoundAudioPlayer();
            } else if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                try {
                    log.trace((Object)("load-mp3:" + this.audioFile));
                    this.waveFormFigureCanvas.loadEmpty(MP3Utils.getAudioDurationTimeQuickly((File)this.audioFile));
                    new LoadWave(MP3Utils.toPCMAudioInputStream((InputStream)new FileInputStream(this.audioFile)), this.audioFile).start();
                    this.player = new JavaLayerMP3Player();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        int i = 0;
        while (i < this.srtListFigures.length) {
            this.srtListFigures[i].setStandardSubObjectList(null);
            this.srtListFigures[i].rerect();
            ++i;
        }
        ParameterObject[] params = data.getParameters();
        int index = 0;
        int i2 = 0;
        while (i2 < params.length) {
            if (params[i2].getName().equals("file")) {
                log.trace((Object)("file:" + params[i2].getValue()));
                if (TimeBaseFileObjectReadUtils.isSRTFile(params[i2].getValue())) {
                    log.trace((Object)("srt-file:" + params[i2].getValue()));
                    try {
                        List subDataList = SubUtils.loadSub((File)new File(params[i2].getValue()));
                        this.addSubs(params[i2].getValue(), index, subDataList);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++index;
                }
            }
            ++i2;
        }
        this.waveFormFigureCanvas.getInFigure().setVisible(true);
    }

    public void addSubs(String path, int index, List sublist) {
        this.srtListFigures[index].setStandardSubObjectList(sublist);
        this.srtListFigures[index].setSubObjectPath(path);
        this.srtListFigures[index].rerect();
        log.trace((Object)("sub-added:" + this.srtListFigures[index].getClientArea()));
    }

    private void initData() {
        log.trace((Object)"initData");
        this.stopped = true;
        this.waveFormFigureCanvas.removeWaveForm();
        this.waveFormFigureCanvas.setSelectRealValue(0, 0);
        this.waveFormFigureCanvas.setCurrentRealValue(0);
        int i = 0;
        while (i < this.srtListFigures.length) {
            this.srtListFigures[i].removeAll();
            ++i;
        }
        this.waveFormFigureCanvas.scrollToX(0);
        this.waveFormFigureCanvas.getInFigure().setVisible(false);
        this.audioFile = null;
        this.subtitleShowText1.setText("");
        this.subtitleShowText1.repaint();
    }

    public File parseFirstAudioFile(TimeBaseFileObject object) {
        ParameterObject[] params = object.getParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].getName().equals("file") && TimeBaseFileObjectReadUtils.isWavFile(params[i].getValue()) || TimeBaseFileObjectReadUtils.isMP3File(params[i].getValue())) {
                return new File(params[i].getValue());
            }
            ++i;
        }
        return null;
    }

    public TextAndImageFigure createTextAndImageFigure(int width, int height) {
        TextAndImageFigure subtitleShowText = new TextAndImageFigure(this.shell);
        RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_bg_color");
        subtitleShowText.setBackgroundColor(new Color((Device)this.shell.getDisplay(), c));
        RGB c2 = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_fg_color");
        subtitleShowText.setForegroundColor(new Color((Device)this.shell.getDisplay(), c2));
        int transparent = SubplayerPlugin.getDefault().getPreferenceStore().getInt("subview.layer1_transparent");
        subtitleShowText.setAlpha(transparent);
        subtitleShowText.setFont(new Font((Device)this.shell.getDisplay(), PreferenceConverter.getFontData((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_font")));
        subtitleShowText.setSize(width, height);
        return subtitleShowText;
    }

    public Figure createMixFigure(Figure main, int width, int height) {
        int shadow = 5;
        AlphaLayerFigure alpha = new AlphaLayerFigure(ColorConstants.black, 32);
        alpha.setSize(width, height);
        alpha.setLocation(new Point(shadow, shadow));
        alpha.setVisible(false);
        MixWindowFigure mix = new MixWindowFigure();
        mix.setShadowFigure((Figure)alpha);
        mix.setMainFigure(main);
        mix.setLayoutManager(null);
        mix.add((IFigure)alpha);
        mix.add((IFigure)main);
        mix.setSize(width + shadow, height + shadow);
        ResizeBox box = new ResizeBox(mix);
        mix.add((IFigure)box);
        FigureMove move = new FigureMove();
        mix.addMouseListener(move);
        mix.addMouseMotionListener(move);
        return mix;
    }

    public void createPartControl(Composite parent) {
        this.imageCache.setMaxSize(4);
        Composite component = new Composite(parent, 0);
        this.shell = parent.getShell();
        component.setLayout((Layout)new GridLayout());
        Composite panel = new Composite(component, 0);
        panel.setLayout((Layout)new FillLayout());
        this.playButton = new Button(panel, 0);
        this.playButton.setText("play");
        Image play = ImageDescriptor.createFromURL((URL)SubplayerPlugin.getDefault().find((IPath)new Path("icons/play.png"))).createImage();
        this.playButton.setImage(play);
        this.playButton.addSelectionListener((SelectionListener)new Play());
        Button bt3 = new Button(panel, 0);
        bt3.setText("stop");
        bt3.addSelectionListener((SelectionListener)new Stop());
        Button bt4 = new Button(panel, 0);
        bt4.setText("zoom up");
        bt4.addSelectionListener((SelectionListener)new Zoomup());
        Button bt5 = new Button(panel, 0);
        bt5.setText("zoom down");
        bt5.addSelectionListener((SelectionListener)new Zoomdown());
        Composite base = new Composite(component, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new FillLayout());
        this.waveFormFigureCanvas = new WaveFormFigureCanvas(base);
        this.waveFormFigureCanvas.getInFigure().setVisible(false);
        this.waveFormFigureCanvas.setWaveFormListener((WaveFormListener)new ChangeSubInfo());
        this.ci = new CenterImageFigure();
        this.ci.setParentCanvas((Canvas)this.waveFormFigureCanvas);
        try {
            log.info((Object)("bgimage:" + SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage")));
            Image img = new Image(null, SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage"));
            if (img != null) {
                this.ci.setImage(img);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.waveFormFigureCanvas.getBackgroundFigure().setLayoutManager(null);
        this.waveFormFigureCanvas.getBackgroundFigure().add((IFigure)this.ci);
        FontData fontData = new FontData("MS UI Gothic", 28, 0);
        PreferenceConverter.setDefault((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_font", (FontData)fontData);
        PreferenceConverter.setDefault((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_bg_color", (RGB)ColorConstants.black.getRGB());
        PreferenceConverter.setDefault((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_fg_color", (RGB)ColorConstants.white.getRGB());
        int w = 700;
        int h = 240;
        this.subtitleShowText1 = this.createTextAndImageFigure(w, h);
        Figure mix1 = this.createMixFigure(this.subtitleShowText1, w, h);
        mix1.setLocation(new Point(1, 150));
        this.subtitleShowText2 = this.createTextAndImageFigure(w, h);
        Figure mix2 = this.createMixFigure(this.subtitleShowText2, w, h);
        mix2.setLocation(new Point(1, 300));
        this.waveFormFigureCanvas.getForegroundFigure().setLayoutManager(null);
        this.waveFormFigureCanvas.setSplitFrame(0.1);
        this.waveFormFigureCanvas.getForegroundFigure().add((IFigure)mix2);
        this.waveFormFigureCanvas.getForegroundFigure().add((IFigure)mix1);
        int i = 0;
        while (i < this.srtListFigures.length) {
            this.srtListFigures[i] = new SRTListFigure(1, 1);
            this.srtListFigures[i].setScale(this.waveFormFigureCanvas.getZoom(), 1.0);
            this.srtListFigures[i].setRectangleY(20 + 36 * i);
            this.srtListFigures[i].setLocation(new Point(0, 0));
            this.waveFormFigureCanvas.getInFigure().add((IFigure)this.srtListFigures[i]);
            ++i;
        }
        this.waveFormFigureCanvas.getForegroundFigure().addMouseListener((MouseListener)new SRTClick());
        this.player = new JavaSoundAudioPlayer();
        GC gc = new GC((Drawable)component.getDisplay());
        String text = "text\n\nalo";
        org.eclipse.swt.graphics.Point dm = gc.stringExtent(text);
        log.trace((Object)("dm:" + dm));
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        StatusLineContributionItem item = new StatusLineContributionItem("fileinfo", 32);
        StatusLineContributionItem item2 = new StatusLineContributionItem("subinfo", 32);
        lineManager.add((IContributionItem)item2);
        lineManager.add((IContributionItem)item);
        long time = System.currentTimeMillis();
        log.trace((Object)("loadTime:" + (System.currentTimeMillis() - time)));
        SubplayerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new PropertyCheck());
    }

    private StatusLineContributionItem getFileInfoStatusLine() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return (StatusLineContributionItem)lineManager.find("fileinfo");
    }

    public void play() {
        try {
            if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                MP3Utils.getAudioFormat((InputStream)new FileInputStream(this.audioFile));
            } else {
                WaveUtils.getAudioFormat((File)this.audioFile);
            }
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.selection = this.waveFormFigureCanvas.getSelection();
        if (this.selection == null) {
            this.selection = new Point(this.waveFormFigureCanvas.getCurrentRealValue(), this.waveFormFigureCanvas.getLastPosition());
        }
        long starttime = this.selection.x * 1000 / this.waveFormFigureCanvas.getBaseMemoryPixel();
        long endtime = this.selection.y * 1000 / this.waveFormFigureCanvas.getBaseMemoryPixel();
        this.duration = endtime - starttime;
        log.trace((Object)("duration:" + starttime + "," + endtime));
        this.player.setStopper((AudioStopper)new PlayStop());
        this.player.setAudioListener((AudioListener)new AudioMove());
        this.playButton.setEnabled(false);
        Thread t = new Thread(new Playing(this.audioFile, starttime, endtime));
        t.start();
    }

    public void stop() {
        log.trace((Object)"call stop");
        this.stopped = true;
        this.shell.getDisplay().asyncExec((Runnable)new EnablePlay());
    }

    public int timeToRealValue(long time) {
        return (int)(time * (long)this.waveFormFigureCanvas.getBaseMemoryPixel() / 1000L);
    }

    public void setFocus() {
    }

    public void openFile() {
        this.subApplication.openFile();
    }

    public void saveFile() {
        this.subApplication.saveFile();
    }

    public void saveAsFile() {
        this.subApplication.saveAsFile();
    }

    public class SubApplication
    extends RCPFileApplication {
        protected void execOpen() {
            SubView.this.initData();
            TimeBaseFileObject data = null;
            data = TimeBaseFileObjectReadUtils.read(this.getFile());
            if (data == null) {
                log.info((Object)("invalid data:" + this.getFile()));
                SubView.this.audioFile = null;
            } else {
                try {
                    SubView.this.setData(data);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (TimeBaseFileObjectReadUtils.checkType(this.getFile()) == 1) {
                this.setFile(null);
            }
            this.saveStatusChanged();
        }

        protected void execSave() {
            log.info((Object)"dosave");
            try {
                BeanWriter writer = new BeanWriter((Writer)new FileWriter(this.getFile()));
                writer.writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
                writer.write((Object)SubView.this.timeBaseFileObject);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }

        protected void saveStatusChanged() {
            String title = this.getFile() == null ? "Untitled" : this.getFile().getName();
            if (this.isNeedSave()) {
                title = "*" + title;
            }
            log.info((Object)("saveStatusChanged:" + title));
            SubView.this.getFileInfoStatusLine().setText(title);
        }

        protected void execNew() {
        }

        protected void execOpenSubFile(File file) {
            File srtFile;
            SubView.this.initData();
            TimeBaseFileObject data = null;
            if (TimeBaseFileObjectReadUtils.isWavFile(file.getName())) {
                data = new TimeBaseFileObject();
                data.addParameter(new ParameterObject("file", file.getAbsolutePath()));
                srtFile = new File(file.getParentFile(), TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(), "srt"));
                if (srtFile.exists()) {
                    data.addParameter(new ParameterObject("file", srtFile.getAbsolutePath()));
                }
            } else if (TimeBaseFileObjectReadUtils.isMP3File(file.getName())) {
                data = new TimeBaseFileObject();
                data.addParameter(new ParameterObject("file", file.getAbsolutePath()));
                srtFile = new File(file.getParentFile(), TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(), "srt"));
                if (srtFile.exists()) {
                    data.addParameter(new ParameterObject("file", srtFile.getAbsolutePath()));
                }
            }
            if (data != null) {
                try {
                    SubView.this.setData(data);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.setFile(null);
            this.saveStatusChanged();
        }

        protected boolean isStandardFile(File file) {
            return TimeBaseFileObjectReadUtils.isXMLFile(file.getName());
        }
    }

    public class LoadWave
    extends Thread {
        private AudioInputStream audioInputStream;
        private File targetAudioFile;

        public LoadWave(AudioInputStream audioInputStream, File targetAudioFile) {
            this.audioInputStream = audioInputStream;
            this.targetAudioFile = targetAudioFile;
        }

        public void run() {
            List byteList = SubView.this.waveFormFigureCanvas.loadByteList(this.audioInputStream);
            if (SubView.this.audioFile != null && SubView.this.audioFile.getAbsolutePath().equals(SubView.this.audioFile.getAbsolutePath())) {
                log.trace((Object)("setWaveFirugre:audio=" + SubView.this.audioFile + ",target=" + this.targetAudioFile.getAbsolutePath()));
                SubView.this.shell.getDisplay().asyncExec((Runnable)new SetWaveFormFigure(byteList));
            }
        }
    }

    public class SetWaveFormFigure
    extends Thread {
        List byteList;

        public SetWaveFormFigure(List byteList) {
            this.byteList = byteList;
        }

        public void run() {
            SubView.this.waveFormFigureCanvas.setByteData(this.byteList);
        }
    }

    public class ChangeSubInfo
    implements WaveFormListener {
        public void changeCurrent(long arg0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("changed:" + arg0));
            }
            int j = 0;
            while (j < SubView.this.srtListFigures.length) {
                if (SubView.this.srtListFigures[j].getStandardSubObjectList() != null) {
                    StandardSubObject[] subs = SubView.this.srtListFigures[j].getStandardSubObjectList().toArray(new StandardSubObject[SubView.this.srtListFigures[j].getStandardSubObjectList().size()]);
                    File baseFile = new File(SubView.this.srtListFigures[j].getSubObjectPath()).getParentFile();
                    int i = 0;
                    while (i < subs.length) {
                        if (subs[i].getStartTime() <= arg0 && subs[i].getEndTime() >= arg0) {
                            log.trace((Object)("sub-selected:" + subs[i].getText()));
                            if (subs[i].getText() != null && !SubView.this.subtitleShowText1.getText().equals(subs[i].getText())) {
                                if (j == 0) {
                                    SubView.this.subtitleShowText1.setText(subs[i].getText());
                                    SubView.this.subtitleShowText1.repaint();
                                } else {
                                    SubView.this.subtitleShowText2.setText(subs[i].getText());
                                    SubView.this.subtitleShowText2.repaint();
                                }
                            } else {
                                String imagePath = subs[i].getImagePath();
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("sub-image:" + imagePath));
                                }
                                if (imagePath != null) {
                                    Image image = SubView.this.imageCache.loadImage(new File(baseFile, imagePath).getAbsolutePath());
                                    if (j == 0) {
                                        if (image != null && !image.equals((Object)SubView.this.subtitleShowText1.getImage())) {
                                            log.trace((Object)("sub-setImage:" + imagePath));
                                            SubView.this.subtitleShowText1.setImage(image);
                                            SubView.this.subtitleShowText1.repaint();
                                        } else if (image != null) {
                                            log.trace((Object)("sub-sameimage:" + imagePath));
                                        }
                                    } else if (image != null && !image.equals((Object)SubView.this.subtitleShowText2.getImage())) {
                                        log.trace((Object)("sub-setImage:" + imagePath));
                                        SubView.this.subtitleShowText2.setImage(image);
                                        SubView.this.subtitleShowText2.repaint();
                                    } else if (image != null) {
                                        log.trace((Object)("sub-sameimage:" + imagePath));
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    public class PropertyCheck
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            log.trace((Object)("propertychange:" + event.getProperty() + "," + event.getNewValue() + "," + event.getOldValue()));
            if (event.getProperty().equals("subview.layer1_bg_color")) {
                RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_bg_color");
                SubView.this.subtitleShowText1.setBackgroundColor(new Color(null, c));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setBackgroundColor(new Color(null, c));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_fg_color")) {
                RGB c = PreferenceConverter.getColor((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_fg_color");
                SubView.this.subtitleShowText1.setForegroundColor(new Color(null, c));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setForegroundColor(new Color(null, c));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_transparent")) {
                int transparent = Integer.parseInt((String)event.getNewValue());
                log.trace((Object)("new-trans:" + transparent));
                SubView.this.subtitleShowText1.setAlpha(transparent);
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setAlpha(transparent);
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.layer1_font")) {
                log.trace((Object)("font:" + SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.layer1_font")));
                FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)SubplayerPlugin.getDefault().getPreferenceStore(), (String)"subview.layer1_font");
                SubView.this.subtitleShowText1.setFont(new Font(null, fontData));
                SubView.this.subtitleShowText1.repaint(SubView.this.subtitleShowText1.getClientArea());
                SubView.this.subtitleShowText2.setFont(new Font(null, fontData));
                SubView.this.subtitleShowText2.repaint(SubView.this.subtitleShowText2.getClientArea());
            } else if (event.getProperty().equals("subview.bgimage")) {
                log.info((Object)("bgimage:" + SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage")));
                Image img = new Image(null, SubplayerPlugin.getDefault().getPreferenceStore().getString("subview.bgimage"));
                if (img != null) {
                    if (SubView.this.ci.getImage() != null) {
                        SubView.this.ci.getImage().dispose();
                    }
                    SubView.this.ci.setImage(img);
                    SubView.this.ci.repaint(SubView.this.ci.getClientArea());
                }
            }
        }
    }

    public class ResizeBox
    extends Figure
    implements MouseListener,
    MouseMotionListener {
        int minWidth = 100;
        int minHeight = 100;
        int clickx;
        int clicky;
        Figure target;
        int sizeX = 20;
        int sizeY = 20;
        int marginX = 7;
        int marginY = 7;

        public ResizeBox(Figure target) {
            this.target = target;
            this.setForegroundColor(ColorConstants.gray);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setSize(this.sizeX, this.sizeY);
            this.setLocation(this.newPoint());
        }

        public void mousePressed(MouseEvent arg0) {
            this.clickx = arg0.x;
            this.clicky = arg0.y;
            log.trace((Object)("click:" + this.clickx + "," + this.clicky));
            arg0.consume();
        }

        public void mouseReleased(MouseEvent arg0) {
        }

        public void mouseDoubleClicked(MouseEvent arg0) {
        }

        public void mouseDragged(MouseEvent arg0) {
            int moveX = this.clickx - arg0.x;
            int moveY = this.clicky - arg0.y;
            this.clickx = arg0.x;
            this.clicky = arg0.y;
            boolean movex = false;
            boolean movey = false;
            int newSizeX = 0;
            int newSizeY = 0;
            if (this.target.getSize().width > this.minWidth) {
                newSizeX = Math.max(this.minWidth, this.target.getSize().width - moveX);
            } else if (this.target.getSize().width <= this.minWidth) {
                newSizeX = Math.max(this.minWidth, this.target.getSize().width - moveX);
            }
            if (this.target.getSize().height > this.minHeight) {
                newSizeY = Math.max(this.minHeight, this.target.getSize().height - moveY);
            } else if (this.target.getSize().height <= this.minHeight) {
                newSizeY = Math.max(this.minHeight, this.target.getSize().height - moveY);
            }
            if (newSizeX > 0 && newSizeY > 0) {
                log.trace((Object)("newsize:" + newSizeX + "," + newSizeY));
                SubView.this.shell.getDisplay().syncExec((Runnable)new Resize(this.target, newSizeX, newSizeY));
            }
            if (newSizeX > this.minWidth) {
                movex = true;
            }
            if (newSizeY > this.minHeight) {
                movey = true;
            }
            if (movex || movey) {
                Point current = this.newPoint();
                log.trace((Object)("newPoint:" + current));
                this.setLocation(current);
            }
            arg0.consume();
        }

        public Point newPoint() {
            return new Point(this.target.getLocation().x + this.target.getSize().width - this.sizeX - this.marginX, this.target.getLocation().y + this.target.getSize().height - this.sizeY - this.marginY);
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mouseHover(MouseEvent arg0) {
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void paintFigure(Graphics g) {
            g.drawRectangle(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width - 1, this.getClientArea().height - 1);
        }

        public class Resize
        implements Runnable {
            Figure target;
            int w;
            int h;

            public Resize(Figure target, int w, int h) {
                this.target = target;
                this.w = w;
                this.h = h;
            }

            public void run() {
                this.target.setSize(this.w, this.h);
            }
        }
    }

    public class MixWindowFigure
    extends Figure {
        private Figure shadowFigure;
        private Figure mainFigure;
        int shadowSizeX = 5;
        int shadowSizeY = 5;

        public Figure getMainFigure() {
            return this.mainFigure;
        }

        public void setMainFigure(Figure mainFigure) {
            this.mainFigure = mainFigure;
        }

        public Figure getShadowFigure() {
            return this.shadowFigure;
        }

        public void setShadowFigure(Figure shadowFigure) {
            this.shadowFigure = shadowFigure;
        }

        public void setSize(int w, int h) {
            super.setSize(w, h);
            this.shadowFigure.setSize(this.getSize().width - this.shadowSizeX, this.getSize().height - this.shadowSizeY);
            this.mainFigure.setSize(this.getSize().width - this.shadowSizeX, this.getSize().height - this.shadowSizeY);
        }
    }

    public class FigureMove
    implements MouseMotionListener,
    MouseListener {
        int downx = 0;
        int downy = 0;
        boolean pressed = false;

        public void mouseDragged(MouseEvent me) {
            if (this.pressed) {
                log.trace((Object)("dragged:" + me));
                Figure figure = (Figure)me.getSource();
                int moveX = this.downx - me.x;
                int moveY = this.downy - me.y;
                log.trace((Object)("moveX=" + moveX + ",moveY=" + moveY));
                Point loc = figure.getLocation();
                loc.x -= moveX;
                loc.y -= moveY;
                log.trace((Object)("locx=" + loc.x + ",loc.y=" + loc.y));
                figure.setLocation(loc);
                this.downx = me.x;
                this.downy = me.y;
                me.consume();
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            Figure figure = (Figure)me.getSource();
            IFigure parent = figure.getParent();
            List list = parent.getChildren();
            int index = 0;
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) == figure) {
                    index = i;
                    break;
                }
                ++i;
            }
            log.trace((Object)("index:" + index));
            if (index != list.size() - 1) {
                parent.remove((IFigure)figure);
                parent.add((IFigure)figure);
            }
            this.downx = me.x;
            this.downy = me.y;
            this.pressed = true;
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            this.pressed = false;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    public class SRTClick
    implements MouseListener {
        public void mousePressed(MouseEvent me) {
            int i = 0;
            while (i < SubView.this.srtListFigures.length) {
                StandardSubObject[] subs = SubView.this.srtListFigures[i].containSubtitles(me.x, me.y);
                if (subs.length > 0) {
                    int dx1 = SubView.this.timeToRealValue(subs[0].getStartTime());
                    int dx2 = SubView.this.timeToRealValue(subs[0].getEndTime());
                    SubView.this.waveFormFigureCanvas.setSelectRealValue(dx1, dx2);
                    me.consume();
                    break;
                }
                ++i;
            }
        }

        public void mouseReleased(MouseEvent me) {
            int i = 0;
            while (i < SubView.this.srtListFigures.length) {
                StandardSubObject[] subs = SubView.this.srtListFigures[i].containSubtitles(me.x, me.y);
                if (subs.length > 0) {
                    int dx1 = SubView.this.timeToRealValue(subs[0].getStartTime());
                    int dx2 = SubView.this.timeToRealValue(subs[0].getEndTime());
                    SubView.this.waveFormFigureCanvas.setSelectRealValue(dx1, dx2);
                    me.consume();
                    break;
                }
                ++i;
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }

    public class Zoomup
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.zoomUp();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class Zoomdown
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.waveFormFigureCanvas.zoomDown();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class SRTFigure
    extends DoubleScalableFigure {
        long start = 1000L;
        long end = 2000L;
        private int index;
        private String text;
        int height = 32;
        AlphaLayerFigure alpha;

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setImage(Image img) {
        }

        public SRTFigure(Shell shell, int index) {
            super(1, 1);
            this.index = index;
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.setScale(1.0, 1.0);
        }

        public void setScale(double w, double h) {
            this.wzoom = w;
            this.hzoom = h;
            this.setBounds(this.getRectangle());
        }

        public Rectangle getRectangle() {
            int dx = (int)((double)this.start * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
            int dx2 = (int)((double)this.end * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
            Rectangle rectangle = new Rectangle(dx, this.getClientArea().y, dx2 - dx, this.height);
            if (this.getParent() != null) {
                rectangle.x += this.getParent().getClientArea().x;
            }
            log.trace((Object)("srt-rectangle:" + rectangle));
            return rectangle;
        }

        public void paintFigure(Graphics g) {
            log.trace((Object)("srt-paint:" + this.getClientArea()));
            if (this.text != null) {
                g.setFont(new Font((Device)SubView.this.shell.getDisplay(), "MS \u660e\u671d", 12, 0));
                g.drawString(this.text, this.getClientArea().x, this.getClientArea().y);
            }
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public class Stop
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.stop();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class PlayStop
    implements AudioStopper {
        public boolean isStopped() {
            return SubView.this.stopped;
        }

        public void setStopped(boolean arg0) {
        }
    }

    public class SRTListFigure
    extends DoubleScalableFigure {
        List standardSubObjectList;
        private Rectangle[] inRectangle;
        private int rectangleY = 32;
        private int rectangleHeight = 32;
        private Image[] labelImages = new Image[8];
        private String subObjectPath;

        public SRTListFigure(int arg0, int arg1) {
            super(arg0, arg1);
            this.labelImages[0] = AlphaUtils.createColorAlphaImageData((Color)ColorConstants.white, (int)128);
            this.labelImages[1] = AlphaUtils.createColorAlphaImageData((Color)ColorConstants.red, (int)128);
        }

        public void setStandardSubObjectList(List list) {
            this.standardSubObjectList = list;
        }

        public StandardSubObject[] containSubtitles(int x, int y) {
            if (this.standardSubObjectList != null) {
                ArrayList tmp = new ArrayList();
                int i = 0;
                while (i < this.inRectangle.length) {
                    if (this.inRectangle[i].contains(-this.getParent().getBounds().x + x, y)) {
                        tmp.add(this.standardSubObjectList.get(i));
                    }
                    ++i;
                }
                return tmp.toArray(new StandardSubObject[tmp.size()]);
            }
            return new StandardSubObject[0];
        }

        public void setScale(double w, double h) {
            super.setScale(w, h);
            this.rerect();
        }

        public void rerect() {
            log.trace((Object)"rerect");
            if (this.standardSubObjectList != null) {
                StandardSubObject[] subs = this.standardSubObjectList.toArray(new StandardSubObject[this.standardSubObjectList.size()]);
                Rectangle[] tmpRect = new Rectangle[subs.length];
                int i = 0;
                while (i < subs.length) {
                    int dx = (int)((double)subs[i].getStartTime() * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
                    int dx2 = (int)((double)subs[i].getEndTime() * this.getHorizontalScale() / SubView.this.waveFormFigureCanvas.getSplitFrame() / 1000.0);
                    tmpRect[i] = new Rectangle(dx, this.rectangleY, dx2 - dx, this.rectangleHeight);
                    log.trace((Object)("subrect:" + tmpRect[i]));
                    ++i;
                }
                this.inRectangle = tmpRect;
            } else {
                this.inRectangle = new Rectangle[0];
            }
        }

        public void paintFigure(Graphics g) {
            if (this.inRectangle == null) {
                this.rerect();
            }
            log.trace((Object)("srtlist-paint:" + this.getClientArea() + ",inRectangle=" + this.inRectangle.length));
            int i = 0;
            while (i < this.inRectangle.length) {
                Rectangle drawRec = new Rectangle(this.inRectangle[i].x + this.getParent().getBounds().x, this.inRectangle[i].y, this.inRectangle[i].width, this.inRectangle[i].height);
                if (i % 5 == 0) {
                    g.drawImage(this.labelImages[1], new Rectangle(this.labelImages[1].getBounds()), drawRec);
                } else {
                    g.drawImage(this.labelImages[0], new Rectangle(this.labelImages[0].getBounds()), drawRec);
                }
                ++i;
            }
        }

        public int getRectangleHeight() {
            return this.rectangleHeight;
        }

        public void setRectangleHeight(int rectangleHeight) {
            this.rectangleHeight = rectangleHeight;
        }

        public int getRectangleY() {
            return this.rectangleY;
        }

        public void setRectangleY(int rectangleY) {
            this.rectangleY = rectangleY;
        }

        public List getStandardSubObjectList() {
            return this.standardSubObjectList;
        }

        public String getSubObjectPath() {
            return this.subObjectPath;
        }

        public void setSubObjectPath(String subObjectPath) {
            this.subObjectPath = subObjectPath;
        }
    }

    public class EnablePlay
    implements Runnable {
        public void run() {
            SubView.this.playButton.setEnabled(true);
        }
    }

    public class Playing
    implements Runnable {
        private File file;
        private long start;
        private long end;

        public Playing(File file, long start, long end) {
            this.file = file;
            this.start = start;
            this.end = end;
        }

        public void run() {
            if (SubView.this.stopped) {
                log.trace((Object)("play-duration:" + (this.end - this.start)));
                SubView.this.stopped = false;
                try {
                    SubView.this.player.play(this.file, this.start, this.end);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (LineUnavailableException e) {
                    e.printStackTrace();
                }
            }
            SubView.this.stop();
        }
    }

    public class MovePosition
    implements Runnable {
        private int selection;

        public MovePosition(int selection) {
            this.selection = selection;
        }

        public void run() {
            SubView.this.waveFormFigureCanvas.moveCurrentPosition(this.selection);
        }
    }

    public class AudioMove
    implements AudioListener {
        public void startPlaying() {
            SubView.this.playing = true;
            SubView.this.shell.getDisplay().syncExec((Runnable)new MovePosition(((SubView)SubView.this).selection.x));
            log.info((Object)"start-playing2");
            PlayMove move = new PlayMove(((SubView)SubView.this).selection.x);
            Thread t = new Thread(move);
            t.start();
        }

        public void stopPlaying() {
            log.trace((Object)"stopplaying");
            SubView.this.stopped = true;
            SubView.this.playing = false;
        }

        public void finishPlaying() {
            log.trace((Object)"finishplaying");
            SubView.this.stopped = true;
            SubView.this.playing = false;
        }
    }

    public class PlayMove
    implements Runnable {
        int sleeptime = 30;
        int startPosition;

        public PlayMove(int start) {
            this.startPosition = start;
        }

        public void run() {
            long start = System.currentTimeMillis();
            while (SubView.this.playing) {
                try {
                    Thread.sleep(this.sleeptime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long played = System.currentTimeMillis() - start;
                if (played > SubView.this.duration) break;
                SubView.this.shell.getDisplay().syncExec((Runnable)new MovePosition(this.toPosition(played)));
            }
        }

        public int toPosition(long time) {
            return SubView.this.timeToRealValue(time) + this.startPosition;
        }
    }

    public class CenterImageFigure
    extends Figure {
        private Image image;
        private Canvas parentCanvas;

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Canvas getParentCanvas() {
            return this.parentCanvas;
        }

        public void setParentCanvas(Canvas parentCanvas) {
            this.parentCanvas = parentCanvas;
            parentCanvas.addControlListener((ControlListener)new ResizeCheck());
            parentCanvas.getHorizontalBar().addSelectionListener((SelectionListener)new Selection());
        }

        public void paintFigure(Graphics g) {
            Rectangle client = new Rectangle(this.parentCanvas.getClientArea());
            Rectangle rec = g.getClip(client);
            log.trace((Object)("repaint:" + rec));
            if (this.image != null) {
                int centerX = (this.parentCanvas.getClientArea().width - this.image.getBounds().width) / 2;
                int centerY = (this.parentCanvas.getClientArea().height - this.image.getBounds().height) / 2;
                Rectangle rectangle = new Rectangle(this.getLocation().x + centerX, this.getLocation().y + centerY, this.image.getBounds().width, this.image.getBounds().height);
                log.trace((Object)("g:" + rectangle));
                g.drawImage(this.image, new Rectangle(this.image.getBounds()), rectangle);
            }
        }

        public void moveImage() {
            log.trace((Object)"move");
            this.setLocation(new Point(this.parentCanvas.getHorizontalBar().getSelection(), this.parentCanvas.getVerticalBar().getSelection()));
        }

        public class Selection
        implements SelectionListener {
            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }

        public class ResizeCheck
        implements ControlListener {
            public void controlMoved(ControlEvent e) {
                log.trace((Object)"moved");
            }

            public void controlResized(ControlEvent e) {
                log.trace((Object)"resized");
                CenterImageFigure.this.setSize(((CenterImageFigure)CenterImageFigure.this).parentCanvas.getClientArea().width, ((CenterImageFigure)CenterImageFigure.this).parentCanvas.getClientArea().height);
            }
        }
    }

    public class Play
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            SubView.this.play();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DrawTextFigure
    extends Figure {
    }

    public class Select
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            log.warn((Object)"select?");
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

