/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.io.CyclicReferenceException;
import org.apache.commons.betwixt.io.IDGenerator;
import org.apache.commons.betwixt.io.WriteContext;
import org.apache.commons.betwixt.io.id.SequentialIDGenerator;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractBeanWriter {
    private XMLIntrospector introspector = new XMLIntrospector();
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$AbstractBeanWriter == null ? (class$org$apache$commons$betwixt$io$AbstractBeanWriter = AbstractBeanWriter.class$("org.apache.commons.betwixt.io.AbstractBeanWriter")) : class$org$apache$commons$betwixt$io$AbstractBeanWriter));
    private HashMap idMap = new HashMap();
    private ArrayStack beanStack = new ArrayStack();
    private IDGenerator idGenerator = new SequentialIDGenerator();
    private boolean writeEmptyElements = true;
    private BindingConfiguration bindingConfiguration = new BindingConfiguration();
    private WriteContextImpl writeContext = new WriteContextImpl();
    private Collection namespacesDeclared = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$AbstractBeanWriter;

    public void start() throws IOException, SAXException {
    }

    public void end() throws IOException, SAXException {
    }

    public void write(Object bean) throws IOException, SAXException, IntrospectionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Writing bean graph...");
            this.log.debug(bean);
        }
        this.start();
        this.writeBean(null, null, null, bean, this.makeContext(bean));
        this.end();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Finished writing bean graph.");
        }
    }

    public void write(String qualifiedName, Object bean) throws IOException, SAXException, IntrospectionException {
        this.start();
        this.writeBean("", qualifiedName, qualifiedName, bean, this.makeContext(bean));
        this.end();
    }

    private void writeBean(String namespaceUri, String localName, String qualifiedName, Object bean, Context context) throws IOException, SAXException, IntrospectionException {
        ElementDescriptor elementDescriptor;
        XMLBeanInfo beanInfo;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Writing bean graph (qualified name '" + qualifiedName + "'"));
        }
        if ((beanInfo = this.introspector.introspect(bean)) != null && (elementDescriptor = beanInfo.getElementDescriptor()) != null) {
            context = context.newContext(bean);
            if (qualifiedName == null) {
                qualifiedName = elementDescriptor.getQualifiedName();
            }
            if (namespaceUri == null) {
                namespaceUri = elementDescriptor.getURI();
            }
            if (localName == null) {
                localName = elementDescriptor.getLocalName();
            }
            String ref = null;
            String id = null;
            if (elementDescriptor.isSimple()) {
                this.writeElement(namespaceUri, localName, qualifiedName, elementDescriptor, context);
            } else {
                this.pushBean(context.getBean());
                if (this.getBindingConfiguration().getMapIDs()) {
                    ref = (String)this.idMap.get(context.getBean());
                }
                if (ref == null) {
                    AttributeDescriptor idAttribute = beanInfo.getIDAttribute();
                    if (idAttribute == null) {
                        id = this.idGenerator.nextId();
                        this.idMap.put(bean, id);
                        if (this.getBindingConfiguration().getMapIDs()) {
                            this.writeElement(namespaceUri, localName, qualifiedName, elementDescriptor, context, beanInfo.getIDAttributeName(), id);
                        } else {
                            this.writeElement(namespaceUri, localName, qualifiedName, elementDescriptor, context);
                        }
                    } else {
                        Object exp = idAttribute.getTextExpression().evaluate(context);
                        if (exp == null) {
                            this.log.debug((Object)"Using random id");
                            id = this.idGenerator.nextId();
                        } else {
                            id = exp.toString();
                        }
                        this.idMap.put(bean, id);
                        this.writeElement(namespaceUri, localName, qualifiedName, elementDescriptor, context);
                    }
                } else if (!this.ignoreElement(elementDescriptor, context)) {
                    this.writeIDREFElement(elementDescriptor, namespaceUri, localName, qualifiedName, beanInfo.getIDREFAttributeName(), ref);
                }
                this.popBean();
            }
        }
        this.log.trace((Object)"Finished writing bean graph.");
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public BindingConfiguration getBindingConfiguration() {
        return this.bindingConfiguration;
    }

    public void setBindingConfiguration(BindingConfiguration bindingConfiguration) {
        this.bindingConfiguration = bindingConfiguration;
    }

    public boolean getWriteIDs() {
        return this.getBindingConfiguration().getMapIDs();
    }

    public void setWriteIDs(boolean writeIDs) {
        this.getBindingConfiguration().setMapIDs(writeIDs);
    }

    public boolean getWriteEmptyElements() {
        return this.writeEmptyElements;
    }

    public void setWriteEmptyElements(boolean writeEmptyElements) {
        this.writeEmptyElements = writeEmptyElements;
    }

    public XMLIntrospector getXMLIntrospector() {
        return this.introspector;
    }

    public void setXMLIntrospector(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public final Log getAbstractBeanWriterLog() {
        return this.log;
    }

    public final void setAbstractBeanWriterLog(Log log) {
        this.log = log;
    }

    protected void startElement(WriteContext context, String uri, String localName, String qName, Attributes attr) throws IOException, SAXException {
        this.startElement(uri, localName, qName, attr);
    }

    protected void endElement(WriteContext context, String uri, String localName, String qName) throws IOException, SAXException {
        this.endElement(uri, localName, qName);
    }

    protected void bodyText(WriteContext context, String text) throws IOException, SAXException {
        this.bodyText(text);
    }

    protected void startElement(String uri, String localName, String qName, Attributes attr) throws IOException, SAXException {
    }

    protected void endElement(String uri, String localName, String qName) throws IOException, SAXException {
    }

    protected void bodyText(String text) throws IOException, SAXException {
    }

    private void writeElement(String namespaceUri, String localName, String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Writing: " + qualifiedName + " element: " + elementDescriptor));
        }
        if (!this.ignoreElement(elementDescriptor, context)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Element " + elementDescriptor + " is empty."));
            }
            Attributes attributes = this.addNamespaceDeclarations(new ElementAttributes(elementDescriptor, context), namespaceUri);
            this.writeContext.setCurrentDescriptor(elementDescriptor);
            this.startElement(this.writeContext, namespaceUri, localName, qualifiedName, attributes);
            this.writeElementContent(elementDescriptor, context);
            this.writeContext.setCurrentDescriptor(elementDescriptor);
            this.endElement(this.writeContext, namespaceUri, localName, qualifiedName);
        }
    }

    private Attributes addNamespaceDeclarations(Attributes attributes, String elementNamespaceUri) {
        Attributes result = attributes;
        AttributesImpl withDeclarations = null;
        int i = -1;
        int size = attributes.getLength();
        while (i < size) {
            String uri = null;
            uri = i == -1 ? elementNamespaceUri : attributes.getURI(i);
            if (uri != null && !"".equals(uri) && !this.namespacesDeclared.contains(uri)) {
                if (withDeclarations == null) {
                    withDeclarations = new AttributesImpl(attributes);
                }
                withDeclarations.addAttribute("", "", "xmlns:" + this.getXMLIntrospector().getConfiguration().getPrefixMapper().getPrefix(uri), "NOTATION", uri);
                this.namespacesDeclared.add(uri);
            }
            ++i;
        }
        if (withDeclarations != null) {
            result = withDeclarations;
        }
        return result;
    }

    private void writeElement(String namespaceUri, String localName, String qualifiedName, ElementDescriptor elementDescriptor, Context context, String idAttribute, String idValue) throws IOException, SAXException, IntrospectionException {
        if (!this.ignoreElement(elementDescriptor, context)) {
            this.writeContext.setCurrentDescriptor(elementDescriptor);
            IDElementAttributes attributes = new IDElementAttributes(elementDescriptor, context, idAttribute, idValue);
            this.startElement(this.writeContext, namespaceUri, localName, qualifiedName, this.addNamespaceDeclarations(attributes, namespaceUri));
            this.writeElementContent(elementDescriptor, context);
            this.writeContext.setCurrentDescriptor(elementDescriptor);
            this.endElement(this.writeContext, namespaceUri, localName, qualifiedName);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Element " + qualifiedName + " is empty."));
        }
    }

    private void writeRestOfElement(String uri, String localName, String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        this.writeElementContent(elementDescriptor, context);
    }

    private void writeIDREFElement(ElementDescriptor elementDescriptor, String uri, String localName, String qualifiedName, String idrefAttributeName, String idrefAttributeValue) throws IOException, SAXException, IntrospectionException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", idrefAttributeName, idrefAttributeName, "IDREF", idrefAttributeValue);
        this.writeContext.setCurrentDescriptor(elementDescriptor);
        this.startElement(this.writeContext, uri, localName, qualifiedName, this.addNamespaceDeclarations(attributes, uri));
        this.endElement(this.writeContext, uri, localName, qualifiedName);
    }

    private void writeElementContent(ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        this.writeContext.setCurrentDescriptor(elementDescriptor);
        Descriptor[] childDescriptors = elementDescriptor.getContentDescriptors();
        if (childDescriptors != null && childDescriptors.length > 0) {
            int i = 0;
            int size = childDescriptors.length;
            while (i < size) {
                if (childDescriptors[i] instanceof ElementDescriptor) {
                    ElementDescriptor childDescriptor = (ElementDescriptor)childDescriptors[i];
                    Context childContext = context;
                    Expression childExpression = childDescriptor.getContextExpression();
                    if (childExpression != null) {
                        Object childBean = childExpression.evaluate(context);
                        if (childBean != null) {
                            String qualifiedName = childDescriptor.getQualifiedName();
                            String namespaceUri = childDescriptor.getURI();
                            String localName = childDescriptor.getLocalName();
                            if (childBean instanceof Iterator) {
                                Iterator iter = (Iterator)childBean;
                                while (iter.hasNext()) {
                                    Object object = iter.next();
                                    if (object == null) continue;
                                    this.writeBean(namespaceUri, localName, qualifiedName, object, context);
                                }
                            } else {
                                this.writeBean(namespaceUri, localName, qualifiedName, childBean, context);
                            }
                        }
                    } else {
                        this.writeElement(childDescriptor.getURI(), childDescriptor.getLocalName(), childDescriptor.getQualifiedName(), childDescriptor, childContext);
                    }
                } else {
                    Object value;
                    String text;
                    Expression expression = childDescriptors[i].getTextExpression();
                    if (expression != null && (text = this.convertToString(value = expression.evaluate(context), childDescriptors[i], context)) != null && text.length() > 0) {
                        this.bodyText(this.writeContext, text);
                    }
                }
                ++i;
            }
        } else {
            Object value;
            String text;
            Expression expression = elementDescriptor.getTextExpression();
            if (expression != null && (text = this.convertToString(value = expression.evaluate(context), elementDescriptor, context)) != null && text.length() > 0) {
                this.bodyText(this.writeContext, text);
            }
        }
    }

    protected void pushBean(Object bean) {
        if (!this.getBindingConfiguration().getMapIDs()) {
            Iterator it = this.beanStack.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (bean != next) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Element stack: ");
                    Iterator debugStack = this.beanStack.iterator();
                    while (debugStack.hasNext()) {
                        this.log.debug(debugStack.next());
                    }
                }
                this.log.error((Object)("Cyclic reference at bean: " + bean));
                throw new CyclicReferenceException();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Pushing onto object stack: " + bean));
        }
        this.beanStack.push(bean);
    }

    protected Object popBean() {
        Object bean = this.beanStack.pop();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Popped from object stack: " + bean));
        }
        return bean;
    }

    private boolean ignoreElement(ElementDescriptor descriptor, Context context) {
        if (!this.getWriteEmptyElements()) {
            return this.isEmptyElement(descriptor, context);
        }
        return false;
    }

    private boolean isEmptyElement(ElementDescriptor descriptor, Context context) {
        Object value;
        String text;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Is " + descriptor + " empty?"));
        }
        if (descriptor.hasAttributes()) {
            this.log.trace((Object)"Element has attributes.");
            return false;
        }
        Expression expression = descriptor.getTextExpression();
        if (expression != null && (text = this.convertToString(value = expression.evaluate(context), descriptor, context)) != null && text.length() > 0) {
            this.log.trace((Object)"Element has body text which isn't empty.");
            return false;
        }
        if (XMLIntrospectorHelper.isLoopType(descriptor.getPropertyType())) {
            this.log.trace((Object)"Loop type so not empty.");
            return false;
        }
        if (descriptor.hasChildren()) {
            int i = 0;
            int size = descriptor.getElementDescriptors().length;
            while (i < size) {
                if (!this.isEmptyElement(descriptor.getElementDescriptors()[i], context)) {
                    this.log.trace((Object)"Element has child which isn't empty.");
                    return false;
                }
                ++i;
            }
        }
        this.log.trace((Object)"Element is empty.");
        return true;
    }

    protected int getIndentLevel() {
        return 0;
    }

    protected void expressElementStart(String qualifiedName) throws IOException, SAXException {
    }

    protected void expressElementStart(String uri, String localName, String qualifiedName) throws IOException, SAXException {
        this.expressElementStart(qualifiedName);
    }

    protected void expressTagClose() throws IOException, SAXException {
    }

    protected void expressElementEnd(String qualifiedName) throws IOException, SAXException {
    }

    protected void expressElementEnd(String uri, String localName, String qualifiedName) throws IOException, SAXException {
        this.expressElementEnd(qualifiedName);
    }

    protected void expressElementEnd() throws IOException, SAXException {
    }

    protected void expressBodyText(String text) throws IOException, SAXException {
    }

    protected void expressAttribute(String qualifiedName, String value) throws IOException, SAXException {
    }

    protected void expressAttribute(String namespaceUri, String localName, String qualifiedName, String value) throws IOException, SAXException {
        this.expressAttribute(qualifiedName, value);
    }

    protected void write(String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        this.writeElement("", qualifiedName, qualifiedName, elementDescriptor, context);
    }

    protected void write(String qualifiedName, ElementDescriptor elementDescriptor, Context context, String idAttribute, String idValue) throws IOException, SAXException, IntrospectionException {
        this.writeElement("", qualifiedName, qualifiedName, elementDescriptor, context, idAttribute, idValue);
    }

    protected void writeRestOfElement(String qualifiedName, ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        this.writeRestOfElement("", qualifiedName, qualifiedName, elementDescriptor, context);
    }

    protected void writeIDREFElement(String qualifiedName, String idrefAttributeName, String idrefAttributeValue) throws IOException, SAXException, IntrospectionException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", idrefAttributeName, idrefAttributeName, "IDREF", idrefAttributeValue);
        this.startElement("", qualifiedName, qualifiedName, attributes);
        this.endElement("", qualifiedName, qualifiedName);
    }

    protected boolean writeContent(ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException, IntrospectionException {
        return false;
    }

    protected void writeAttributes(ElementDescriptor elementDescriptor, Context context) throws IOException, SAXException {
        if (!elementDescriptor.isWrapCollectionsInElement()) {
            return;
        }
        AttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributeDescriptors();
        if (attributeDescriptors != null) {
            int i = 0;
            int size = attributeDescriptors.length;
            while (i < size) {
                AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                this.writeAttribute(attributeDescriptor, context);
                ++i;
            }
        }
    }

    protected void writeAttribute(AttributeDescriptor attributeDescriptor, Context context) throws IOException, SAXException {
        String text;
        Object value;
        Expression expression = attributeDescriptor.getTextExpression();
        if (expression != null && (value = expression.evaluate(context)) != null && (text = value.toString()) != null && text.length() > 0) {
            this.expressAttribute(attributeDescriptor.getURI(), attributeDescriptor.getLocalName(), attributeDescriptor.getQualifiedName(), text);
        }
    }

    protected void writePrintln() throws IOException {
    }

    protected void writeIndent() throws IOException {
    }

    private String convertToString(Object value, Descriptor descriptor, Context context) {
        return this.getBindingConfiguration().getObjectStringConverter().objectToString(value, descriptor.getPropertyType(), null, context);
    }

    private Context makeContext(Object bean) {
        return new Context(bean, this.log, this.bindingConfiguration);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WriteContextImpl
    extends WriteContext {
        private ElementDescriptor currentDescriptor;

        private WriteContextImpl() {
        }

        public ElementDescriptor getCurrentDescriptor() {
            return this.currentDescriptor;
        }

        public void setCurrentDescriptor(ElementDescriptor currentDescriptor) {
            this.currentDescriptor = currentDescriptor;
        }
    }

    private class IDElementAttributes
    extends ElementAttributes {
        private String idValue;
        private String idAttributeName;
        private boolean matchingAttribute = false;
        private int length;
        private int idIndex;

        IDElementAttributes(ElementDescriptor descriptor, Context context, String idAttributeName, String idValue) {
            super(descriptor, context);
            this.idValue = idValue;
            this.idAttributeName = idAttributeName;
            AttributeDescriptor[] attributeDescriptors = descriptor.getAttributeDescriptors();
            this.length = attributeDescriptors.length;
            int i = 0;
            while (i < this.length) {
                if (idAttributeName.equals(attributeDescriptors[i])) {
                    this.matchingAttribute = true;
                    this.idIndex = i;
                    break;
                }
                ++i;
            }
            if (!this.matchingAttribute) {
                ++this.length;
                this.idIndex = this.length - 1;
            }
        }

        public int getIndex(String uri, String localName) {
            if (localName.equals(this.idAttributeName)) {
                return this.idIndex;
            }
            return super.getIndex(uri, localName);
        }

        public int getIndex(String qName) {
            if (qName.equals(this.idAttributeName)) {
                return this.idIndex;
            }
            return super.getIndex(qName);
        }

        public int getLength() {
            return this.length;
        }

        public String getLocalName(int index) {
            if (index == this.idIndex) {
                return this.idAttributeName;
            }
            return super.getLocalName(index);
        }

        public String getQName(int index) {
            if (index == this.idIndex) {
                return this.idAttributeName;
            }
            return super.getQName(index);
        }

        public String getType(int index) {
            if (index == this.idIndex) {
                return "ID";
            }
            return super.getType(index);
        }

        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        public String getURI(int index) {
            if (index == this.idIndex) {
                return "";
            }
            return super.getURI(index);
        }

        public String getValue(int index) {
            if (index == this.idIndex) {
                return this.idValue;
            }
            return super.getValue(index);
        }

        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }
    }

    private class ElementAttributes
    implements Attributes {
        private AttributeDescriptor[] attributes;
        private Context context;

        ElementAttributes(ElementDescriptor descriptor, Context context) {
            this.attributes = descriptor.getAttributeDescriptors();
            this.context = context;
        }

        public int getIndex(String qName) {
            int i = 0;
            while (i < this.attributes.length) {
                if (this.attributes[i].getQualifiedName() != null && this.attributes[i].getQualifiedName().equals(qName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            int i = 0;
            while (i < this.attributes.length) {
                if (this.attributes[i].getURI() != null && this.attributes[i].getURI().equals(uri) && this.attributes[i].getLocalName() != null && this.attributes[i].getURI().equals(localName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getLength() {
            return this.attributes.length;
        }

        public String getLocalName(int index) {
            if (this.indexInRange(index)) {
                return this.attributes[index].getLocalName();
            }
            return null;
        }

        public String getQName(int index) {
            if (this.indexInRange(index)) {
                return this.attributes[index].getQualifiedName();
            }
            return null;
        }

        public String getType(int index) {
            if (this.indexInRange(index)) {
                return "CDATA";
            }
            return null;
        }

        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        public String getURI(int index) {
            if (this.indexInRange(index)) {
                return this.attributes[index].getURI();
            }
            return null;
        }

        public String getValue(int index) {
            if (this.indexInRange(index)) {
                Expression expression = this.attributes[index].getTextExpression();
                if (expression != null) {
                    Object value = expression.evaluate(this.context);
                    return AbstractBeanWriter.this.convertToString(value, this.attributes[index], this.context);
                }
                return "";
            }
            return null;
        }

        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }

        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        private boolean indexInRange(int index) {
            return index >= 0 && index < this.attributes.length;
        }
    }
}

