/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.collections.primitives.ArrayByteList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.WaveUtils;

public class WaveFormUtils {
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.commons.audio.WaveFormUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static List toWavEmptyValue(double splitframe, long duration, int maxByte) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayByteList v = new ArrayByteList();
        int size = (int)((double)duration / (1000.0 * splitframe));
        int arraySize = size / maxByte;
        int byteSize = size % maxByte;
        int i = 0;
        while (i < arraySize) {
            arrayList.add(new byte[maxByte]);
            ++i;
        }
        if (byteSize > 0) {
            byte[] tmpb = new byte[byteSize];
            arrayList.add(tmpb);
        }
        return arrayList;
    }

    public static List toWavValue(double splitframe, File file, int maxByte) {
        log.trace((Object)("toWavValue:" + splitframe + "," + file.getAbsolutePath() + "," + maxByte));
        try {
            FileInputStream stream = new FileInputStream(file);
            AudioInputStream inputStream = null;
            if (file.getName().toLowerCase().endsWith(".wav")) {
                AudioSystem.getAudioInputStream(stream);
            } else if (file.getName().toLowerCase().endsWith(".mp3")) {
                AudioSystem.getAudioInputStream(stream);
            }
            return WaveFormUtils.toWavValue(splitframe, inputStream, maxByte);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List toWavValue2(double splitframe, AudioInputStream inputStream, int maxByte) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayByteList v = new ArrayByteList();
        try {
            AudioFormat format = inputStream.getFormat();
            int readBytes = 0;
            int perpixel = (int)((double)format.getFrameRate() * splitframe);
            log.trace((Object)("framerate=" + format.getFrameRate() + " minPixelRate=" + splitframe));
            log.debug((Object)("pixel:" + perpixel));
            log.debug((Object)("channel:" + format.getChannels()));
            int byteBit = format.getSampleSizeInBits() / 8;
            log.debug((Object)("byteBit:" + byteBit));
            byte[] bytedata = new byte[format.getChannels() * byteBit * (int)format.getFrameRate()];
            float frequency = format.getFrameRate();
            int per = format.getChannels() * byteBit;
            long index = 0L;
            long parseStart = System.currentTimeMillis();
            log.trace((Object)("bytedata:" + bytedata.length));
            block2: while (readBytes != -1) {
                readBytes = inputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < bytedata.length) {
                    log.trace((Object)("min readbytes " + readBytes));
                }
                if (readBytes >= 0) {
                    int px = (int)(1.0 / splitframe);
                    int i = 0;
                    while (i < px) {
                        int at = (int)(frequency / (float)px * (float)i);
                        int bt = at * per + 1;
                        if (bt < readBytes) {
                            v.add(bytedata[bt]);
                            if (v.size() == maxByte) {
                                arrayList.add(v.toArray());
                                v = new ArrayByteList();
                            }
                        } else {
                            log.trace((Object)"end parse");
                            break block2;
                        }
                        ++i;
                    }
                }
                ++index;
            }
            log.debug((Object)("parsetime:" + (System.currentTimeMillis() - parseStart) + "ms"));
            inputStream.close();
            log.trace((Object)("total time=" + v.size() / perpixel));
            log.trace((Object)("size:" + v.size()));
            if (v.size() > 0) {
                arrayList.add(v.toArray());
            }
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List toWavValue3(double splitframe, AudioInputStream inputStream, int maxByte) {
        if (splitframe > 0.02) {
            log.warn((Object)"**maybe mp3 file don't support this split");
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayByteList v = new ArrayByteList();
        try {
            int bt;
            AudioFormat format = inputStream.getFormat();
            boolean readBytes = false;
            int perpixel = (int)((double)format.getFrameRate() * splitframe);
            log.trace((Object)("framerate=" + format.getFrameRate() + " minPixelRate=" + splitframe));
            log.debug((Object)("pixel:" + perpixel));
            log.debug((Object)("channel:" + format.getChannels()));
            int byteBit = format.getSampleSizeInBits() / 8;
            log.debug((Object)("byteBit:" + byteBit));
            float frequency = format.getFrameRate();
            int per = format.getChannels() * byteBit;
            long parseStart = System.currentTimeMillis();
            long readed = 0L;
            int pat = perpixel * per;
            byte[] bytes = new byte[pat];
            log.trace((Object)("bytes-length:" + bytes.length));
            long totalreaded = 0L;
            while ((bt = inputStream.read(bytes)) != -1) {
                if (bt < pat) {
                    log.warn((Object)("readed:" + bt));
                }
                if (bt > 1) {
                    v.add(bytes[1]);
                    if (v.size() == maxByte) {
                        arrayList.add(v.toArray());
                        v = new ArrayByteList();
                    }
                }
                totalreaded += (long)bt;
            }
            log.trace((Object)("total readbyte:" + totalreaded));
            log.debug((Object)("parsetime:" + (System.currentTimeMillis() - parseStart) + "ms"));
            inputStream.close();
            log.trace((Object)("reaminsize:" + v.size()));
            long totalbyte = arrayList.size() * maxByte;
            if (v.size() > 0) {
                arrayList.add(v.toArray());
                totalbyte += (long)v.size();
            }
            log.trace((Object)("total-byte:" + totalbyte));
            log.trace((Object)("total time=" + totalbyte * (long)perpixel / 1000L + "sec"));
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List toWavValue(double splitframe, AudioInputStream inputStream, int maxByte) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayByteList v = new ArrayByteList();
        try {
            int bt;
            AudioFormat format = inputStream.getFormat();
            boolean readBytes = false;
            int persample = (int)((double)format.getFrameRate() * splitframe);
            log.trace((Object)("framerate=" + format.getFrameRate() + " minPixelRate=" + splitframe));
            log.debug((Object)("pixel:" + persample));
            log.debug((Object)("channel:" + format.getChannels()));
            int byteBit = format.getSampleSizeInBits() / 8;
            log.debug((Object)("byteBit:" + byteBit));
            float frequency = format.getFrameRate();
            int per = format.getChannels() * byteBit;
            long parseStart = System.currentTimeMillis();
            long readed = 0L;
            long pat = persample * per;
            byte[] buffer = new byte[per];
            int index = 0;
            BufferedInputStream binput = new BufferedInputStream(inputStream, 102400);
            while ((bt = binput.read(buffer)) != -1) {
                if (bt > 1 && index % persample == 0) {
                    v.add(buffer[1]);
                    if (v.size() == maxByte) {
                        arrayList.add(v.toArray());
                        v = new ArrayByteList();
                    }
                }
                ++index;
                readed += (long)bt;
            }
            log.debug((Object)("parsetime:" + (System.currentTimeMillis() - parseStart) + "ms"));
            binput.close();
            log.trace((Object)("total time=" + v.size() / persample));
            log.trace((Object)("size:" + v.size()));
            if (v.size() > 0) {
                arrayList.add(v.toArray());
            }
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] toWavValue(double perms, File file) {
        ArrayByteList v = new ArrayByteList();
        try {
            FileInputStream stream = new FileInputStream(file);
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(stream);
            AudioFormat format = WaveUtils.getAudioFormat(file);
            int readBytes = 0;
            int perpixel = (int)((double)format.getFrameRate() * perms);
            log.trace((Object)("framerate=" + format.getFrameRate() + " minPixelRate=" + perms));
            log.debug((Object)("pixel:" + perpixel));
            log.debug((Object)("channel:" + format.getChannels()));
            int byteBit = format.getSampleSizeInBits() / 8;
            log.debug((Object)("byteBit:" + byteBit));
            byte[] bytedata = new byte[format.getChannels() * byteBit * (int)format.getFrameRate()];
            float frequency = format.getFrameRate();
            int per = format.getChannels() * byteBit;
            long index = 0L;
            long parseStart = System.currentTimeMillis();
            log.trace((Object)("bytedata:" + bytedata.length));
            block2: while (readBytes != -1) {
                readBytes = inputStream.read(bytedata, 0, bytedata.length);
                if (readBytes < bytedata.length) {
                    log.trace((Object)("min readbytes " + readBytes));
                } else {
                    log.trace((Object)("read:" + readBytes));
                }
                if (readBytes >= 0) {
                    int px = (int)(1.0 / perms);
                    int i = 0;
                    while (i < px) {
                        int at = (int)(frequency / (float)px * (float)i);
                        int bt = at * per + 1;
                        if (bt >= readBytes) {
                            log.trace((Object)"end parse");
                            break block2;
                        }
                        v.add(bytedata[bt]);
                        ++i;
                    }
                }
                ++index;
            }
            log.debug((Object)("parsetime:" + (System.currentTimeMillis() - parseStart) + "ms"));
            inputStream.close();
            log.trace((Object)("total time=" + v.size() / perpixel));
            log.trace((Object)("size:" + v.size()));
            return v.toArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

