/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.jpn.xucker.rcp.draw2d.GraphLabelProvider;

public class SimpleGraphMemoryPainterDraw2D {
    private boolean vGraph;
    private boolean graphPlus;
    private int mainGridPixel = 8;
    private int subGridPixel = 4;
    private int subSubGridPixel = 2;
    private boolean gridPlus;
    private String[] mainLabel;
    private boolean drawLine;
    private Color lineColor = new Color(null, 0, 0, 0);
    private Color textColor = new Color(null, 0, 0, 0);
    private double perMain = 100.0;
    private int splitSub = 2;
    private int splitSubSub = 5;
    private int marginGrid = 2;
    private GraphLabelProvider labelProvider;

    public boolean isDrawLine() {
        return this.drawLine;
    }

    public void setDrawLine(boolean drawLine) {
        this.drawLine = drawLine;
    }

    public boolean isGraphPlus() {
        return this.graphPlus;
    }

    public void setGraphPlus(boolean graphPlus) {
        this.graphPlus = graphPlus;
    }

    public boolean isGridPlus() {
        return this.gridPlus;
    }

    public void setGridPlus(boolean gridPlus) {
        this.gridPlus = gridPlus;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getMainGridPixel() {
        return this.mainGridPixel;
    }

    public void setMainGridPixel(int mainGridPixel) {
        this.mainGridPixel = mainGridPixel;
    }

    public String[] getMainLabel() {
        return this.mainLabel;
    }

    public void setMainLabel(String[] mainLabel) {
        this.mainLabel = mainLabel;
    }

    public int getMarginGrid() {
        return this.marginGrid;
    }

    public void setMarginGrid(int marginGrid) {
        this.marginGrid = marginGrid;
    }

    public double getPerMain() {
        return this.perMain;
    }

    public void setPerMain(double perMain) {
        this.perMain = perMain;
    }

    public int getSplitSub() {
        return this.splitSub;
    }

    public void setSplitSub(int splitSub) {
        this.splitSub = splitSub;
    }

    public int getSplitSubSub() {
        return this.splitSubSub;
    }

    public void setSplitSubSub(int splitSubSub) {
        this.splitSubSub = splitSubSub;
    }

    public int getSubGridPixel() {
        return this.subGridPixel;
    }

    public void setSubGridPixel(int subGridPixel) {
        this.subGridPixel = subGridPixel;
    }

    public int getSubSubGridPixel() {
        return this.subSubGridPixel;
    }

    public void setSubSubGridPixel(int subSubGridPixel) {
        this.subSubGridPixel = subSubGridPixel;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean isVerticalGraph() {
        return this.vGraph;
    }

    public void setVerticalGraph(boolean graph) {
        this.vGraph = graph;
    }

    public void draw(Graphics gc, int drawX, int drawY, int length) {
        if (this.vGraph) {
            this.drawVerticalGraph(gc, drawX, drawY, length);
        } else {
            this.drawHorizontalGraph(gc, drawX, drawY, length);
        }
    }

    public void drawVerticalGraph(Graphics gc, int drawX, int drawY, int length) {
        gc.setForegroundColor(this.lineColor);
        if (this.graphPlus) {
            gc.drawLine(drawX, drawY, drawX, drawY + length);
        } else {
            gc.drawLine(drawX, drawY, drawX, drawY - length);
        }
        int duration = 1;
        if (!this.gridPlus) {
            duration = -1;
        }
        double current = drawY;
        if (this.graphPlus) {
            int index = 0;
            while (current <= (double)(drawY + length)) {
                gc.drawLine(drawX, (int)current, drawX + duration * this.mainGridPixel, (int)current);
                int subPer = (int)(this.perMain / (double)this.splitSub);
                int subSubPer = subPer / this.splitSubSub;
                int i = 0;
                while (i < this.splitSub) {
                    if (current + (double)(subPer * i) < (double)(drawY + length)) {
                        if (i != 0) {
                            gc.drawLine(drawX, (int)current + subPer * i, drawX + duration * this.subGridPixel, (int)current + subPer * i);
                        }
                        int j = 1;
                        while (j < this.splitSubSub) {
                            if (current + (double)(subPer * i) + (double)(subSubPer * j) < (double)(drawY + length)) {
                                gc.drawLine(drawX, (int)current + subPer * i + subSubPer * j, drawX + duration * this.subSubGridPixel, (int)current + subPer * i + subSubPer * j);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                String label = this.labelAt(index);
                this.drawLabelVertical(gc, drawX, (int)current, label);
                current += this.perMain;
                ++index;
            }
        } else {
            int index = 0;
            while (current > (double)(drawY - length)) {
                gc.drawLine(drawX, (int)current, drawX + duration * this.mainGridPixel, (int)current);
                int subPer = (int)(this.perMain / (double)this.splitSub);
                int subSubPer = subPer / this.splitSubSub;
                int i = 0;
                while (i < this.splitSub) {
                    if (i != 0) {
                        gc.drawLine(drawX, (int)current - subPer * i, drawX + duration * this.subGridPixel, (int)current - subPer * i);
                    }
                    int j = 1;
                    while (j < this.splitSubSub) {
                        gc.drawLine(drawX, (int)current - subPer * i - subSubPer * j, drawX + duration * this.subSubGridPixel, (int)current - subPer * i - subSubPer * j);
                        ++j;
                    }
                    ++i;
                }
                String label = this.labelAt(index);
                this.drawLabelVertical(gc, drawX, (int)current, label);
                current -= this.perMain;
                ++index;
            }
        }
    }

    public void drawHorizontalGraph(Graphics gc, int drawX, int drawY, int length) {
        gc.setForegroundColor(this.lineColor);
        if (this.graphPlus) {
            gc.drawLine(drawX, drawY, drawX + length, drawY);
        } else {
            gc.drawLine(drawX, drawY, drawX - length, drawY);
        }
        int duration = 1;
        if (!this.gridPlus) {
            duration = -1;
        }
        int current = drawX;
        if (this.graphPlus) {
            int index = 0;
            while (current < drawX + length) {
                gc.drawLine(current, drawY, current, drawY + duration * this.mainGridPixel);
                int subPer = (int)(this.perMain / (double)this.splitSub);
                int subSubPer = subPer / this.splitSubSub;
                int i = 0;
                while (i < this.splitSub) {
                    if (i != 0) {
                        gc.drawLine(current + subPer * i, drawY, current + subPer * i, drawY + duration * this.subGridPixel);
                    }
                    int j = 1;
                    while (j < this.splitSubSub) {
                        gc.drawLine(current + subPer * i + subSubPer * j, drawY, current + subPer * i + subSubPer * j, drawY + duration * this.subSubGridPixel);
                        ++j;
                    }
                    ++i;
                }
                String label = this.labelAt(index);
                this.drawLabelHorizontal(gc, current, drawY, label);
                current = (int)((double)current + this.perMain);
                ++index;
            }
        } else {
            int index = 0;
            while (current > drawX - length) {
                gc.drawLine(current, drawY, current, drawY + duration * this.mainGridPixel);
                int subPer = (int)(this.perMain / (double)this.splitSub);
                int subSubPer = subPer / this.splitSubSub;
                int i = 0;
                while (i < this.splitSub) {
                    if (i != 0) {
                        gc.drawLine(current - subPer * i, drawY, current - subPer * i, drawY + duration * this.subGridPixel);
                    }
                    int j = 1;
                    while (j < this.splitSubSub) {
                        gc.drawLine(current - subPer * i - subSubPer * j, drawY, current - subPer * i - subSubPer * j, drawY + duration * this.subSubGridPixel);
                        ++j;
                    }
                    ++i;
                }
                String label = this.labelAt(index);
                this.drawLabelHorizontal(gc, current, drawY, label);
                current = (int)((double)current - this.perMain);
                ++index;
            }
        }
    }

    public Point stringExtent(Graphics gc, String label) {
        int w = gc.getFontMetrics().getAverageCharWidth() * label.length();
        int h = gc.getFontMetrics().getHeight();
        return new Point(w, h);
    }

    private void drawLabelVertical(Graphics gc, int x, int y, String label) {
        if (label.length() > 0) {
            Point extent = this.stringExtent(gc, label);
            int half_height = extent.y / 2;
            if (this.gridPlus) {
                gc.drawString(label, x + this.mainGridPixel + this.marginGrid, y - half_height);
            } else {
                gc.drawString(label, x - this.mainGridPixel - this.marginGrid - extent.x, y - half_height);
            }
        }
    }

    private void drawLabelHorizontal(Graphics gc, int x, int y, String label) {
        if (label.length() > 0) {
            Point extent = this.stringExtent(gc, label);
            int half_width = extent.x / 2;
            if (this.gridPlus) {
                gc.drawString(label, x - half_width, y + this.mainGridPixel + this.marginGrid);
            } else {
                gc.drawString(label, x - half_width, y - this.mainGridPixel - this.marginGrid - extent.y);
            }
        }
    }

    private String labelAt(int index) {
        if (this.labelProvider != null) {
            return this.labelProvider.getLabel(this, index);
        }
        if (this.mainLabel != null && index < this.mainLabel.length) {
            return this.mainLabel[index];
        }
        return "";
    }

    public GraphLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(GraphLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

