/*
 * Created on 2005/05/23
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer;

import org.apache.commons.betwixt.io.BeanReader;
import org.apache.commons.io.IOUtils;
import org.jpn.xucker.rcp.subplayer.compatibility.Mark;
import org.jpn.xucker.rcp.subplayer.compatibility.SubPlayFileXmlObject;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;
import org.xml.sax.SAXException;

import java.beans.IntrospectionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * 
 *
 */
public class TimeBaseFileObjectReadUtils {
public static final int TIMEBASE_FILE_OBJECT=0;
public static final int SUBPLAY_FILE_OBJECT=1;
public static final int NONE=-1;

public static boolean isXMLFile(String path){
    return path.toLowerCase().endsWith(".xml");
}

public static boolean isMP3File(String path){
    return path.toLowerCase().endsWith(".mp3");
}

public static boolean isSRTFile(String path){
    return path.toLowerCase().endsWith(".srt");
}

public static String changeExtentionName(String name,String extension){
    int last=name.lastIndexOf(".");
    if(last!=-1){
        return name.substring(0,last)+"."+extension;
        
    }else{
        return null;
    }
}
public static boolean isWavFile(String path){
    return path.toLowerCase().endsWith(".wav");
}
public static TimeBaseFileObject read(File file){
    int type=checkType(file);
    
    if(type==SUBPLAY_FILE_OBJECT){
        BeanReader reader = new BeanReader();
        try {
            reader.registerBeanClass(SubPlayFileXmlObject.class);
            SubPlayFileXmlObject subPlayFileXmlObject = (SubPlayFileXmlObject) reader
            .parse(file);
            
            TimeBaseFileObject timeBaseFile=new TimeBaseFileObject();
            
            String path=subPlayFileXmlObject.getFirstSubFilePath();
            if(path!=null && path.length()>0){
                timeBaseFile.addParameter(new ParameterObject("file",path));
                
                Mark[] mark=subPlayFileXmlObject.getMarks();
                for(int i=0;i<mark.length;i++){
                    TimeParameterObject time=new TimeParameterObject();
                    time.setStartTime(mark[i].getStartTime());
                    time.setEndTime(mark[i].getEndTime());
                    time.setName("label1");//default is label1
                    time.setValue(path);
                }
                
            }
            path=subPlayFileXmlObject.getSecondSubFilePath();
            if(path!=null && path.length()>0){
                timeBaseFile.addParameter(new ParameterObject("file",path));    
            }
            
            path=subPlayFileXmlObject.getFirstWavFilePath();
            if(path!=null && path.length()>0){
                timeBaseFile.addParameter(new ParameterObject("file",path));    
            }
           
           
            return timeBaseFile;
        } catch (IntrospectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }else if(type==TIMEBASE_FILE_OBJECT){
        BeanReader reader = new BeanReader();
        try {
            reader.registerBeanClass(TimeBaseFileObject.class);
            TimeBaseFileObject timeFileXmlObject = (TimeBaseFileObject) reader
            .parse(file);
            return timeFileXmlObject;
        } catch (IntrospectionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
       
    }
    
    return null;
}

    public static int checkType(File file){
        StringBuffer str=new StringBuffer();
        try {
            BufferedReader reader=new BufferedReader(new FileReader(file));
          
            String line;
            while((line=reader.readLine())!=null){
                str.append(line);
                if(str.length()>100){
                    break;
                }
            }
            reader.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        if(str.indexOf("<SubPlayFileXmlObject")!=-1){
            return SUBPLAY_FILE_OBJECT;
        }
        else if(str.indexOf("<TimeBaseFileObject")!=-1){
           return TIMEBASE_FILE_OBJECT;
       }else{
           return NONE;
       }
    }
}
