/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String CF_RTF = "Rich Text Format";
    private static final int CF_RTFID = Transfer.registerType("Rich Text Format");
    private static int CodePage = COM.GetACP();

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = -2147467259;
        if (object == null || !(object instanceof String)) {
            return;
        }
        if (!this.isSupportedType(transferData)) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221399;
            return;
        }
        String string = (String)object;
        int count = string.length();
        if (count == 0) {
            return;
        }
        char[] chars = new char[count + 1];
        string.getChars(0, count, chars, 0);
        int cchMultiByte = COM.WideCharToMultiByte(CodePage, 0, chars, -1, null, 0, null, null);
        if (cchMultiByte == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int lpMultiByteStr = COM.GlobalAlloc(64, cchMultiByte);
        COM.WideCharToMultiByte(CodePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = lpMultiByteStr;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject data = new IDataObject(transferData.pIDataObject);
        data.AddRef();
        STGMEDIUM stgmedium = new STGMEDIUM();
        FORMATETC formatetc = transferData.formatetc;
        stgmedium.tymed = 1;
        transferData.result = data.GetData(formatetc, stgmedium);
        data.Release();
        if (transferData.result != 0) {
            return null;
        }
        int hMem = stgmedium.unionField;
        try {
            int cchWideChar;
            int lpMultiByteStr;
            block8: {
                Object var11_13;
                lpMultiByteStr = COM.GlobalLock(hMem);
                if (lpMultiByteStr == 0) {
                    Object var14_7 = null;
                    Object var12_8 = null;
                    COM.GlobalFree(hMem);
                    return var14_7;
                }
                try {
                    cchWideChar = COM.MultiByteToWideChar(CodePage, 1, lpMultiByteStr, -1, null, 0);
                    if (cchWideChar != 0) break block8;
                    var11_13 = null;
                    Object var9_15 = null;
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    COM.GlobalUnlock(hMem);
                    throw throwable;
                }
                COM.GlobalUnlock(hMem);
                Object var12_9 = null;
                COM.GlobalFree(hMem);
                return var11_13;
            }
            char[] lpWideCharStr = new char[cchWideChar - 1];
            COM.MultiByteToWideChar(CodePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
            String string = new String(lpWideCharStr);
            Object var9_16 = null;
            COM.GlobalUnlock(hMem);
            Object var12_10 = null;
            COM.GlobalFree(hMem);
            return string;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            COM.GlobalFree(hMem);
            throw throwable;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{CF_RTFID};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_RTF};
    }
}

