/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.read.BeanBindAction;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.xml.sax.Attributes;

public class ArrayBindAction
extends MappingAction.Base {
    private BeanMapping beanMapping = new BeanMapping();
    private Updater originalUpdater;

    public static final MappingAction createMappingAction(ElementDescriptor elementDescriptor) {
        MappingAction.Base result = new ArrayBindAction();
        if (elementDescriptor.getSingularPropertyType() != null && !elementDescriptor.getSingularPropertyType().isArray()) {
            result = BeanBindAction.INSTANCE;
        }
        return result;
    }

    public MappingAction begin(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
        context.pushBean(new ArrayList());
        return this;
    }

    public void end(ReadContext context) throws Exception {
        if (this.originalUpdater != null) {
            List values = (List)context.popBean();
            this.originalUpdater.update(context, values);
        }
    }

    public MappingAction next(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
        this.originalUpdater = context.getCurrentUpdater();
        BeanBindAction nextBindAction = BeanBindAction.INSTANCE;
        this.beanMapping.setDelegate(nextBindAction);
        return this.beanMapping;
    }

    private static class BeanMapping
    extends MappingAction.Base {
        private MappingAction delegate;

        BeanMapping() {
        }

        MappingAction getDelegate() {
            return this.delegate;
        }

        void setDelegate(MappingAction action) {
            this.delegate = action;
        }

        public MappingAction begin(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            context.pushUpdater(ListUpdater.INSTANCE);
            this.delegate = this.delegate.begin(namespace, name, attributes, context);
            return this;
        }

        public void body(String text, ReadContext context) throws Exception {
            this.delegate.body(text, context);
        }

        public void end(ReadContext context) throws Exception {
            this.delegate.end(context);
            Updater updater = context.popUpdater();
        }

        public MappingAction next(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
            return this.delegate.next(namespace, name, attributes, context);
        }
    }

    private static class ListUpdater
    implements Updater {
        private static final ListUpdater INSTANCE = new ListUpdater();

        private ListUpdater() {
        }

        public void update(Context context, Object newValue) {
            List values = (List)context.getBean();
            values.add(newValue);
        }
    }
}

