/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import java.beans.IntrospectionException;
import java.util.HashMap;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadConfiguration;
import org.apache.commons.betwixt.strategy.ActionMappingStrategy;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class ReadContext
extends Context {
    private HashMap beansById = new HashMap();
    private ClassLoader classLoader;
    private ReadConfiguration readConfiguration;
    private ArrayStack elementMappingStack = new ArrayStack();
    private ArrayStack actionMappingStack = new ArrayStack();
    private ArrayStack objectStack = new ArrayStack();
    private ArrayStack descriptorStack = new ArrayStack();
    private ArrayStack updaterStack = new ArrayStack();
    private Class rootClass;
    private XMLIntrospector xmlIntrospector;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$read$ReadContext;

    public ReadContext(Context context, ReadConfiguration readConfiguration) {
        super(context);
        this.readConfiguration = readConfiguration;
    }

    public ReadContext(BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
        this(LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$read$ReadContext == null ? (class$org$apache$commons$betwixt$io$read$ReadContext = ReadContext.class$("org.apache.commons.betwixt.io.read.ReadContext")) : class$org$apache$commons$betwixt$io$read$ReadContext)), bindingConfiguration, readConfiguration);
    }

    public ReadContext(Log log, BindingConfiguration bindingConfiguration, ReadConfiguration readConfiguration) {
        super(null, log, bindingConfiguration);
        this.readConfiguration = readConfiguration;
    }

    public ReadContext(ReadContext readContext) {
        super(readContext);
        this.beansById = readContext.beansById;
        this.classLoader = readContext.classLoader;
        this.readConfiguration = readContext.readConfiguration;
    }

    public void putBean(String id, Object bean) {
        this.beansById.put(id, bean);
    }

    public Object getBean(String id) {
        return this.beansById.get(id);
    }

    public void clearBeans() {
        this.beansById.clear();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BeanCreationChain getBeanCreationChain() {
        return this.readConfiguration.getBeanCreationChain();
    }

    public ActionMappingStrategy getActionMappingStrategy() {
        return this.readConfiguration.getActionMappingStrategy();
    }

    public String popElement() {
        if (!this.descriptorStack.isEmpty()) {
            this.descriptorStack.pop();
        }
        if (!this.updaterStack.isEmpty()) {
            this.updaterStack.pop();
        }
        Object top = null;
        if (!this.elementMappingStack.isEmpty() && (top = this.elementMappingStack.pop()) != null && !(top instanceof String)) {
            return this.popElement();
        }
        return (String)top;
    }

    public String getCurrentElement() {
        return (String)this.elementMappingStack.peek();
    }

    public Class getLastMappedClass() {
        Class lastMapped = null;
        int i = 0;
        int size = this.elementMappingStack.size();
        while (i < size) {
            Object entry = this.elementMappingStack.peek(i);
            if (entry instanceof Class) {
                lastMapped = (Class)entry;
                break;
            }
            ++i;
        }
        return lastMapped;
    }

    private ElementDescriptor getParentDescriptor() throws IntrospectionException {
        ElementDescriptor result = null;
        if (this.descriptorStack.size() > 1) {
            result = (ElementDescriptor)this.descriptorStack.peek(1);
        }
        return result;
    }

    public void pushElement(String elementName) throws Exception {
        this.elementMappingStack.push((Object)elementName);
        ElementDescriptor nextDescriptor = null;
        if (this.elementMappingStack.size() == 1 && this.rootClass != null) {
            this.markClassMap(this.rootClass);
            XMLBeanInfo rootClassInfo = this.getXMLIntrospector().introspect(this.rootClass);
            nextDescriptor = rootClassInfo.getElementDescriptor();
        } else {
            ElementDescriptor currentDescriptor = this.getCurrentDescriptor();
            if (currentDescriptor != null) {
                nextDescriptor = currentDescriptor.getElementDescriptor(elementName);
            }
        }
        Updater updater = null;
        if (nextDescriptor != null) {
            updater = nextDescriptor.getUpdater();
        }
        this.updaterStack.push((Object)updater);
        this.descriptorStack.push((Object)nextDescriptor);
    }

    public void markClassMap(Class mappedClazz) throws IntrospectionException {
        if (mappedClazz.isArray()) {
            mappedClazz = mappedClazz.getComponentType();
        }
        this.elementMappingStack.push(mappedClazz);
        XMLBeanInfo mappedClassInfo = this.getXMLIntrospector().introspect(mappedClazz);
        ElementDescriptor mappedElementDescriptor = mappedClassInfo.getElementDescriptor();
        this.descriptorStack.push((Object)mappedElementDescriptor);
        Updater updater = mappedElementDescriptor.getUpdater();
        this.updaterStack.push((Object)updater);
    }

    public MappingAction popMappingAction() {
        return (MappingAction)this.actionMappingStack.pop();
    }

    public void pushMappingAction(MappingAction mappingAction) {
        this.actionMappingStack.push((Object)mappingAction);
    }

    public MappingAction currentMappingAction() {
        if (this.actionMappingStack.size() == 0) {
            return null;
        }
        return (MappingAction)this.actionMappingStack.peek();
    }

    public Object getBean() {
        return this.objectStack.peek();
    }

    public void setBean(Object bean) {
    }

    public Object popBean() {
        return this.objectStack.pop();
    }

    public void pushBean(Object bean) {
        this.objectStack.push(bean);
    }

    public XMLIntrospector getXMLIntrospector() {
        if (this.xmlIntrospector == null) {
            this.xmlIntrospector = new XMLIntrospector();
        }
        return this.xmlIntrospector;
    }

    public void setXMLIntrospector(XMLIntrospector xmlIntrospector) {
        this.xmlIntrospector = xmlIntrospector;
    }

    public Class getRootClass() {
        return this.rootClass;
    }

    public void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public ElementDescriptor getCurrentDescriptor() throws Exception {
        ElementDescriptor result = null;
        if (!this.descriptorStack.empty()) {
            result = (ElementDescriptor)this.descriptorStack.peek();
        }
        return result;
    }

    public void populateAttributes(AttributeDescriptor[] attributeDescriptors, Attributes attributes) {
        Log log = this.getLog();
        if (attributeDescriptors != null) {
            int i = 0;
            int size = attributeDescriptors.length;
            while (i < size) {
                AttributeDescriptor attributeDescriptor = attributeDescriptors[i];
                String value = attributes.getValue(attributeDescriptor.getURI(), attributeDescriptor.getLocalName());
                if (value == null) {
                    value = attributes.getValue(attributeDescriptor.getQualifiedName());
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Attr URL:" + attributeDescriptor.getURI()));
                    log.trace((Object)("Attr LocalName:" + attributeDescriptor.getLocalName()));
                    log.trace((Object)value);
                }
                Updater updater = attributeDescriptor.getUpdater();
                log.trace((Object)updater);
                if (updater != null && value != null) {
                    updater.update(this, value);
                }
                ++i;
            }
        }
    }

    public void pushUpdater(Updater updater) {
        this.updaterStack.push((Object)updater);
    }

    public Updater popUpdater() {
        return (Updater)this.updaterStack.pop();
    }

    public Updater getCurrentUpdater() {
        Updater result = null;
        if (!this.updaterStack.empty() && (result = (Updater)this.updaterStack.peek()) == null && this.updaterStack.size() > 1) {
            result = (Updater)this.updaterStack.peek(1);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

