/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.schema.Attribute;
import org.apache.commons.betwixt.schema.ComplexLocalElement;
import org.apache.commons.betwixt.schema.ElementReference;
import org.apache.commons.betwixt.schema.LocalElement;
import org.apache.commons.betwixt.schema.Schema;
import org.apache.commons.betwixt.schema.SimpleLocalElement;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public abstract class ComplexType {
    protected List elements = new ArrayList();
    protected List attributes = new ArrayList();

    public ComplexType() {
    }

    public ComplexType(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        if (elementDescriptor.isHollow()) {
            Class type = elementDescriptor.getSingularPropertyType();
            if (type == null) {
                type = elementDescriptor.getPropertyType();
            }
            XMLBeanInfo filledBeanInfo = schema.introspect(type);
            elementDescriptor = filledBeanInfo.getElementDescriptor();
        }
        this.init(configuration, elementDescriptor, schema);
    }

    protected void init(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        AttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributeDescriptors();
        int i = 0;
        int length = attributeDescriptors.length;
        while (i < length) {
            String uri = attributeDescriptors[i].getURI();
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
                this.attributes.add(new Attribute(attributeDescriptors[i]));
            }
            ++i;
        }
        ElementDescriptor[] elementDescriptors = elementDescriptor.getElementDescriptors();
        int i2 = 0;
        int length2 = elementDescriptors.length;
        while (i2 < length2) {
            if (elementDescriptors[i2].isHollow()) {
                this.elements.add(new ElementReference(configuration, elementDescriptors[i2], schema));
            } else if (elementDescriptors[i2].isSimple()) {
                this.elements.add(new SimpleLocalElement(configuration, elementDescriptors[i2], schema));
            } else {
                this.elements.add(new ComplexLocalElement(configuration, elementDescriptors[i2], schema));
            }
            ++i2;
        }
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(ElementReference element) {
        this.elements.add(element);
    }

    public void addElement(LocalElement element) {
        this.elements.add(element);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }
}

