/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.BookmarkFilter;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogBookmarkFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Messages;

public class BookmarkView
extends MarkerView {
    private static final ColumnLayoutData[] DEFAULT_COLUMN_LAYOUTS = new ColumnLayoutData[]{new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private static final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.bookmark"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"message", "", "", ""};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.bookmark";
    private static final IField[] VISIBLE_FIELDS = new IField[]{new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            if (element instanceof ConcreteMarker && "message".equals(property)) {
                return ((ConcreteMarker)element).getDescription();
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            Item item;
            Object data;
            if (element instanceof Item && (data = (item = (Item)element).getData()) instanceof ConcreteMarker) {
                IMarker marker = ((ConcreteMarker)data).getMarker();
                try {
                    if (!marker.getAttribute(property).equals(value) && "message".equals(property)) {
                        marker.setAttribute("message", value);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)BookmarkView.this.getSite().getShell(), (String)Messages.getString("errorModifyingBookmark"), null, (IStatus)e.getStatus());
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;
    private BookmarkFilter bookmarkFilter = new BookmarkFilter();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TableViewer tableViewer = this.getViewer();
        CellEditor[] cellEditors = new CellEditor[tableViewer.getTable().getColumnCount()];
        TextCellEditor descriptionCellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        cellEditors[0] = descriptionCellEditor;
        tableViewer.setCellEditors(cellEditors);
        tableViewer.setCellModifier(this.cellModifier);
        tableViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)descriptionCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite viewSite, IMemento memento) throws PartInitException {
        super.init(viewSite, memento);
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.bookmarkFilter.restoreState(dialogSettings);
    }

    public void saveState(IMemento memento) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.bookmarkFilter.saveState(dialogSettings);
        super.saveState(memento);
    }

    protected ColumnLayoutData[] getDefaultColumnLayouts() {
        return DEFAULT_COLUMN_LAYOUTS;
    }

    protected IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected IField[] getHiddenFields() {
        return HIDDEN_FIELDS;
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected Object getViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IField[] getVisibleFields() {
        return VISIBLE_FIELDS;
    }

    public void setSelection(IStructuredSelection structuredSelection, boolean reveal) {
        super.setSelection(structuredSelection, reveal);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.bookmark"};
    }

    public void openFiltersDialog() {
        DialogBookmarkFilter dialog = new DialogBookmarkFilter(this.getSite().getShell(), this.bookmarkFilter);
        if (dialog.open() == 0) {
            this.bookmarkFilter = (BookmarkFilter)dialog.getFilter();
            this.bookmarkFilter.saveState(this.getDialogSettings());
            this.refresh();
        }
    }

    protected MarkerFilter getFilter() {
        return this.bookmarkFilter;
    }

    protected void updateFilterSelection(IResource[] resources) {
        this.bookmarkFilter.setFocusResource(resources);
    }
}

