/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.presentations.SystemMenuPinEditor;
import org.eclipse.ui.internal.presentations.SystemMenuSize;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.StackPresentation;

public class EditorStack
extends PartStack {
    private EditorSashContainer editorArea;
    private WorkbenchPage page;
    private SystemMenuSize sizeItem = new SystemMenuSize(null);
    private SystemMenuPinEditor pinEditorItem = new SystemMenuPinEditor(null);

    public EditorStack(EditorSashContainer editorArea, WorkbenchPage page) {
        super(1);
        this.editorArea = editorArea;
        this.setID(this.toString());
        this.page = page;
    }

    public void createControl(Composite parent, StackPresentation presentation) {
        super.createControl(parent, presentation);
        this.setSelection(this.getVisiblePart());
    }

    protected WorkbenchPage getPage() {
        return this.page;
    }

    public void addSystemActions(IMenuManager menuManager) {
        this.pinEditorItem = new SystemMenuPinEditor((EditorPane)this.getVisiblePart());
        PartStack.appendToGroupIfPossible(menuManager, "misc", (ContributionItem)new UpdatingActionContributionItem(this.pinEditorItem));
        this.sizeItem = new SystemMenuSize(this.getVisiblePart());
        PartStack.appendToGroupIfPossible(menuManager, "size", this.sizeItem);
    }

    public boolean isMoveable(IPresentablePart part) {
        return true;
    }

    public boolean isCloseable(IPresentablePart part) {
        return true;
    }

    public boolean supportsState(int state) {
        if (this.page.isFixedLayout()) {
            return false;
        }
        return state == 1 || state == 2;
    }

    public static EditorStack newEditorWorkbook(EditorSashContainer editorArea, WorkbenchPage page) {
        return new EditorStack(editorArea, page);
    }

    protected void add(LayoutPart newChild, Object cookie) {
        super.add(newChild, cookie);
        ((EditorPane)newChild).setWorkbook(this);
    }

    public void add(LayoutPart child) {
        super.add(child);
        if (child instanceof EditorPane) {
            ((EditorPane)child).setWorkbook(this);
        }
    }

    protected void updateActions() {
        EditorPane pane = (EditorPane)this.getVisiblePart();
        this.sizeItem.setPane(pane);
        this.pinEditorItem.setPane(pane);
    }

    public Control[] getTabList() {
        return this.getTabList(this.getVisiblePart());
    }

    public void removeAll() {
        LayoutPart[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            this.remove((EditorPane)children[i]);
            ++i;
        }
    }

    public boolean isActiveWorkbook() {
        EditorSashContainer area = this.getEditorArea();
        if (area != null) {
            return area.isActiveWorkbook(this);
        }
        return false;
    }

    public void becomeActiveWorkbook(boolean hasFocus) {
        EditorSashContainer area = this.getEditorArea();
        if (area != null) {
            area.setActiveWorkbook(this, hasFocus);
        }
    }

    public EditorPane[] getEditors() {
        LayoutPart[] children = this.getChildren();
        EditorPane[] panes = new EditorPane[children.length];
        int idx = 0;
        while (idx < children.length) {
            panes[idx] = (EditorPane)children[idx];
            ++idx;
        }
        return panes;
    }

    public EditorSashContainer getEditorArea() {
        return this.editorArea;
    }

    public EditorPane getVisibleEditor() {
        return (EditorPane)this.getVisiblePart();
    }

    public void setSelection(LayoutPart part) {
        IWorkbenchPart result;
        if (!this.isDisposed() && part instanceof PartPane && (result = ((PartPane)part).getPartReference().getPart(true)) == null) {
            part = null;
        }
        if (this.getVisiblePart() == part) {
            return;
        }
        super.setSelection(part);
    }

    public void setVisibleEditor(EditorPane editorPane) {
        this.setSelection(editorPane);
    }

    public void showVisibleEditor() {
    }

    protected boolean canMoveFolder() {
        return true;
    }

    protected void derefPart(LayoutPart toDeref) {
        EditorAreaHelper.derefPart(toDeref);
    }

    protected boolean allowsDrop(PartPane part) {
        return part instanceof EditorPane;
    }

    public void setFocus() {
        super.setFocus();
        this.becomeActiveWorkbook(true);
    }

    protected void close(IPresentablePart[] parts) {
        if (parts.length == 1) {
            this.close(parts[0]);
            return;
        }
        IEditorReference[] toClose = new IEditorReference[parts.length];
        int idx = 0;
        while (idx < parts.length) {
            EditorPane part = (EditorPane)this.getPaneFor(parts[idx]);
            toClose[idx] = part.getEditorReference();
            ++idx;
        }
        WorkbenchPage page = this.getPage();
        if (page != null) {
            page.closeEditors(toClose, true);
        }
    }

    public void testInvariants() {
        super.testInvariants();
        int active = this.getActive();
        if (active == 1) {
            Assert.isTrue((boolean)this.isActiveWorkbook());
        } else if (active == 2) {
            Assert.isTrue((boolean)this.isActiveWorkbook());
        } else if (active == 0) {
            Assert.isTrue((!this.isActiveWorkbook() ? 1 : 0) != 0);
        }
    }

    public IStatus restoreState(IMemento memento) {
        Integer expanded = memento.getInteger("expanded");
        this.setState(expanded == null || expanded != 0 ? 2 : 0);
        Integer appearance = memento.getInteger("appearance");
        if (appearance != null) {
            this.appearance = appearance;
        }
        this.savedPresentationState = null;
        IMemento[] presentationMementos = memento.getChildren("presentation");
        int idx = 0;
        while (idx < presentationMementos.length) {
            IMemento child = presentationMementos[idx];
            String id = child.getString("id");
            if (Util.equals(id, this.getFactory().getId())) {
                this.savedPresentationState = child;
                break;
            }
            ++idx;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        memento.putInteger("expanded", this.getPresentationSite().getState() == 0 ? 0 : 2);
        memento.putInteger("appearance", this.appearance);
        this.savePresentationState();
        if (this.savedPresentationState != null) {
            IMemento presentationState = memento.createChild("presentation");
            presentationState.putMemento(this.savedPresentationState);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }
}

