/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;
import org.eclipse.core.internal.dependencies.ISelectionPolicy;

public class SelectionVisitor
implements IElementSetVisitor {
    private int order;
    private ISelectionPolicy selectionPolicy;

    public SelectionVisitor(int order, ISelectionPolicy selectionPolicy) {
        this.order = order;
        this.selectionPolicy = selectionPolicy;
    }

    public final Collection getAncestors(ElementSet elementSet) {
        return elementSet.getRequiring();
    }

    public final Collection getDescendants(ElementSet elementSet) {
        return elementSet.getRequired();
    }

    public int getOrder() {
        return this.order;
    }

    public void update(ElementSet elementSet) {
        if (elementSet.getSatisfied().isEmpty()) {
            elementSet.setSelected(Collections.EMPTY_SET);
            return;
        }
        if (elementSet.allowsConcurrency()) {
            elementSet.setSelected(this.selectionPolicy.selectMultiple(elementSet));
            return;
        }
        Element selected = this.selectionPolicy.selectSingle(elementSet);
        elementSet.setSelected(selected == null ? Collections.EMPTY_SET : Collections.singleton(selected));
    }
}

