/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.Hashtable;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SystemBundle
extends BundleHost {
    protected SystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        this.state = 8;
        this.context = this.createContext();
    }

    public BundleLoader getBundleLoader() {
        if (this.loader == null) {
            SystemBundle systemBundle = this;
            synchronized (systemBundle) {
                if (this.loader == null) {
                    try {
                        this.loader = new SystemBundleLoader(this, this.getBundleDescription());
                    }
                    catch (BundleException e) {
                        this.framework.publishFrameworkEvent(2, this, e);
                        return null;
                    }
                }
            }
        }
        return this.loader;
    }

    protected void load() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.domain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(AbstractBundle newBundle) throws BundleException {
        return false;
    }

    protected void refresh() throws BundleException {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
        this.state = 1;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission();
            this.checkValid();
        }
        return Class.forName(name);
    }

    public URL getResource(String name) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() throws BundleException {
        this.framework.checkAdminPermission();
    }

    protected void resume() throws BundleException {
        this.framework.startLevelManager.initialize();
        this.framework.startLevelManager.launch(this.framework.startLevelManager.getFrameworkStartLevel());
    }

    public void stop() throws BundleException {
        this.framework.checkAdminPermission();
        if (this.state == 32) {
            Thread shutdown = SecureAction.createThread(new Runnable(){

                public void run() {
                    try {
                        SystemBundle.this.framework.shutdown();
                    }
                    catch (Throwable t) {
                        SystemBundle.this.framework.adaptor.handleRuntimeError(t);
                    }
                }
            }, "System Bundle Shutdown");
            shutdown.start();
        }
    }

    protected void suspend() throws BundleException {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
    }

    public void update() throws BundleException {
        this.framework.checkAdminPermission();
        if (this.state == 32) {
            Thread restart = SecureAction.createThread(new Runnable(){

                public void run() {
                    SystemBundle.this.framework.shutdown();
                    SystemBundle.this.framework.launch();
                }
            }, "System Bundle Update");
            restart.start();
        }
    }

    public void update(InputStream in) throws BundleException {
        this.update();
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission();
        throw new BundleException(Msg.formatter.getString("BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION"));
    }

    public boolean hasPermission(Object permission) {
        if (this.domain != null) {
            if (permission instanceof Permission) {
                return this.domain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(Hashtable unresolvedPackages) {
    }

    public Bundle[] getFragments() {
        return null;
    }

    protected boolean checkExportPackagePermission(String pkgName) {
        return true;
    }

    protected boolean checkFragmentBundlePermission(String symbolicName) {
        return true;
    }

    protected boolean checkFragmentHostPermission(String symbolicName) {
        return true;
    }

    protected boolean checkImportPackagePermission(String pkgName) {
        return true;
    }

    protected boolean checkPermissions() {
        return true;
    }

    protected boolean checkProvideBundlePermission(String symbolicName) {
        return true;
    }

    protected boolean checkRequireBundlePermission(String symbolicName) {
        return true;
    }
}

