/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.R21BasicStackPresentation;
import org.eclipse.ui.internal.presentations.r21.R21PresentationMessages;
import org.eclipse.ui.internal.presentations.r21.widgets.CTabFolderEvent;
import org.eclipse.ui.internal.presentations.r21.widgets.R21PaneFolder;
import org.eclipse.ui.internal.presentations.r21.widgets.R21PaneFolderButtonListener;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class R21ViewStackPresentation
extends R21BasicStackPresentation {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("VIEW_TAB_POSITION".equals(propertyChangeEvent.getProperty()) && !R21ViewStackPresentation.this.isDisposed()) {
                int tabLocation = R21ViewStackPresentation.this.preferenceStore.getInt("VIEW_TAB_POSITION");
                R21ViewStackPresentation.this.getPaneFolder().setTabPosition(tabLocation);
            }
        }
    };
    private R21PaneFolderButtonListener showListListener = new R21PaneFolderButtonListener(){

        public void showList(CTabFolderEvent event) {
            event.doit = false;
            R21ViewStackPresentation.this.showListDefaultLocation();
        }
    };

    public R21ViewStackPresentation(Composite parent, IStackPresentationSite newSite) {
        super(new R21PaneFolder(parent, 2048), newSite);
        R21PaneFolder tabFolder = this.getPaneFolder();
        tabFolder.addButtonListener(this.showListListener);
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        int tabLocation = this.preferenceStore.getInt("VIEW_TAB_POSITION");
        tabFolder.setTabPosition(tabLocation);
        this.updateGradient();
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        this.updateGradient();
    }

    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        super.dispose();
    }

    protected String getPaneName() {
        return R21PresentationMessages.getString("ViewPane.moveView");
    }
}

