/*
 * Created on 2005/06/12
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.subplayer.views.SubView;
import org.jpn.xucker.rcp.ui.PathListTable;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;

import java.io.File;

/**
 * 
 *
 */
public class TimeBaseFileWindow implements SelectionListener {
    public static Log log=LogFactory.getLog(TimeBaseFileWindow.class);
    TimeBaseFileUpdater updater;
    Shell shell;
    
    private Button okButton;
    private Button cancelButton;
    TimeBaseFileObject oldValue;
    
    private List oldUnknownParams=new ArrayList();
    private PathListTable audioList;
    private PathListTable subList;
    public TimeBaseFileWindow(File file,TimeBaseFileObject oldValue,TimeBaseFileUpdater updater,Shell shell){
        log.info("timebasefilewindows");
        this.updater=updater;
        this.shell=shell;
        this.oldValue=oldValue;
        if(file!=null){
        shell.setText("File "+file.getName());
        }else{
            shell.setText("File UNKNOWN");
        }
        
        shell.setLayout(new GridLayout());
        Label fileLabel=new Label(shell,SWT.NULL);
        fileLabel.setText("FileName");
        
        Text text=new Text(shell,SWT.SINGLE|SWT.READ_ONLY);
        if(file!=null){
            text.setText(file.getAbsolutePath());
            }
        
        
        Label audioLabel=new Label(shell,SWT.NULL);
        audioLabel.setText("Audios");
        audioList = new PathListTable(shell,SWT.NULL);
        audioList.setLayoutData(new GridData(GridData.FILL_BOTH));
        audioList.setFileExtension(new String[]{"mp3","wav"});//audio
        
        Label subLabel=new Label(shell,SWT.NULL);
        subLabel.setText("Subtitles");
        subList = new PathListTable(shell,SWT.NULL);
        subList.setLayoutData(new GridData(GridData.FILL_BOTH));
        subList.setFileExtension(new String[]{"srt"});//TODO support other format
        
        Composite cp=new Composite(shell,SWT.NULL);
        cp.setLayout(new RowLayout());
//      OK
        okButton = new Button(cp, SWT.NULL);
        okButton.setText("OK");
        okButton.addSelectionListener(this);
        RowData okButton_data = new RowData();
        okButton.setLayoutData(okButton_data);
        
        

        
        //LZ
        cancelButton = new Button(cp, SWT.NULL);
        cancelButton.setText("cancel");
        cancelButton.addSelectionListener(this);
        RowData cancelButton_data = new RowData();
        cancelButton.setLayoutData(cancelButton_data);
        
        
        
        ParameterObject params[]=oldValue.getParameters();
	    int index=0;
	    for(int i=0;i<params.length;i++){
	        if(params[i].getName().equals("file")){
	            if(TimeBaseFileObjectReadUtils.isSRTFile(params[i].getValue())){
	                subList.addFileItem(params[i].getValue());
	            }
	            else if(TimeBaseFileObjectReadUtils.isAudioFile(params[i].getValue())){
	                audioList.addFileItem(params[i].getValue());
	            }else{
	                oldUnknownParams.add(params[i]);
	            }
	        }
	    }
    }
    public void widgetSelected(SelectionEvent event) {
        Object target = event.getSource();
        if (target == null) {
            //
            System.out.println("target==null");
        }
        
        
        //OK
        else if (target == okButton) {
            do_okButton();
        }
        //LZ
        else if (target == cancelButton) {
            do_cancelButton();
        }

    }

    

    public void widgetDefaultSelected(SelectionEvent arg0) {
       
    }
    
    
    //OK
    public void do_okButton() {
        shell.close();
        
        TimeBaseFileObject newTime=new TimeBaseFileObject();
        TimeParameterObject times[]=oldValue.getTimeParameters();
        
        String[] audios=audioList.getFiles();
        for (int i = 0; i < audios.length; i++) {
            newTime.addParameter(new ParameterObject("file",audios[i]));
        }
        
        String[] subs=subList.getFiles();
        for (int i = 0; i < subs.length; i++) {
            newTime.addParameter(new ParameterObject("file",subs[i]));
        }
        
        for (int i = 0; i < times.length; i++) {
            newTime.addTimeParameter(times[i]);
        }
        
        for(int i=0;i<oldUnknownParams.size();i++){
            newTime.addParameter((ParameterObject)oldUnknownParams.get(i));
        }
        
        updater.update(oldValue,newTime);
    }

    //LZ
    public void do_cancelButton() {
        shell.close();
    }
}
