/*
 * Created on 2005/01/24
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer.compatibility;

import org.jpn.xucker.subtitle.StandardSubObject;

/**
 * 
 *
 */
public class Mark implements Comparable{
    public long startTime;
    public long endTime;
    public Mark(){
        
    }
    public Mark(long start,long end){
        this.startTime=start;
        this.endTime=end;
    }
    public String toString(){
        return startTime+","+endTime;
    }
    public int hashCode(){
        return (""+startTime+","+endTime).hashCode();
    }
    public boolean equals(Object o){
        if(o instanceof Mark){
            Mark m=(Mark)o;
            return m.getStartTime()==this.getStartTime() && m.getEndTime()==this.getEndTime();
        }else{
            return false;
        }
    }
    public Mark(StandardSubObject sub){
        this(sub.getStartTime(),sub.getEndTime());
    }
    public long getEndTime() {
        return endTime;
    }
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
    public long getStartTime() {
        return startTime;
    }
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
    public boolean isMutch(StandardSubObject sub){
       return sub.getStartTime()==startTime && sub.getEndTime()==endTime;
    }
    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(Object o) {
        if(o instanceof Mark){
            Mark m=(Mark)o;
            if(m.getStartTime()==this.getStartTime()){
                if(m.getEndTime()>this.getEndTime()){
                    return -1;
                }else{
                    return 1;
                }
            }else{
                if(m.getStartTime()>this.getStartTime()){
                    return -1;
                }else{
                    return 1;
                }
            }
        }
        return 0;
    }
}
