/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.mp3.MP3Utils;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class JavaLayerMP3Player
extends JavaSoundAudioPlayer {
    public static Log log;
    private MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
    private AdvancedPlayer advancedPlayer;
    private StopMonitor stopMonitor = new StopMonitor();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.mp3.JavaLayerMP3Player");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void play(InputStream stream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.play(stream, 0L, 0L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play(File file, long startmillisecond, long endmillisecond) {
        this.stopMonitor = new StopMonitor();
        this.stopMonitor.start();
        try {
            boolean isLimit = true;
            if (endmillisecond == 0L) {
                isLimit = false;
            }
            Object audioInputStream = null;
            AudioInputStream in = this.mpegAudioFileReader.getAudioInputStream((InputStream)new FileInputStream(file));
            AudioFormat baseFormat = in.getFormat();
            AudioFileFormat baseFileFormat = this.mpegAudioFileReader.getAudioFileFormat((InputStream)in);
            long skipbyte = 0L;
            double fps = 0.0;
            int bps = 0;
            String mpeg_version = null;
            double frequency = 0.0;
            if (baseFileFormat instanceof MpegAudioFileFormat) {
                Map props = ((TAudioFileFormat)baseFileFormat).properties();
                Object[] obj = props.keySet().toArray();
                int i = 0;
                while (true) {
                    if (i >= obj.length) {
                        bps = Integer.parseInt(props.get("mp3.bitrate.nominal.bps").toString());
                        fps = Double.parseDouble(props.get("mp3.framerate.fps").toString());
                        skipbyte = startmillisecond / 1000L * (long)(bps / 8);
                        frequency = Double.parseDouble(props.get("mp3.frequency.hz").toString());
                        mpeg_version = props.get("mp3.version.mpeg").toString();
                        break;
                    }
                    log.trace((Object)(obj[i] + "=" + props.get(obj[i]).toString()));
                    ++i;
                }
            }
            in.close();
            try {
                try {
                    int skip1 = (int)(fps * (double)startmillisecond / 1000.0);
                    int skip2 = (int)(fps * (double)endmillisecond / 1000.0);
                    long skipID3v2 = MP3Utils.findFirstFrameAt(file);
                    log.trace((Object)("id3 " + skipID3v2));
                    FileInputStream fi = new FileInputStream(file);
                    fi.skip(skipID3v2);
                    fi.skip((long)(bps / 8) * startmillisecond / 1000L);
                    this.advancedPlayer = new AdvancedPlayer((InputStream)fi);
                    this.advancedPlayer.setPlayBackListener((PlaybackListener)new DummyPlayBackListener());
                    int frames = 0;
                    frames = "2.5".equals(mpeg_version) ? (int)((double)(endmillisecond - startmillisecond) * fps / 2.0 / 1000.0) : (int)((double)(endmillisecond - startmillisecond) * fps / 1000.0);
                    log.trace((Object)("play frame:" + frames));
                    boolean allplay = this.advancedPlayer.play(frames);
                    log.trace((Object)"play end");
                    fi.close();
                    if (this.audioListener != null && allplay) {
                        this.audioListener.finishPlaying();
                    }
                }
                catch (JavaLayerException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var26_26 = null;
                log.debug((Object)"stopped");
                this.stopper.setStopped(true);
                throw throwable;
            }
            {
                Object var26_27 = null;
                log.debug((Object)"stopped");
                this.stopper.setStopped(true);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class DummyPlayBackListener
    extends PlaybackListener {
        public void playbackStarted(PlaybackEvent evt) {
            if (JavaLayerMP3Player.this.audioListener != null) {
                JavaLayerMP3Player.this.audioListener.startPlaying();
            }
        }

        public void playbackFinished(PlaybackEvent evt) {
            if (JavaLayerMP3Player.this.audioListener != null) {
                JavaLayerMP3Player.this.audioListener.stopPlaying();
            }
        }
    }

    public class StopMonitor
    extends Thread {
        public void run() {
            log.debug((Object)"start stopmonitor");
            while (!JavaLayerMP3Player.this.stopper.isStopped()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (JavaLayerMP3Player.this.advancedPlayer != null) {
                log.debug((Object)"call advancedPlayer stopped");
                try {
                    JavaLayerMP3Player.this.advancedPlayer.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

