/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ICapabilityInstallWizard;
import org.eclipse.ui.ICapabilityUninstallWizard;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistryReader;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Capability
extends WorkbenchAdapter
implements IAdaptable {
    private static final String ATT_ID = "id";
    private static final String ATT_ICON = "icon";
    private static final String ATT_NATURE_ID = "natureId";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_INSTALL_WIZARD = "installWizard";
    private static final String ATT_INSTALL_DETAILS = "installDetails";
    private static final String ATT_UNINSTALL_WIZARD = "uninstallWizard";
    private static final String ATT_UNINSTALL_DETAILS = "uninstallDetails";
    private String id;
    private String natureId;
    private IProjectNatureDescriptor natureDescriptor;
    private ImageDescriptor icon;
    private IConfigurationElement element;
    private ArrayList handleUIs;
    private ArrayList perspectiveChoices;
    static /* synthetic */ Class class$0;

    public Capability(IConfigurationElement configElement, CapabilityRegistryReader reader) throws WorkbenchException {
        boolean missingAttribute = false;
        String attr_id = configElement.getAttribute(ATT_ID);
        String attr_nature = configElement.getAttribute(ATT_NATURE_ID);
        if (attr_id == null) {
            reader.logMissingAttribute(configElement, ATT_ID);
            missingAttribute = true;
        }
        if (attr_nature == null) {
            reader.logMissingAttribute(configElement, ATT_NATURE_ID);
            missingAttribute = true;
        }
        if (configElement.getAttribute(ATT_INSTALL_WIZARD) == null) {
            reader.logMissingAttribute(configElement, ATT_INSTALL_WIZARD);
            missingAttribute = true;
        }
        if (missingAttribute) {
            throw new WorkbenchException("Capability missing required attributes.");
        }
        this.id = attr_id;
        this.natureId = attr_nature;
        this.element = configElement;
        this.natureDescriptor = ResourcesPlugin.getWorkspace().getNatureDescriptor(this.natureId);
    }

    public Capability(String natureId) {
        this.id = natureId;
        this.natureId = natureId;
    }

    public void addHandleUI(String capabilityId) {
        if (this.handleUIs == null) {
            this.handleUIs = new ArrayList(4);
        }
        this.handleUIs.add(capabilityId);
    }

    public void addPerspectiveChoice(String perspId) {
        if (this.perspectiveChoices == null) {
            this.perspectiveChoices = new ArrayList(4);
        }
        this.perspectiveChoices.add(perspId);
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getIconDescriptor();
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public String getName() {
        if (this.isValid()) {
            return this.natureDescriptor.getLabel();
        }
        return IDEWorkbenchMessages.format("Capability.nameMissing", new Object[]{this.id});
    }

    public ImageDescriptor getIconDescriptor() {
        if (this.icon == null && this.isValid()) {
            IExtension extension = this.element.getDeclaringExtension();
            String extendingPluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
            String location = this.element.getAttribute(ATT_ICON);
            if (location != null && location.length() > 0) {
                this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)location);
            }
        }
        return this.icon;
    }

    public IProjectNatureDescriptor getNatureDescriptor() {
        return this.natureDescriptor;
    }

    public String getNatureId() {
        return this.natureId;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public String getCategoryPath() {
        if (this.element == null) {
            return "";
        }
        return this.element.getAttribute(ATT_CATEGORY);
    }

    public ICapabilityInstallWizard getInstallWizard() {
        if (!this.isValid()) {
            return null;
        }
        try {
            return (ICapabilityInstallWizard)this.element.createExecutableExtension(ATT_INSTALL_WIZARD);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Could not create capability install wizard.", e.getStatus());
            return null;
        }
    }

    public String getInstallDetails() {
        if (!this.isValid()) {
            return null;
        }
        return this.element.getAttribute(ATT_INSTALL_DETAILS);
    }

    public ICapabilityUninstallWizard getUninstallWizard() {
        if (!this.isValid()) {
            return null;
        }
        try {
            return (ICapabilityUninstallWizard)this.element.createExecutableExtension(ATT_UNINSTALL_WIZARD);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Could not create capability uninstall wizard.", e.getStatus());
            return null;
        }
    }

    public String getUninstallDetails() {
        if (!this.isValid()) {
            return null;
        }
        return this.element.getAttribute(ATT_UNINSTALL_DETAILS);
    }

    public String getDescription() {
        if (!this.isValid()) {
            return "";
        }
        String description = this.element.getAttribute(ATT_DESCRIPTION);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public ArrayList getHandleUIs() {
        return this.handleUIs;
    }

    public ArrayList getPerspectiveChoices() {
        return this.perspectiveChoices;
    }

    public boolean isValid() {
        return this.natureDescriptor != null;
    }
}

