/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;

public class FeatureHierarchyElement {
    private Object root;
    private ArrayList children;
    private IFeatureReference oldFeatureRef;
    private IFeatureReference newFeatureRef;
    private boolean checked;
    private boolean optionalChildren;
    private boolean nativeUpgrade = false;

    public FeatureHierarchyElement(IFeatureReference oldRef, IFeatureReference newRef) {
        this.oldFeatureRef = oldRef;
        this.newFeatureRef = newRef;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isEditable() {
        if (!this.isOptional()) {
            return false;
        }
        return this.oldFeatureRef == null;
    }

    public boolean isFalseUpdate() {
        if (this.oldFeatureRef != null && this.newFeatureRef != null) {
            try {
                return this.oldFeatureRef.getVersionedIdentifier().equals(this.newFeatureRef.getVersionedIdentifier());
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public boolean isOptional() {
        return this.newFeatureRef instanceof IIncludedFeatureReference && ((IIncludedFeatureReference)this.newFeatureRef).isOptional();
    }

    public boolean isChecked() {
        return this.checked;
    }

    void setNativeUpgrade(boolean nativeUpgrade) {
        this.nativeUpgrade = nativeUpgrade;
    }

    public boolean isEnabled(IInstallConfiguration config) {
        if (this.nativeUpgrade) {
            return true;
        }
        if (this.isOptional() && this.oldFeatureRef != null) {
            try {
                IFeature oldFeature = this.oldFeatureRef.getFeature(null);
                IConfiguredSite csite = UpdateUtils.getConfigSite(oldFeature, config);
                return csite.isConfigured(oldFeature);
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    public IFeature getFeature() {
        try {
            IFeature feature = this.newFeatureRef.getFeature(null);
            return feature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getLabel() {
        try {
            return this.getFeatureLabel(this.newFeatureRef);
        }
        catch (CoreException coreException) {
            String iname;
            if (this.newFeatureRef instanceof IIncludedFeatureReference && (iname = ((IIncludedFeatureReference)this.newFeatureRef).getName()) != null) {
                return iname;
            }
            try {
                VersionedIdentifier vid = this.newFeatureRef.getVersionedIdentifier();
                return vid.toString();
            }
            catch (CoreException coreException2) {
                return null;
            }
        }
    }

    private String getFeatureLabel(IFeatureReference featureRef) throws CoreException {
        IFeature feature = featureRef.getFeature(null);
        return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
    }

    public FeatureHierarchyElement[] getChildren(boolean update, boolean patch, IInstallConfiguration config) {
        this.computeChildren(update, patch, config);
        FeatureHierarchyElement[] array = new FeatureHierarchyElement[this.children.size()];
        this.children.toArray(array);
        return array;
    }

    public FeatureHierarchyElement[] getChildren() {
        if (this.children != null) {
            FeatureHierarchyElement[] array = new FeatureHierarchyElement[this.children.size()];
            this.children.toArray(array);
            return array;
        }
        return new FeatureHierarchyElement[0];
    }

    public void computeChildren(boolean update, boolean patch, IInstallConfiguration config) {
        if (this.children == null) {
            this.children = new ArrayList();
            try {
                IFeature oldFeature = null;
                IFeature newFeature = null;
                newFeature = this.newFeatureRef.getFeature(null);
                if (this.oldFeatureRef != null) {
                    oldFeature = this.oldFeatureRef.getFeature(null);
                }
                this.optionalChildren = FeatureHierarchyElement.computeElements(oldFeature, newFeature, update, patch, config, this.children);
                int i = 0;
                while (i < this.children.size()) {
                    FeatureHierarchyElement element = (FeatureHierarchyElement)this.children.get(i);
                    element.setRoot(this.getRoot());
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean hasOptionalChildren() {
        return this.optionalChildren;
    }

    public void addCheckedOptionalFeatures(boolean update, boolean patch, IInstallConfiguration config, Set set) {
        if (this.isOptional() && this.isChecked() && (!update || !this.isFalseUpdate())) {
            set.add(this.newFeatureRef);
        }
        FeatureHierarchyElement[] elements = this.getChildren(update, patch, config);
        int i = 0;
        while (i < elements.length) {
            elements[i].addCheckedOptionalFeatures(update, patch, config, set);
            ++i;
        }
    }

    public static boolean computeElements(IFeature oldFeature, IFeature newFeature, boolean update, boolean patch, IInstallConfiguration config, ArrayList list) {
        Object[] oldChildren = null;
        Object[] newChildren = FeatureHierarchyElement.getIncludedFeatures(newFeature);
        boolean optionalChildren = false;
        try {
            if (oldFeature != null) {
                oldChildren = FeatureHierarchyElement.getIncludedFeatures(oldFeature);
            }
            int i = 0;
            while (i < newChildren.length) {
                FeatureHierarchyElement element;
                IFeatureReference oldRef = null;
                IFeatureReference newRef = (IFeatureReference)newChildren[i];
                if (oldChildren != null) {
                    String newId = newRef.getVersionedIdentifier().getIdentifier();
                    int j = 0;
                    while (j < oldChildren.length) {
                        block18: {
                            IFeatureReference cref = (IFeatureReference)oldChildren[j];
                            try {
                                if (!cref.getVersionedIdentifier().getIdentifier().equals(newId)) break block18;
                                oldRef = cref;
                                break;
                            }
                            catch (CoreException coreException) {}
                        }
                        ++j;
                    }
                } else if (patch && !UpdateUtils.isPatch(newFeature)) {
                    oldRef = FeatureHierarchyElement.findPatchedReference(newRef, config);
                }
                if (oldRef != null && (oldRef instanceof IIncludedFeatureReference && ((IIncludedFeatureReference)oldRef).isOptional() || patch)) {
                    try {
                        IFeature f = oldRef.getFeature(null);
                        if (f == null) {
                            oldRef = null;
                        }
                    }
                    catch (CoreException coreException) {
                        oldRef = null;
                    }
                }
                if ((element = new FeatureHierarchyElement(oldRef, newRef)).isOptional() && (update || patch)) {
                    element.setChecked(oldRef != null);
                    if (oldRef == null && FeatureHierarchyElement.hasOlderVersion(newRef)) {
                        element.setNativeUpgrade(true);
                        element.setChecked(true);
                    }
                } else {
                    element.setChecked(true);
                }
                list.add(element);
                element.computeChildren(update, patch, config);
                if (element.isOptional() || element.hasOptionalChildren()) {
                    optionalChildren = true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return optionalChildren;
    }

    public static boolean hasOlderVersion(IFeatureReference newRef) {
        try {
            VersionedIdentifier vid = newRef.getVersionedIdentifier();
            PluginVersionIdentifier version = vid.getVersion();
            String mode = FeatureHierarchyElement.getUpdateVersionsMode();
            IFeature[] allInstalled = UpdateUtils.getInstalledFeatures(vid, false);
            int i = 0;
            while (i < allInstalled.length) {
                IFeature candidate = allInstalled[i];
                PluginVersionIdentifier cversion = candidate.getVersionedIdentifier().getVersion();
                if (mode.equals("equivalent") ? version.isEquivalentTo(cversion) : mode.equals("compatible") && version.isCompatibleWith(cversion)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static IFeatureReference findPatchedReference(IFeatureReference newRef, IInstallConfiguration config) throws CoreException {
        VersionedIdentifier vid = newRef.getVersionedIdentifier();
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] refs = csite.getConfiguredFeatures();
            int j = 0;
            while (j < refs.length) {
                IFeatureReference ref = refs[j];
                VersionedIdentifier refVid = ref.getVersionedIdentifier();
                if (vid.getIdentifier().equals(refVid.getIdentifier())) {
                    return ref;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static Object[] getIncludedFeatures(IFeatureReference ref) {
        try {
            IFeature feature = ref.getFeature(null);
            return FeatureHierarchyElement.getIncludedFeatures(feature);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public static Object[] getIncludedFeatures(IFeature feature) {
        try {
            return feature.getIncludedFeatureReferences();
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    private static String getUpdateVersionsMode() {
        Preferences store = UpdateCore.getPlugin().getPluginPreferences();
        return store.getString("org.eclipse.update.core.updateVersions");
    }
}

