/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.subtitle.StandardSubObject;

public class MultiTimeAudioPlayer {
    private JavaLayerMP3Player mp3Player = new JavaLayerMP3Player();
    public static Log log;
    private StandardSubObject[] timeDatas = new StandardSubObject[0];
    private int index;
    private int extendTime;
    private int waitTime;
    private File audioFile;
    private AudioFormat audioFormat;
    private boolean repeat;
    private MultiTimeAudioListener multiTimeAudioListener;
    public int[] playPattern;
    long lastEnd = 0L;
    boolean inLooped;
    private boolean stopped = true;
    private AudioListener audioListener;
    private DataLine.Info info;
    private SourceDataLine line;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.subplayer.MultiTimeAudioPlayer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void removeAll() {
        this.timeDatas = new StandardSubObject[0];
        this.index = 0;
    }

    public void addData(StandardSubObject subs) {
        this.timeDatas = (StandardSubObject[])ArrayUtils.add((Object[])this.timeDatas, (Object)subs);
    }

    public void play() {
        this.stopped = false;
        this.mp3Player.setStopper((AudioStopper)new MP3Stopper());
        log.info((Object)("play:subtitles=" + this.timeDatas.length));
        if (this.audioFile == null) {
            log.trace((Object)"audioFile=null");
            return;
        }
        int subIndex = this.index;
        if (this.multiTimeAudioListener != null) {
            this.multiTimeAudioListener.startPlaying();
        }
        this.open();
        while (!this.stopped) {
            this.inLooped = false;
            int j = 0;
            while (j < this.playPattern.length || this.playPattern[0] == 2) {
                if (this.playPattern[0] == 2 || this.playPattern[j] == 0) {
                    this.play(this.timeDatas[subIndex]);
                } else {
                    int time = (int)(this.timeDatas[subIndex].getEndTime() - this.timeDatas[subIndex].getStartTime());
                    log.trace((Object)("mute:" + time));
                    if (this.multiTimeAudioListener != null) {
                        this.multiTimeAudioListener.play(this.timeDatas[subIndex], this.timeDatas[subIndex].getStartTime(), this.timeDatas[subIndex].getEndTime());
                    }
                    this.sleep(time);
                }
                this.inLooped = true;
                if (this.stopped) break;
                if (j != this.playPattern.length - 1) {
                    this.sleep(this.waitTime);
                }
                ++j;
            }
            if (++subIndex >= this.timeDatas.length) {
                if (!this.repeat) break;
                subIndex = 0;
                this.lastEnd = 0L;
                this.sleep(this.waitTime);
                continue;
            }
            this.sleep(this.waitTime);
        }
        if (this.multiTimeAudioListener != null) {
            this.multiTimeAudioListener.finishPlaying();
        }
        this.close();
        this.stopped = true;
    }

    private void sleep(int time) {
        if (this.stopped) {
            return;
        }
        log.trace((Object)("sleep:" + time));
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void play(StandardSubObject sub) {
        long end;
        long start = sub.getStartTime() - (long)this.extendTime;
        if (!this.inLooped) {
            start = Math.max(start, this.lastEnd);
        }
        this.lastEnd = end = sub.getEndTime() + (long)this.extendTime;
        if (this.multiTimeAudioListener != null) {
            this.multiTimeAudioListener.play(sub, start, end);
        }
        this.playFile(this.audioFile, start, end);
    }

    public AudioInputStream toAudioInputStream() {
        block8: {
            if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                try {
                    return MP3Utils.toPCMAudioInputStream((InputStream)new FileInputStream(this.audioFile));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block8;
                }
            }
            try {
                return AudioSystem.getAudioInputStream(this.audioFile);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void playFile(File file, long start, long end) {
        if (TimeBaseFileObjectReadUtils.isMP3File(file.getName())) {
            log.info((Object)("mp3-play:" + start + "," + end));
            this.mp3Player.play(file, start, end);
        } else {
            try {
                this.playByte(this.toAudioInputStream(), WaveUtils.millisecondToSample((long)start, (float)this.audioFormat.getSampleRate()), WaveUtils.millisecondToSample((long)end, (float)this.audioFormat.getSampleRate()));
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    public void playByte(AudioInputStream audioInputStream, long startSample, long endSample) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        log.info((Object)"play-byte");
        AudioFormat format = audioInputStream.getFormat();
        log.trace((Object)("audioFormat:" + format));
        long playByte = (endSample - startSample) * (long)format.getChannels() * 2L;
        audioInputStream.skip(startSample * (long)format.getChannels() * (long)(format.getSampleSizeInBits() / 8));
        int readBytes = 0;
        int buffersize = 1024;
        int bbyte = 64;
        byte[] bytedata = new byte[buffersize];
        long readedByte = 0L;
        boolean isStart = false;
        long playStart = 0L;
        while (readBytes != -1) {
            if (this.isStopped()) {
                this.execClose(audioInputStream);
                this.execStop();
                return;
            }
            readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
            if (readBytes <= 0) continue;
            if (!isStart) {
                this.execStart();
                playStart = System.currentTimeMillis();
                isStart = true;
            }
            if (this.isStopped()) {
                this.execClose(audioInputStream);
                this.execStop();
                return;
            }
            if (readedByte + (long)readBytes < playByte || endSample == 0L) {
                readedByte += (long)readBytes;
                this.line.write(bytedata, 0, readBytes);
                continue;
            }
            int writebyte = Math.min((int)(playByte - readedByte), readBytes);
            int p = writebyte / bbyte;
            if (writebyte % bbyte != 0) {
                ++p;
            }
            int shoudread = p * bbyte;
            log.trace((Object)("writing:" + shoudread));
            int writed = this.line.write(bytedata, 0, shoudread);
            log.trace((Object)("writed:" + writed));
            readedByte += (long)readBytes;
            break;
        }
        log.trace((Object)("readedByte:" + readedByte));
        long playsample = readedByte / (long)format.getChannels() / (long)(format.getSampleSizeInBits() / 8);
        log.trace((Object)("playsample:" + playsample));
        long playtime = WaveUtils.sampleToMillisecond((long)playsample, (float)format.getFrameRate());
        log.trace((Object)("playtime:" + playtime));
        while (System.currentTimeMillis() < playStart + playtime) {
            if (this.stopped) {
                this.execClose(audioInputStream);
                this.execStop();
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.execFinish();
    }

    public void execClose(AudioInputStream stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close();
    }

    public void execStart() {
        log.trace((Object)"start");
    }

    public void execStop() {
        log.trace((Object)"close");
    }

    public void execFinish() {
        log.info((Object)"finish");
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void open() {
        log.info((Object)"open");
        if (this.audioFile == null) {
            log.trace((Object)"audioFile=null");
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.info = new DataLine.Info(clazz, this.audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            this.line.open(this.audioFormat);
            this.line.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        log.info((Object)"close");
        if (this.line != null) {
            this.line.stop();
            this.line.close();
        }
        this.line = null;
        this.info = null;
    }

    public void stop() {
        this.stopped = true;
        Thread.interrupted();
    }

    public File getAudioFile() {
        return this.audioFile;
    }

    public void setAudioFile(File audioFile) {
        this.audioFile = audioFile;
        this.audioFormat = this.toAudioFormat(audioFile);
        log.info((Object)this.audioFormat);
    }

    private AudioFormat toAudioFormat(File audioFile2) {
        if (audioFile2 == null) {
            return null;
        }
        AudioFormat format = null;
        try {
            if (TimeBaseFileObjectReadUtils.isMP3File(this.audioFile.getName())) {
                AudioFormat mp3Format = MP3Utils.getAudioFormat((InputStream)new FileInputStream(this.audioFile));
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, mp3Format.getSampleRate(), 16, mp3Format.getChannels(), mp3Format.getChannels() * 2, mp3Format.getSampleRate(), false);
            } else {
                format = WaveUtils.getAudioFormat((File)this.audioFile);
            }
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return format;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public MultiTimeAudioListener getMultiTimeAudioListener() {
        return this.multiTimeAudioListener;
    }

    public void setMultiTimeAudioListener(MultiTimeAudioListener multiTimeAudioListener) {
        this.multiTimeAudioListener = multiTimeAudioListener;
    }

    public int getExtendTime() {
        return this.extendTime;
    }

    public void setExtendTime(int extendTime) {
        this.extendTime = extendTime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public int[] getPlayPattern() {
        return this.playPattern;
    }

    public void setPlayPattern(int[] playPattern) {
        this.playPattern = playPattern;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public class MP3Stopper
    implements AudioStopper {
        public void init() {
        }

        public boolean isStopped() {
            return MultiTimeAudioPlayer.this.stopped;
        }

        public void setStopped(boolean bool) {
        }
    }

    public class MyAudioListener
    implements AudioListener {
        public void startPlaying() {
            if (MultiTimeAudioPlayer.this.audioListener != null) {
                MultiTimeAudioPlayer.this.audioListener.startPlaying();
            }
        }

        public void stopPlaying() {
            if (MultiTimeAudioPlayer.this.audioListener != null) {
                MultiTimeAudioPlayer.this.audioListener.stopPlaying();
            }
        }

        public void finishPlaying() {
            if (MultiTimeAudioPlayer.this.audioListener != null) {
                MultiTimeAudioPlayer.this.audioListener.finishPlaying();
            }
        }
    }

    public class Stopper
    implements AudioStopper {
        public boolean isStopped() {
            return MultiTimeAudioPlayer.this.stopped;
        }

        public void setStopped(boolean bool) {
        }
    }
}

