/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.subplayer.label;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jpn.xucker.rcp.subplayer.label.LabelControler;

public class LabelMoveComposite
extends Composite {
    private LabelControler labelControler;
    private String[] targets;
    private Color[] colors;
    private String[] labels;
    private Composite colorBG;
    private CCombo labelCombo;
    private CCombo targetCombo;
    private Color nullColor = new Color(null, 236, 233, 216);
    private int lastSelection;
    private Button prevButton;
    private Button nextButton;

    public LabelMoveComposite(Composite parent, int style) {
        super(parent, style);
        ButtonClick btc = new ButtonClick();
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.prevButton = new Button((Composite)this, 16388);
        this.prevButton.addSelectionListener((SelectionListener)btc);
        this.prevButton.setLayoutData((Object)new GridData(1040));
        Composite center = new Composite((Composite)this, 0);
        this.nextButton = new Button((Composite)this, 131076);
        this.nextButton.setLayoutData((Object)new GridData(1040));
        this.nextButton.addSelectionListener((SelectionListener)btc);
        GridLayout centerLayout = new GridLayout();
        centerLayout.marginHeight = 0;
        centerLayout.marginWidth = 0;
        center.setLayout((Layout)centerLayout);
        this.targetCombo = new CCombo(center, 0);
        this.targetCombo.setLayoutData((Object)new GridData(768));
        this.targetCombo.addSelectionListener((SelectionListener)new ComboChange());
        Composite cp = new Composite(center, 0);
        cp.setSize(32, 32);
        cp.setLayout((Layout)new GridLayout(2, false));
        this.colorBG = new Composite(cp, 0);
        GridData data1 = new GridData();
        data1.heightHint = 16;
        data1.widthHint = 16;
        this.colorBG.setLayoutData((Object)data1);
        this.labelCombo = new CCombo(cp, 8);
        this.labelCombo.addSelectionListener((SelectionListener)new ComboChange());
        this.updateButtons();
    }

    public int getTarget() {
        return this.targetCombo.getSelectionIndex();
    }

    public int getLabel() {
        return this.labelCombo.getSelectionIndex();
    }

    public void comboChanged() {
        this.lastSelection = this.labelCombo.getSelectionIndex();
        if (this.colors[this.labelCombo.getSelectionIndex()] != null) {
            this.colorBG.setBackground(this.colors[this.labelCombo.getSelectionIndex()]);
        } else {
            this.colorBG.setBackground(this.nullColor);
        }
        this.colorBG.redraw();
        this.updateButtons();
        this.labelControler.changed(this.targetCombo.getSelectionIndex(), this.labelCombo.getSelectionIndex());
    }

    public void updateButtons() {
        boolean canPrev = false;
        if (this.labelControler != null) {
            canPrev = this.labelControler.canMovePrev(this.targetCombo.getSelectionIndex(), this.labelCombo.getSelectionIndex());
        }
        this.prevButton.setEnabled(canPrev);
        boolean canNext = false;
        if (this.labelControler != null) {
            canNext = this.labelControler.canMoveNext(this.targetCombo.getSelectionIndex(), this.labelCombo.getSelectionIndex());
        }
        this.nextButton.setEnabled(canNext);
    }

    public void selectLabel(int index) {
        this.labelCombo.select(index);
        this.comboChanged();
    }

    public void addTarget(String name) {
        this.targets = (String[])ArrayUtils.add((Object[])this.targets, (Object)name);
        this.targetCombo.add(name);
        if (this.targetCombo.getItemCount() == 1) {
            this.targetCombo.select(0);
        }
    }

    public void addLabel(String label, Color color) {
        this.colors = (Color[])ArrayUtils.add((Object[])this.colors, (Object)color);
        this.labels = (String[])ArrayUtils.add((Object[])this.labels, (Object)label);
        this.labelCombo.add(label);
        if (this.labelCombo.getItemCount() == 1) {
            this.labelCombo.select(0);
        }
    }

    public void initComposite() {
        this.targetCombo.removeAll();
        this.labelCombo.removeAll();
        this.colors = new Color[0];
        this.labels = new String[0];
        this.targets = new String[0];
    }

    public int getLastSelection() {
        return this.lastSelection;
    }

    public void setLastSelection(int lastSelection) {
        this.lastSelection = lastSelection;
    }

    public LabelControler getLabelControler() {
        return this.labelControler;
    }

    public void setLabelControler(LabelControler labelControler) {
        this.labelControler = labelControler;
    }

    public class ButtonClick
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (LabelMoveComposite.this.labelControler != null) {
                if (e.getSource() == LabelMoveComposite.this.prevButton) {
                    LabelMoveComposite.this.labelControler.movePrev(LabelMoveComposite.this.targetCombo.getSelectionIndex(), LabelMoveComposite.this.labelCombo.getSelectionIndex());
                } else if (e.getSource() == LabelMoveComposite.this.nextButton) {
                    LabelMoveComposite.this.labelControler.moveNext(LabelMoveComposite.this.targetCombo.getSelectionIndex(), LabelMoveComposite.this.labelCombo.getSelectionIndex());
                }
                LabelMoveComposite.this.updateButtons();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ComboChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            LabelMoveComposite.this.comboChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

