/*
 * Created on 2005/06/24
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Widget;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 *
 */
public class PlayPatternComposite extends Composite{

    public static final int PLAY=0;
    public static final int MUTE=1;
    public static final int FOREEVER=2;
    private CCombo combo;
    
    private List patternList=new ArrayList();
    private Button loop;
    PlayPatternComposite self;
    /**
     * @param parent
     * @param style
     */
    public PlayPatternComposite(Composite parent, int style) {
        
        super(parent, style);
        self=this;
        this.setLayout(new GridLayout());
        Group group=new Group(this,SWT.NULL);
        group.setText("Play Type && Loop");
        group.setLayout(new GridLayout(2,false));
        
        combo = new CCombo(group,SWT.READ_ONLY);
        for(int i=1;i<=10;i++){
        combo.add("Play "+i);
        int values[]=new int[i];
        for(int j=0;j<i;j++){
            values[j]=PLAY;
        	}
        patternList.add(values);
        }
        
        combo.add("Play 1 & Mute 1");
        patternList.add(new int[]{PLAY,MUTE});
        combo.add("Play 5 & Mute 1");
        patternList.add(new int[]{PLAY,PLAY,PLAY,PLAY,PLAY,MUTE});
        combo.add("Play 1 & Mute 1 & Play 1");
        patternList.add(new int[]{PLAY,MUTE,PLAY});
        combo.add("Mute 1 & Play 1");
        patternList.add(new int[]{MUTE,PLAY});
        combo.add("Mute 1 & Play 1 & Mute 1");
        patternList.add(new int[]{MUTE,PLAY,MUTE});
        combo.add("Mute 1");
        patternList.add(new int[]{MUTE});
        combo.select(0);
        
        loop = new Button(group,SWT.CHECK);
        loop.setText("loop");
        loop.addSelectionListener(new Unfocus());
    }
    
    public class Unfocus implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
           self.setFocus();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
        
    }

    public boolean isLoop(){
        return loop.getSelection();
    }
    public int[] getPlayPattern(){
        return (int[])patternList.get(combo.getSelectionIndex());
    }
}
