/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegJpegPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegJpegPipeWriter;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeReader;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeWriter;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FFMpegFLVFileEffector {
    private String ffmpegPath;
    private File inputFile;
    private File outputFile;
    private int bitrate = 2000;
    private FFMpegJpegPipeReader fFMpegJpegPipeReader;
    private FFMpegJpegPipeWriter fFMpegJpegPipeWriter;
    private boolean readyRead;
    private boolean readyWrite;
    private File tmpMP3;
    private int inputImageType;
    private int outputImageType;
    public static final int IMAGE_JPEG = 0;
    public static final int IMAGE_BMP = 1;
    private boolean doneRead;
    private boolean doneWrite;
    public static Log log;
    public static long doneFrames;
    private File tmpInputImage;
    private File tmpOutputImage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVFileEffector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        doneFrames = 0L;
    }

    public FFMpegFLVFileEffector(String ffmpegPath, File input, File output) {
        this.ffmpegPath = ffmpegPath;
        this.inputFile = input;
        this.outputFile = output;
    }

    public abstract void effect(File var1, File var2);

    public void start() {
        FLVInfomation info = new FFMpegFLVParser(this.ffmpegPath).parseFile(new File(this.inputFile.getAbsolutePath()));
        log.info((Object)info.toString());
        if (info.isHaveAudio()) {
            try {
                this.tmpMP3 = File.createTempFile("temp", ".mp3");
                this.tmpMP3.deleteOnExit();
                String[] mp3copy = FFMpegCommandUtil.copyAudioCommand(this.ffmpegPath, this.inputFile.getAbsolutePath(), this.tmpMP3.getAbsolutePath());
                SimpleCommandExecuter executer = new SimpleCommandExecuter(mp3copy);
                executer.execute();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fFMpegJpegPipeReader = new FFMpegJpegPipeReader(this.ffmpegPath, this.inputFile.getAbsolutePath(), new String[0]);
        this.fFMpegJpegPipeReader.setProcessListener(new IProcesListener());
        Thread t = new Thread(this.fFMpegJpegPipeReader);
        t.start();
        this.fFMpegJpegPipeWriter = info.isHaveAudio() ? new FFMpegJpegPipeWriter(this.ffmpegPath, true, new String[]{"-r", "" + info.getVideoRate()}, new String[]{"-i", this.tmpMP3.getAbsolutePath(), "-b", String.valueOf(this.bitrate) + "k", "-vcodec", "flv", "-acodec", "copy", "-r", "" + info.getVideoRate()}, this.outputFile.getAbsolutePath()) : new FFMpegJpegPipeWriter(this.ffmpegPath, true, new String[]{"-r", "" + info.getVideoRate()}, new String[]{"-b", String.valueOf(this.bitrate) + "k", "-vcodec", "flv", "-r", "" + info.getVideoRate(), "-an"}, this.outputFile.getAbsolutePath());
        System.out.println(ArrayUtils.toString((Object)this.fFMpegJpegPipeWriter.getCommand()));
        this.fFMpegJpegPipeWriter.setProcessListener(new IProcesListener2());
        Thread t2 = new Thread(this.fFMpegJpegPipeWriter);
        t2.start();
        Thread ready = new Thread(new ReadyGo());
        ready.start();
    }

    public void cancel() {
        this.fFMpegJpegPipeReader.cancel();
        this.fFMpegJpegPipeWriter.cancel();
    }

    private void fileConvert(JpegPipeReader reader, JpegPipeWriter writer) throws IOException {
        byte[] imgbyte = null;
        if (this.inputImageType == 0) {
            this.tmpInputImage = File.createTempFile("effect", ".jpg");
        } else if (this.inputImageType == 1) {
            this.tmpInputImage = File.createTempFile("effect", ".bmp");
        }
        this.tmpInputImage.deleteOnExit();
        if (this.outputImageType == 0) {
            this.tmpOutputImage = File.createTempFile("effect", ".jpg");
        } else if (this.outputImageType == 1) {
            this.tmpOutputImage = File.createTempFile("effect", ".bmp");
        }
        this.tmpOutputImage.deleteOnExit();
        doneFrames = 0L;
        while ((imgbyte = reader.nextImage()) != null) {
            log.trace((Object)("readed:" + (doneFrames + 1L) + "," + imgbyte.length + "bytes"));
            try {
                BufferedImage bimage;
                if (this.inputImageType == 0) {
                    FileUtils.writeByteArrayToFile((File)this.tmpInputImage, (byte[])imgbyte);
                } else if (this.inputImageType == 1) {
                    bimage = ImageIO.read(new ByteArrayInputStream(imgbyte));
                    log.trace((Object)("read image:" + (doneFrames + 1L)));
                    if (bimage == null) {
                        log.warn((Object)"img:null");
                        break;
                    }
                    ImageIO.write((RenderedImage)bimage, "BMP", this.tmpInputImage);
                }
                log.trace((Object)("pre effect:" + (doneFrames + 1L)));
                this.effect(this.tmpInputImage, this.tmpOutputImage);
                log.trace((Object)("effected:" + (doneFrames + 1L)));
                if (this.outputImageType == 0) {
                    writer.writeJpeg(new FileInputStream(this.tmpOutputImage));
                } else if (this.outputImageType == 1) {
                    bimage = ImageIO.read(this.tmpOutputImage);
                    writer.writeJpeg(bimage);
                }
                log.trace((Object)("writed:" + (doneFrames + 1L)));
                if (++doneFrames % 100L != 0L) continue;
                System.gc();
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
        reader.close();
        writer.close();
    }

    public int getInputImageType() {
        return this.inputImageType;
    }

    public void setInputImageType(int inputImageType) {
        this.inputImageType = inputImageType;
    }

    public int getOutputImageType() {
        return this.outputImageType;
    }

    public void setOutputImageType(int outputImageType) {
        this.outputImageType = outputImageType;
    }

    public boolean isDoneRead() {
        return this.doneRead;
    }

    public void setDoneRead(boolean doneRead) {
        this.doneRead = doneRead;
    }

    public boolean isDoneWrite() {
        return this.doneWrite;
    }

    public void setDoneWrite(boolean doneWrite) {
        this.doneWrite = doneWrite;
    }

    public FFMpegJpegPipeReader getFFMpegJpegPipeReader() {
        return this.fFMpegJpegPipeReader;
    }

    public void setFFMpegJpegPipeReader(FFMpegJpegPipeReader mpegJpegPipeReader) {
        this.fFMpegJpegPipeReader = mpegJpegPipeReader;
    }

    public FFMpegJpegPipeWriter getFFMpegJpegPipeWriter() {
        return this.fFMpegJpegPipeWriter;
    }

    public void setFFMpegJpegPipeWriter(FFMpegJpegPipeWriter mpegJpegPipeWriter) {
        this.fFMpegJpegPipeWriter = mpegJpegPipeWriter;
    }

    public class IProcesListener
    implements ProcessListener {
        public void finished() {
            FFMpegFLVFileEffector.this.doneRead = true;
        }

        public void started() {
            FFMpegFLVFileEffector.this.readyRead = true;
        }
    }

    public class IProcesListener2
    implements ProcessListener {
        public void finished() {
            FFMpegFLVFileEffector.this.doneWrite = true;
        }

        public void started() {
            FFMpegFLVFileEffector.this.readyWrite = true;
        }
    }

    public class ReadyGo
    implements Runnable {
        public void run() {
            while (!FFMpegFLVFileEffector.this.readyRead || !FFMpegFLVFileEffector.this.readyWrite) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                FFMpegFLVFileEffector.this.fileConvert(FFMpegFLVFileEffector.this.fFMpegJpegPipeReader.getJpegPipeReader(), FFMpegFLVFileEffector.this.fFMpegJpegPipeWriter.getJpegPipeWriter());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

