/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMpegFLVParser {
    private String ffmpegPath;
    public static Log log;
    private int audioIndex;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.ffmpeg.FLVInfomation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public FFMpegFLVParser(String ffmpeg) {
        this.ffmpegPath = ffmpeg;
    }

    public FLVInfomation parseFile(File file) {
        this.audioIndex = 0;
        FLVInfomation info = new FLVInfomation();
        Runtime runtime = Runtime.getRuntime();
        String[] command = new String[]{this.ffmpegPath, "-i", file.getAbsolutePath()};
        try {
            Process process = runtime.exec(command);
            SimpleProcessPrinter printer = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(process, printer);
            monitor.startMonitor();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Pattern ratePattern = Pattern.compile("Seems that stream.*-> (.*) \\(.*");
            Pattern ratePattern2 = Pattern.compile("Seems stream .* codec frame rate differs from container frame rate:.*-> (.*) \\(.*");
            Pattern videoPattern = Pattern.compile(".*Stream #.* Video:(.*)$");
            Pattern audioPattern = Pattern.compile(".*Stream #.* Audio:(.*)$");
            String[] lines = printer.getLog().split("\n");
            int i = 0;
            while (i < lines.length) {
                Matcher match = ratePattern.matcher(lines[i]);
                Matcher match2 = ratePattern2.matcher(lines[i]);
                int matchDuration = lines[i].indexOf("Duration:");
                if (match.matches()) {
                    info.setVideoRate(Double.parseDouble(match.group(1)));
                } else if (match2.matches()) {
                    info.setVideoRate(Double.parseDouble(match2.group(1)));
                } else if (matchDuration != -1) {
                    String[] d_s_b = lines[i].split(",");
                    String duration = d_s_b[0].substring(matchDuration + "Duration: ".length());
                    if (duration.equals("N/A")) {
                        duration = "00:00:00.0";
                    }
                    info.setDuration(duration);
                } else {
                    String[] values;
                    match = videoPattern.matcher(lines[i]);
                    if (match.matches()) {
                        info.setHaveVideo(true);
                        values = match.group(1).replaceAll(" ", "").split(",");
                        if (values.length >= 3) {
                            this.parseVideoCodec(info, values[0]);
                            this.parseVideoSize(info, values[2]);
                        }
                    } else {
                        match = audioPattern.matcher(lines[i]);
                        if (match.matches()) {
                            log.info((Object)lines[i]);
                            info.setHaveAudio(true);
                            values = match.group(1).replaceAll(" ", "").split(",");
                            info.setAudioCodec(values[0], this.audioIndex);
                            if (values.length > 1) {
                                int audioRate = values[1].toLowerCase().endsWith("hz") ? Integer.parseInt(values[1].substring(0, values[1].length() - 2)) : (values[1].toLowerCase().endsWith("kbhz") ? Integer.parseInt(values[1].substring(0, values[1].length() - 4)) : (values[1].toLowerCase().endsWith("kb/s") ? Integer.parseInt(values[1].substring(0, values[1].length() - 4)) : 0));
                                info.setAudioRate(audioRate, this.audioIndex);
                                if (values.length > 2) {
                                    int audioChannel = 0;
                                    if (values[2].equals("stereo")) {
                                        audioChannel = 2;
                                    } else if (values[2].equals("mono")) {
                                        audioChannel = 1;
                                    }
                                    info.setAudioChannel(audioChannel, this.audioIndex);
                                    if (values.length > 3) {
                                        int audioBitrate = Integer.parseInt(values[3].substring(0, values[3].length() - 4));
                                        info.setAudioBitrate(audioBitrate, this.audioIndex);
                                    }
                                }
                            }
                            ++this.audioIndex;
                        }
                    }
                }
                ++i;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return info;
    }

    private void parseVideoSize(FLVInfomation info, String string) {
        String[] wh = string.split("x");
        if (wh.length == 2) {
            info.setVideoWidth(Integer.parseInt(wh[0]));
            info.setVideoHeight(Integer.parseInt(wh[1]));
        }
    }

    private void parseVideoCodec(FLVInfomation info, String string) {
        if (string.equals("flv")) {
            info.setVideoCodec("flv");
        } else if (string.equals("vp6f")) {
            info.setVideoCodec("vp6f");
        }
    }
}

