/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp;

import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.psp.PSPMovieSetting;
import jp.sourceforge.akjrcp.psp.PSPMovieSettingTableViewer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PSPMovieSettingEditor
extends FieldEditor {
    private Button upButton;
    private Button downButton;
    private Button topButton;
    private Button bottomButton;
    private PSPMovieSettingTableViewer table;
    private Label label;
    private Composite menus;

    public PSPMovieSettingEditor(String key, String description, Composite parent) {
        super(key, description, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        System.out.println("adjust:" + numColumns);
    }

    private Table getTable(Composite parent) {
        if (this.table == null) {
            this.table = new PSPMovieSettingTableViewer(parent);
        }
        return this.table.getTable();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = this.getLabel(parent);
        GridData ld = new GridData();
        ld.horizontalSpan = numColumns;
        label.setLayoutData((Object)ld);
        FixComposite composite = new FixComposite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = numColumns - 1;
        composite.setLayoutData(gd);
        this.getTable(composite);
        Composite menus = this.getMenus(parent);
        menus.setLayoutData((Object)new GridData());
    }

    private Label getLabel(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 0);
            this.label.setText(this.getLabelText());
        }
        return this.label;
    }

    private Composite getMenus(Composite parent) {
        if (this.menus == null) {
            this.menus = new Composite(parent, 0);
            this.menus.setLayout((Layout)new GridLayout());
            this.topButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.top"));
            this.upButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.up"));
            this.downButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.down"));
            this.bottomButton = this.createButton(this.menus, Messages.getString("pspmoviesetting.bottom"));
        }
        return this.menus;
    }

    public Button createButton(Composite p, String label) {
        Button bt = new Button(p, 0);
        bt.setText(label);
        bt.addSelectionListener((SelectionListener)new ButtonSelect());
        bt.setLayoutData((Object)new GridData());
        return bt;
    }

    protected void doLoad() {
        PSPMovieSetting[] settings = PSPMovieSettingTableViewer.toPSPMovieSettings(this.getPreferenceStore().getString(this.getPreferenceName()));
        int i = 0;
        while (i < settings.length) {
            this.table.getMovieSettingList().add(settings[i]);
            ++i;
        }
        this.table.refresh();
    }

    protected void doLoadDefault() {
    }

    private void saveStore() {
        this.setPresentsDefaultValue(false);
        PSPMovieSetting[] infos = this.table.getMovieSettingList().toArray(new PSPMovieSetting[0]);
        this.getPreferenceStore().setValue(this.getPreferenceName(), PSPMovieSettingEditor.toStoreString(infos));
    }

    public static String toStoreString(PSPMovieSetting[] settings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < settings.length) {
            buffer.append(String.valueOf(PSPMovieSettingTableViewer.toStoreString(settings[i])) + "\n");
            ++i;
        }
        return buffer.toString();
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public class FixComposite
    extends Composite {
        public FixComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(480, 300);
        }
    }

    public class ButtonSelect
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            int index = PSPMovieSettingEditor.this.table.getTable().getSelectionIndex();
            if (e.widget == PSPMovieSettingEditor.this.topButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(0, setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.upButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(Math.max(0, index - 1), setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.downButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(Math.min(PSPMovieSettingEditor.this.table.getMovieSettingList().size(), index + 1), setting);
                PSPMovieSettingEditor.this.table.refresh();
            } else if (e.widget == PSPMovieSettingEditor.this.bottomButton) {
                PSPMovieSetting setting = (PSPMovieSetting)PSPMovieSettingEditor.this.table.getMovieSettingList().get(index);
                PSPMovieSettingEditor.this.table.getMovieSettingList().remove(setting);
                PSPMovieSettingEditor.this.table.getMovieSettingList().add(PSPMovieSettingEditor.this.table.getMovieSettingList().size(), setting);
                PSPMovieSettingEditor.this.table.refresh();
            }
            PSPMovieSettingEditor.this.saveStore();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

