/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.psp.PSPMovieSetting;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PSPMovieSettingTableViewer
extends TableViewer {
    private List movieSettingList;

    public PSPMovieSettingTableViewer(Composite parent) {
        super(parent);
        ArrayList list = new ArrayList();
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        this.setMovieSettingList(list);
    }

    public static List loadList(String value) {
        ArrayList<PSPMovieSetting> list = new ArrayList<PSPMovieSetting>();
        PSPMovieSetting[] settings = PSPMovieSettingTableViewer.toPSPMovieSettings(value);
        int i = 0;
        while (i < settings.length) {
            list.add(settings[i]);
            ++i;
        }
        return list;
    }

    public String toLabel(PSPMovieSetting setting) {
        String label = "";
        label = setting.getVideoCodec() == 0 ? String.valueOf(label) + "XVID" : String.valueOf(label) + "H264";
        if (setting.isHighQuality()) {
            label = String.valueOf(label) + "(HQ)";
        }
        label = String.valueOf(label) + " ";
        if (setting.getVideoBitrate() > 0) {
            label = String.valueOf(label) + setting.getVideoBitrate() + "kbps";
            label = String.valueOf(label) + " ";
        }
        if (setting.getVideoSize() != null) {
            label = String.valueOf(label) + setting.getVideoSize();
            label = String.valueOf(label) + " ";
        }
        if (setting.getVideoRate() > 0.0) {
            label = String.valueOf(label) + setting.getVideoRate() + "fps";
            label = String.valueOf(label) + " ";
        }
        if (setting.getAudioBitrate() > 0) {
            label = String.valueOf(label) + setting.getAudioBitrate() + "kbps";
            label = String.valueOf(label) + " ";
        }
        if (setting.getAudioChannel() > 0) {
            label = String.valueOf(label) + setting.getAudioChannel() + "ch";
            label = String.valueOf(label) + " ";
        }
        if (setting.getAudioRate() > 0) {
            label = String.valueOf(label) + setting.getAudioRate() + "hz";
            label = String.valueOf(label) + " ";
        }
        if (setting.getComment() != null && setting.getComment().length() > 0) {
            label = String.valueOf(label) + "(" + setting.getComment() + ")";
            label = String.valueOf(label) + " ";
        }
        return label;
    }

    public static PSPMovieSetting[] toPSPMovieSettings(String lines) {
        if (lines.length() == 0) {
            return new PSPMovieSetting[0];
        }
        String[] line = lines.split("\n");
        PSPMovieSetting[] infos = new PSPMovieSetting[line.length];
        int i = 0;
        while (i < infos.length) {
            infos[i] = PSPMovieSettingTableViewer.toPSPMovieSetting(line[i]);
            ++i;
        }
        return infos;
    }

    private static PSPMovieSetting toPSPMovieSetting(String text) {
        PSPMovieSetting setting = new PSPMovieSetting();
        String[] pairs = text.split("\t");
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i].indexOf("=") != -1) {
                String[] key_value = pairs[i].split("=");
                if (key_value.length == 1) {
                    System.out.println(key_value[0]);
                } else if (key_value[0].equals("codec")) {
                    setting.setVideoCodec(Integer.parseInt(key_value[1]));
                } else if (key_value[0].equals("highquality")) {
                    setting.setHighQuality(Boolean.parseBoolean(key_value[1]));
                } else if (key_value[0].equals("size")) {
                    setting.setVideoSize(key_value[1]);
                } else if (key_value[0].equals("videobitrate")) {
                    setting.setVideoBitrate(Integer.parseInt(key_value[1]));
                } else if (key_value[0].equals("videorate")) {
                    setting.setVideoRate(Double.parseDouble(key_value[1]));
                } else if (key_value[0].equals("aspectratio")) {
                    setting.setAspectRatio(key_value[1]);
                } else if (key_value[0].equals("audiobitrate")) {
                    setting.setAudioBitrate(Integer.parseInt(key_value[1]));
                } else if (key_value[0].equals("audiorate")) {
                    setting.setAudioRate(Integer.parseInt(key_value[1]));
                } else if (key_value[0].equals("audiochannel")) {
                    setting.setAudioChannel(Integer.parseInt(key_value[1]));
                } else if (key_value[0].equals("comment")) {
                    setting.setComment(key_value[1]);
                }
            } else {
                System.out.println(pairs[i]);
            }
            ++i;
        }
        return setting;
    }

    public static String toStoreString(PSPMovieSetting setting) {
        String str = "";
        str = String.valueOf(str) + "codec=" + setting.getVideoCodec();
        str = String.valueOf(str) + "\t";
        str = String.valueOf(str) + "highquality=" + setting.isHighQuality();
        str = String.valueOf(str) + "\t";
        if (setting.getVideoSize() != null) {
            str = String.valueOf(str) + "size=" + setting.getVideoSize();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getVideoBitrate() > 0) {
            str = String.valueOf(str) + "videobitrate=" + setting.getVideoBitrate();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getVideoRate() > 0.0) {
            str = String.valueOf(str) + "videorate=" + setting.getVideoRate();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getAspectRatio() != null) {
            str = String.valueOf(str) + "aspectratio=" + setting.getAspectRatio();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getAudioBitrate() > 0) {
            str = String.valueOf(str) + "audiobitrate=" + setting.getAudioBitrate();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getAudioRate() > 0) {
            str = String.valueOf(str) + "audiorate=" + setting.getAudioRate();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getAudioChannel() > 0) {
            str = String.valueOf(str) + "audiochannel=" + setting.getAudioChannel();
            str = String.valueOf(str) + "\t";
        }
        if (setting.getComment() != null) {
            str = String.valueOf(str) + "comment=" + setting.getComment();
            str = String.valueOf(str) + "\t";
        }
        return str;
    }

    public List getMovieSettingList() {
        return this.movieSettingList;
    }

    public void setMovieSettingList(List movieSettingList) {
        this.movieSettingList = movieSettingList;
        this.setInput(movieSettingList);
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return PSPMovieSettingTableViewer.this.toLabel((PSPMovieSetting)obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((List)parent).toArray();
        }
    }
}

