/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.commands;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.psp.PSPSyncView;
import jp.sourceforge.akjrcp.psp.commands.AbstractIOCommand;
import jp.sourceforge.akjrcp.util.FileCopy;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import org.apache.commons.io.FileUtils;

public class PSPMoveCommand
extends AbstractIOCommand {
    FileCopy fileCopy;

    public PSPMoveCommand(File src, File dest, boolean overwrite) {
        this.setSrcFile(src);
        this.setDestFile(dest);
        this.setOverwrite(overwrite);
    }

    public void setCanceld(boolean canceld) {
        super.setCanceld(canceld);
        if (this.fileCopy != null) {
            this.fileCopy.setCanceling(canceld);
        }
    }

    public int execCommand() {
        int result;
        int ret = 0;
        if (!this.getSrcFile().exists()) {
            ret = 1;
        }
        try {
            if (!this.getDestFile().getParentFile().canWrite()) {
                ret = 2;
                return ret;
            }
            this.fileCopy = new FileCopy(this.getSrcFile(), this.getDestFile());
            result = this.fileCopy.exec();
            if (result != 0) {
                if (this.getDestFile().exists()) {
                    this.getDestFile().delete();
                }
                ret = 4;
                return ret;
            }
            PSPSyncView.log.info((Object)"copied-movie");
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = 2;
            return ret;
        }
        result = 0;
        int i = 0;
        while (i < 3) {
            PSPSyncView.log.info((Object)("delete:" + i));
            result = this.getSrcFile().delete() ? 1 : 0;
            if (result != 0) break;
            System.gc();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (result == 0) {
            ret = 3;
            return ret;
        }
        File imgFile = new File(FileNameUtils.getChangedExtensionName(this.getSrcFile(), "jpg", true));
        if (imgFile.exists()) {
            boolean imgd;
            File newFile = new File(FileNameUtils.getChangedExtensionName(this.getDestFile(), "jpg", true));
            try {
                FileUtils.copyFile((File)imgFile, (File)newFile);
            }
            catch (IOException e) {
                PSPSyncView.log.warn((Object)"image move faild:+imgFile");
                e.printStackTrace();
            }
            if (newFile.length() == imgFile.length() && !(imgd = imgFile.delete())) {
                PSPSyncView.log.warn((Object)"image delete faild:+imgFile");
            }
        }
        return ret;
    }

    public String toString() {
        String label = this.isOverwrite() ? "Move_Overwrite:" + this.getSrcFile() + "," + this.getDestFile() : "Move:" + this.getSrcFile() + "," + this.getDestFile();
        return label;
    }
}

