/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;

public class FileNameUtils {
    public static String getChangedExtensionName(File file, String extension) {
        return FileNameUtils.getChangedExtensionName(file, extension, false);
    }

    public static String getChangedExtensionName(File file, String extension, boolean overwrite) {
        int index;
        File newFile = null;
        String baseName = null;
        if (file.getName().lastIndexOf(".") == -1) {
            baseName = file.getName();
        } else {
            index = file.getName().lastIndexOf(".");
            baseName = file.getName().substring(0, index);
        }
        newFile = new File(file.getParent(), String.valueOf(baseName) + "." + extension);
        index = 1;
        if (!overwrite) {
            while (newFile.exists()) {
                String specific = "(" + index + ")";
                newFile = new File(file.getParent(), String.valueOf(baseName) + specific + "." + extension);
                ++index;
            }
        }
        return newFile.getAbsolutePath();
    }

    public static boolean changeExtension(File file, String extension) {
        return file.renameTo(new File(FileNameUtils.getChangedExtensionName(file, extension)));
    }
}

