/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.ProgressProcessMonitor;
import jp.sourceforge.akjrcp.ffmpeg.ProgressReadListener;
import jp.sourceforge.akjrcp.videotools.BitrateViewCanvas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class BitrateViewer
extends ViewPart {
    public static Log log;
    public static final String ID;
    private Button openButton;
    Process currentProcess;
    private BitrateViewCanvas canvas;
    private String path;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.videotools.BitrateViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.videotools.BitrateViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.canvas = new BitrateViewCanvas(parent, 0);
        this.canvas.setLayoutData(new GridData(1808));
        FileControler controler = new FileControler(parent, 0);
        controler.setLayoutData(new GridData(768));
    }

    public void setFocus() {
    }

    public void openFile() {
        FileDialog dialog = new FileDialog(this.getSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.vob;*.mpg;*.avi"});
        String path = dialog.open();
        if (path != null) {
            this.openFile(path);
        }
    }

    public void debugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        System.out.println(v);
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(v) + "\n");
    }

    private void openFile(String path) {
        this.canvas.init(0);
        this.openButton.setEnabled(false);
        this.path = path;
        new ParseFile().start();
    }

    public class FileControler
    extends Composite {
        private int index;

        public FileControler(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(3, false));
            BitrateViewer.this.openButton = new Button((Composite)this, 0);
            BitrateViewer.this.openButton.setText("open");
            BitrateViewer.this.openButton.addSelectionListener((SelectionListener)new OpenFile());
            Button cancelButton = new Button((Composite)this, 0);
            cancelButton.setText("cancel");
            cancelButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ FileControler this$1;
                {
                    this.this$1 = fileControler;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (FileControler.access$0((FileControler)this.this$1).currentProcess != null) {
                        FileControler.access$0((FileControler)this.this$1).currentProcess.destroy();
                    }
                }
            });
        }

        static /* synthetic */ BitrateViewer access$0(FileControler fileControler) {
            return fileControler.BitrateViewer.this;
        }
    }

    public class ParseFile
    extends Thread {
        public void run() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("ffmpeg_path");
            FFMpegPreference preference = new FFMpegPreference();
            preference.setFfmpegPath(ffmpegPath);
            preference.setVideoCodec("copy");
            preference.setAudioCodec("copy");
            preference.setQmax(1);
            preference.setQmin(1);
            preference.setFormat("mpeg");
            String[] command = preference.toCommand(BitrateViewer.this.path, null, "-");
            Runtime runtime = Runtime.getRuntime();
            try {
                BitrateViewer.this.debugArray(command);
                BitrateViewer.this.currentProcess = runtime.exec(command);
                ProgressProcessMonitor monitor = new ProgressProcessMonitor(BitrateViewer.this.currentProcess);
                monitor.setProgressReadListener(new ProgressCheck());
                monitor.startMonitor();
                try {
                    BitrateViewer.this.currentProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BitrateViewer.this.getSite().getShell().getDisplay().syncExec((Runnable)new FinishParse());
        }
    }

    public class FinishParse
    extends Thread {
        public void run() {
            BitrateViewer.this.openButton.setEnabled(true);
        }
    }

    public class ProgressCheck
    implements ProgressReadListener {
        public void progress(String line) {
            Pattern progress = Pattern.compile(".*time=(.*)bitrate=(.*)k.*");
            Matcher match = progress.matcher(line = line.replaceAll("\n", ""));
            if (match.matches()) {
                String f = match.group(1);
                f = f.replaceAll("\\s", "");
                try {
                    double time = Double.parseDouble(f);
                    String k = match.group(2);
                    k = k.replaceAll("\\s", "");
                    double kbps = Double.parseDouble(k);
                    BitrateViewer.this.canvas.setData(0, time, kbps);
                    BitrateViewer.this.getSite().getShell().getDisplay().asyncExec((Runnable)new Redraw());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BitrateViewer.this.currentProcess.destroy();
                }
            }
            System.out.println("\"" + line + "\"");
        }
    }

    public class Redraw
    extends Thread {
        public void run() {
            BitrateViewer.this.canvas.redraw();
        }
    }

    public class OpenFile
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            BitrateViewer.this.openFile();
        }
    }
}

