/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.vobmerge;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.ui.FileSizeProgressMonitor;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.CheckToRadio;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDData;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDTitleSet;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDTitleSetComposite;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class VOBCopyMergeView
extends ViewPart {
    public static Log log;
    public static final String ID;
    DVDTitleSetComposite[] titleSetComposits;
    private Composite composite;
    private DVDData dvdData;
    private ScrolledComposite scroll;
    private Text saveFilePath;
    private Button execButton;
    private boolean actionCancel;
    private String execLabel = "    copy merge    ";
    private String cancelLabel = "cancel";
    private Button openButton;
    private boolean cancelling;
    private FileSizeProgressMonitor progressMonitor;
    private Button saveButton;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.videotools.vobmerge.VOBCopyMergeView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.videotools.vobmerge.VOBCopyMergeView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite actionPanel = new Composite(parent, 0);
        actionPanel.setLayout((Layout)new RowLayout());
        this.openButton = new Button(actionPanel, 0);
        ImageDescriptor opendirIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/opendir.gif");
        this.openButton.setImage(opendirIcon.createImage());
        this.openButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                VOBCopyMergeView.this.openDir();
            }
        });
        this.scroll = new ScrolledComposite(parent, 2560);
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        this.scroll.setLayoutData((Object)gdata);
        this.composite = new Composite((Composite)this.scroll, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.dvdData = new DVDData();
        this.scroll.setContent((Control)this.composite);
        this.scroll.setMinSize(-1, 100);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        Composite execPanel = new Composite(parent, 0);
        execPanel.setLayoutData((Object)new GridData(768));
        execPanel.setLayout((Layout)new GridLayout(3, false));
        this.execButton = new Button(execPanel, 0);
        this.execButton.setText(this.execLabel);
        this.execButton.addSelectionListener((SelectionListener)new StartExec());
        this.saveFilePath = new Text(execPanel, 8);
        this.saveFilePath.setLayoutData((Object)new GridData(768));
        this.saveButton = new Button(execPanel, 0);
        this.saveButton.setText("set save file");
        this.saveButton.addSelectionListener((SelectionListener)new SaveFile());
        this.updateExecButton();
    }

    public void dispose() {
        this.cancel();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    public void cancel() {
        this.cancelling = true;
        this.progressMonitor.setCancel(true);
    }

    public void updateExecButton() {
        if (this.saveFilePath.getText().length() == 0) {
            this.execButton.setEnabled(false);
            return;
        }
        if (this.titleSetComposits == null || this.titleSetComposits.length == 0) {
            this.execButton.setEnabled(false);
            return;
        }
        System.out.println(this.titleSetComposits.length);
        this.execButton.setEnabled(true);
    }

    public String mixCommand(File[] files) {
        String ret = "";
        int i = 0;
        while (i < files.length) {
            ret = String.valueOf(ret) + "\"" + files[i].getAbsolutePath() + "\"";
            if (i != files.length - 1) {
                ret = String.valueOf(ret) + "+";
            }
            ++i;
        }
        return ret;
    }

    public void exec(File[] files, File export) {
        boolean r;
        this.saveButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.cancelling = false;
        this.actionCancel = true;
        this.execButton.setText(this.cancelLabel);
        System.out.println(ArrayUtils.toString((Object)files));
        System.out.println(export);
        if (export.exists() && !(r = export.delete())) {
            log.warn((Object)("delete-faild:" + export));
            return;
        }
        Thread t = new Thread(new MergeFiles(files, export));
        t.start();
        this.progressMonitor = new FileSizeProgressMonitor();
        long total = 0L;
        int i = 0;
        while (i < files.length) {
            total += files[i].length();
            ++i;
        }
        this.progressMonitor.setFile(export);
        this.progressMonitor.setProgressMonitor(ProgressMonitorUtils.getProgressMonitor());
        this.progressMonitor.setMaxFileSize(total);
        this.progressMonitor.start();
    }

    public void openDir(String path) {
        if (path == null) {
            return;
        }
        Control[] cs = this.composite.getChildren();
        int i = 0;
        while (i < cs.length) {
            cs[i].dispose();
            ++i;
        }
        this.dvdData.open(new File(path));
        CheckToRadio checkToRadio = new CheckToRadio();
        DVDTitleSet[] titleSets = this.dvdData.getTitleSets();
        System.out.println("titleset:" + titleSets.length);
        this.titleSetComposits = new DVDTitleSetComposite[titleSets.length];
        int i2 = 0;
        while (i2 < titleSets.length) {
            this.titleSetComposits[i2] = new DVDTitleSetComposite(this.composite, 0, titleSets[i2], checkToRadio);
            this.titleSetComposits[i2].setLayoutData(new GridData(768));
            ++i2;
        }
        this.scroll.setMinHeight(140 * titleSets.length);
        this.scroll.pack();
        this.scroll.getParent().layout(true);
        this.updateExecButton();
    }

    public void openDir() {
        this.openButton.setEnabled(false);
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        this.openDir(path);
        this.openButton.setEnabled(true);
    }

    public void setFocus() {
    }

    public class StartExec
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (VOBCopyMergeView.this.actionCancel) {
                VOBCopyMergeView.this.cancel();
            } else {
                if (VOBCopyMergeView.this.saveFilePath.getText().length() == 0) {
                    return;
                }
                if (VOBCopyMergeView.this.titleSetComposits == null || VOBCopyMergeView.this.titleSetComposits.length == 0) {
                    return;
                }
                DVDTitleSetComposite titleSet = null;
                int i = 0;
                while (i < VOBCopyMergeView.this.titleSetComposits.length) {
                    if (VOBCopyMergeView.this.titleSetComposits[i].getSlected()) {
                        titleSet = VOBCopyMergeView.this.titleSetComposits[i];
                        break;
                    }
                    ++i;
                }
                if (titleSet != null) {
                    File[] files = titleSet.getEncodingFile();
                    VOBCopyMergeView.this.exec(files, new File(VOBCopyMergeView.this.saveFilePath.getText()));
                }
            }
        }
    }

    public class FinishExecute
    extends Thread {
        public void run() {
            VOBCopyMergeView.this.execButton.setText(VOBCopyMergeView.this.execLabel);
            VOBCopyMergeView.this.actionCancel = false;
            VOBCopyMergeView.this.saveButton.setEnabled(true);
            VOBCopyMergeView.this.openButton.setEnabled(true);
        }
    }

    public class MergeFiles
    extends Thread {
        private File[] files;
        private File export;

        public MergeFiles(File[] files, File export) {
            this.files = files;
            this.export = export;
        }

        public void run() {
            while (!VOBCopyMergeView.this.cancelling) {
                try {
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(this.export), 10240);
                    int i = 0;
                    while (i < this.files.length) {
                        int r;
                        if (VOBCopyMergeView.this.cancelling) break;
                        log.info((Object)("open:" + this.files[i]));
                        BufferedInputStream binput = new BufferedInputStream(new FileInputStream(this.files[i]), 10240);
                        byte[] bytes = new byte[1024];
                        while ((r = binput.read(bytes)) != -1) {
                            if (VOBCopyMergeView.this.cancelling) break;
                            bout.write(bytes, 0, r);
                        }
                        binput.close();
                        log.info((Object)("close:" + this.files[i]));
                        ++i;
                    }
                    bout.close();
                    break;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (VOBCopyMergeView.this.cancelling) {
                this.export.delete();
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishExecute());
        }
    }

    public class SaveFile
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.avi"});
            dialog.setFilterExtensions(new String[]{"*.vob"});
            String path = dialog.open();
            if (path != null) {
                FileOverwriteControler controler;
                boolean r;
                File f = new File(path);
                if (f.exists() && !(r = (controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).canOverwrite(f))) {
                    return;
                }
                VOBCopyMergeView.this.saveFilePath.setText(path);
            }
            VOBCopyMergeView.this.updateExecButton();
        }
    }
}

