/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class WizardStepGroup {
    private Image doneImage;
    private Image currentImage;
    private WizardStep currentStep;
    private Composite parentComposite;
    private TableViewer stepViewer;
    private ISelectionChangedListener selectionListener;

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        this.parentComposite = parent;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1040));
        composite.setFont(font);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WizardStepGroup.this.doneImage != null) {
                    WizardStepGroup.this.doneImage.dispose();
                    WizardStepGroup.this.doneImage = null;
                }
                if (WizardStepGroup.this.currentImage != null) {
                    WizardStepGroup.this.currentImage.dispose();
                    WizardStepGroup.this.currentImage = null;
                }
            }
        });
        Label label = new Label(composite, 16384);
        label.setText(IDEWorkbenchMessages.WizardStepGroup_stepsLabel);
        GridData data = new GridData();
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.stepViewer = new TableViewer(composite, 68100);
        data = new GridData(1808);
        this.stepViewer.getTable().setLayoutData((Object)data);
        this.stepViewer.getTable().setFont(font);
        this.stepViewer.setContentProvider(this.getStepProvider());
        this.stepViewer.setLabelProvider((IBaseLabelProvider)new StepLabelProvider());
        if (this.selectionListener != null) {
            this.stepViewer.addSelectionChangedListener(this.selectionListener);
        }
        return composite;
    }

    private Image createImage(String iconFileName) {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor(iconFileName);
        return desc.createImage();
    }

    private Image getCurrentImage() {
        if (this.currentImage == null) {
            this.currentImage = this.createImage("elcl16/step_current.gif");
        }
        return this.currentImage;
    }

    private Image getDoneImage() {
        if (this.doneImage == null) {
            this.doneImage = this.createImage("elcl16/step_done.gif");
        }
        return this.doneImage;
    }

    private IContentProvider getStepProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof StepRoot) {
                    return ((StepRoot)parentElement).getSteps();
                }
                return null;
            }
        };
    }

    public WizardStep[] getSteps() {
        StepRoot root;
        if (this.stepViewer != null && (root = (StepRoot)this.stepViewer.getInput()) != null) {
            return root.getSteps();
        }
        return new WizardStep[0];
    }

    public void markStepAsDone() {
        if (this.currentStep != null) {
            this.currentStep.markAsDone();
        }
    }

    public void setCurrentStep(WizardStep step) {
        WizardStep oldStep = this.currentStep;
        this.currentStep = step;
        if (this.stepViewer != null) {
            if (oldStep != null) {
                this.stepViewer.update((Object)oldStep, null);
            }
            if (this.currentStep != null) {
                this.stepViewer.update((Object)this.currentStep, null);
            }
            if (oldStep == null && this.currentStep != null) {
                this.parentComposite.layout(true);
            }
        }
    }

    public void setSelectionListener(ISelectionChangedListener listener) {
        if (this.selectionListener != null && this.stepViewer != null) {
            this.stepViewer.removeSelectionChangedListener(this.selectionListener);
        }
        this.selectionListener = listener;
        if (this.selectionListener != null && this.stepViewer != null) {
            this.stepViewer.addSelectionChangedListener(this.selectionListener);
        }
    }

    public void setSteps(WizardStep[] steps) {
        if (this.stepViewer != null) {
            this.stepViewer.setInput((Object)new StepRoot(steps));
            this.parentComposite.layout(true);
        }
    }

    private class StepLabelProvider
    extends LabelProvider {
        private StepLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof WizardStep) {
                WizardStep step = (WizardStep)element;
                return String.valueOf(String.valueOf(step.getNumber())) + ". " + step.getLabel();
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof WizardStep) {
                WizardStep step = (WizardStep)element;
                if (step.isDone()) {
                    return WizardStepGroup.this.getDoneImage();
                }
                if (step == WizardStepGroup.this.currentStep) {
                    return WizardStepGroup.this.getCurrentImage();
                }
            }
            return null;
        }
    }

    private class StepRoot {
        private WizardStep[] steps;

        public StepRoot(WizardStep[] steps) {
            this.steps = steps;
        }

        public WizardStep[] getSteps() {
            if (this.steps == null) {
                return new WizardStep[0];
            }
            return this.steps;
        }
    }
}

