/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class RelativeBendpoint
implements Bendpoint {
    private Connection connection;
    private float weight = 0.5f;
    private Dimension d1;
    private Dimension d2;

    public RelativeBendpoint() {
    }

    public RelativeBendpoint(Connection conn) {
        this.setConnection(conn);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public Point getLocation() {
        Point a1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point a2 = this.getConnection().getTargetAnchor().getReferencePoint();
        Point p = new Point();
        Dimension dim1 = this.d1.getCopy();
        Dimension dim2 = this.d2.getCopy();
        this.getConnection().translateToAbsolute(dim1);
        this.getConnection().translateToAbsolute(dim2);
        p.x = (int)((float)(a1.x + dim1.width) * (1.0f - this.weight) + this.weight * (float)(a2.x + dim2.width));
        p.y = (int)((float)(a1.y + dim1.height) * (1.0f - this.weight) + this.weight * (float)(a2.y + dim2.height));
        this.getConnection().translateToRelative(p);
        return p;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
        this.d1 = dim1;
        this.d2 = dim2;
    }

    public void setWeight(float w) {
        this.weight = w;
    }
}

